/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.common;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.catalog.BasicOperatorTable$;
import org.apache.flink.table.expressions.PlannerExpressionUtils$;
import org.apache.flink.table.expressions.ProctimeAttribute;
import org.apache.flink.table.expressions.RowtimeAttribute;
import org.apache.flink.table.expressions.WindowEnd;
import org.apache.flink.table.expressions.WindowReference;
import org.apache.flink.table.expressions.WindowStart;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.rel.LogicalWindowAggregate;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u0001\u0003\u0003\u0003\t\"\u0001G,j]\u0012|w\u000f\u0015:pa\u0016\u0014H/[3t\u0005\u0006\u001cXMU;mK*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003']i\u0011\u0001\u0006\u0006\u0003\u000fUQ!A\u0006\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0001\u0004\u0006\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u001bI,H.\u001a)sK\u0012L7-\u0019;f!\t\u0019B$\u0003\u0002\u001e)\t\t\"+\u001a7PaR\u0014V\u000f\\3Pa\u0016\u0014\u0018M\u001c3\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0001B];mK:\u000bW.\u001a\t\u0003C)r!A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0002\u0012A\u0002\u001fs_>$hHC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0019\u0001GM\u001a\u0011\u0005E\u0002Q\"\u0001\u0002\t\u000bii\u0003\u0019A\u000e\t\u000b}i\u0003\u0019\u0001\u0011\t\u000bU\u0002A\u0011\t\u001c\u0002\u000f5\fGo\u00195fgR\u0011qg\u000f\t\u0003qej\u0011AJ\u0005\u0003u\u0019\u0012qAQ8pY\u0016\fg\u000eC\u0003=i\u0001\u0007Q(\u0001\u0003dC2d\u0007CA\n?\u0013\tyDC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000b\u0005\u0003A\u0011\u0001\"\u0002%\r|gN^3si^Kg\u000eZ8x\u001d>$Wm\u001d\u000b\u0007\u0007&\u000b\u0016,Y2\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019+\u0012a\u0001:fY&\u0011\u0001*\u0012\u0002\b%\u0016dgj\u001c3f\u0011\u0015Q\u0005\t1\u0001L\u0003\u001d\u0011W/\u001b7eKJ\u0004\"\u0001T(\u000e\u00035S!AT\u000b\u0002\u000bQ|w\u000e\\:\n\u0005Ak%A\u0003*fY\n+\u0018\u000e\u001c3fe\")!\u000b\u0011a\u0001'\u00069\u0001O]8kK\u000e$\bC\u0001+X\u001b\u0005)&B\u0001,F\u0003\u001dawnZ5dC2L!\u0001W+\u0003\u001d1{w-[2bYB\u0013xN[3di\")!\f\u0011a\u00017\u00061a-\u001b7uKJ\u00042\u0001\u000f/_\u0013\tifE\u0001\u0004PaRLwN\u001c\t\u0003)~K!\u0001Y+\u0003\u001b1{w-[2bY\u001aKG\u000e^3s\u0011\u0015\u0011\u0007\t1\u0001T\u00031IgN\\3s!J|'.Z2u\u0011\u0015!\u0007\t1\u0001f\u0003\r\twm\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003\r\"T!A\u0016\u0004\n\u0005)<'A\u0006'pO&\u001c\u0017\r\\,j]\u0012|w/Q4he\u0016<\u0017\r^3\t\u000b1\u0004A\u0011B7\u0002\u001b\u001d,GoV5oI><H+\u001f9f)\tq\u0017\u000f\u0005\u00029_&\u0011\u0001O\n\u0002\u0007'fl'm\u001c7\t\u000bI\\\u0007\u0019A:\u0002\r]Lg\u000eZ8x!\t!X/D\u0001i\u0013\t1\bNA\u0007M_\u001eL7-\u00197XS:$wn\u001e\u0005\u0006q\u0002!I!_\u0001\raJ|\u0007/\u001a:us:\u000bW.\u001a\u000b\u0004Ai\\\b\"\u0002:x\u0001\u0004\u0019\b\"\u0002?x\u0001\u0004\u0001\u0013\u0001\u00028b[\u0016DQA \u0001\u0005\n}\fqC]3qY\u0006\u001cWm\u0012:pkB\fU\u000f_5mS\u0006\u0014\u0018.Z:\u0015\u0011\u0005\u0005\u0011QBA\t\u0003'\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f)\u0012a\u0001:fq&!\u00111BA\u0003\u0005\u001d\u0011V\r\u001f(pI\u0016Dq!a\u0004~\u0001\u0004\t\t!\u0001\u0003o_\u0012,\u0007\"\u0002:~\u0001\u0004\u0019\b\"\u0002&~\u0001\u0004Y\u0005bBA\f\u0001\u0011%\u0011\u0011D\u0001\u000eSN<\u0016N\u001c3poN#\u0018M\u001d;\u0015\u0007]\nY\u0002\u0003\u0005\u0002\u0010\u0005U\u0001\u0019AA\u0001\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\t1\"[:XS:$wn^#oIR\u0019q'a\t\t\u0011\u0005=\u0011Q\u0004a\u0001\u0003\u0003Aq!a\n\u0001\t\u0013\tI#A\bjg^Kg\u000eZ8x%><H/[7f)\r9\u00141\u0006\u0005\t\u0003\u001f\t)\u00031\u0001\u0002\u0002!9\u0011q\u0006\u0001\u0005\n\u0005E\u0012\u0001E5t/&tGm\\<Qe>\u001cG/[7f)\r9\u00141\u0007\u0005\t\u0003\u001f\ti\u00031\u0001\u0002\u0002\u0001")
public abstract class WindowPropertiesBaseRule
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).exists((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)WindowPropertiesBaseRule.hasGroupAuxiliaries$1(node)));
    }

    public RelNode convertWindowNodes(RelBuilder builder, LogicalProject project, Option<LogicalFilter> filter, LogicalProject innerProject, LogicalWindowAggregate agg) {
        Seq seq;
        String string;
        LogicalWindow w = agg.getWindow();
        Symbol windowType = this.getWindowType(w);
        Seq startEndProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "start"), new WindowStart(w.aliasAttribute())), new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "end"), new WindowEnd(w.aliasAttribute()))}));
        Symbol symbol = windowType;
        Option option = Symbol$.MODULE$.unapply((Object)symbol);
        if (!option.isEmpty() && "streamRowtime".equals(string = (String)option.get())) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "rowtime"), new RowtimeAttribute(w.aliasAttribute())), new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "proctime"), new ProctimeAttribute(w.aliasAttribute()))}));
        } else {
            String string2;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            if (!option2.isEmpty() && "streamProctime".equals(string2 = (String)option2.get())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "proctime"), new ProctimeAttribute(w.aliasAttribute()))}));
            } else {
                String string3;
                Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
                if (!option3.isEmpty() && "batchRowtime".equals(string3 = (String)option3.get())) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "rowtime"), new RowtimeAttribute(w.aliasAttribute()))}));
                } else {
                    throw new TableException("Unknown window type encountered. Please report this bug.");
                }
            }
        }
        Seq timeProperties = seq;
        Seq properties = (Seq)startEndProperties.$plus$plus((GenTraversableOnce)timeProperties, Seq$.MODULE$.canBuildFrom());
        builder.push(agg.copy((Seq<FlinkRelBuilder.NamedWindowProperty>)properties));
        builder.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerProject.getProjects()).$plus$plus((GenTraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)np -> builder.field(np.name()), Seq$.MODULE$.canBuildFrom()))));
        filter.foreach((Function1 & Serializable & scala.Serializable)f -> builder.filter(this.replaceGroupAuxiliaries(f.getCondition(), w, builder)));
        builder.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).map((Function1 & Serializable & scala.Serializable)expr -> this.replaceGroupAuxiliaries((RexNode)expr, w, builder), Buffer$.MODULE$.canBuildFrom())), project.getRowType().getFieldNames());
        return builder.build();
    }

    private Symbol getWindowType(LogicalWindow window) {
        CallSite callSite;
        if (PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(window.timeAttribute())) {
            callSite = SymbolLiteral.bootstrap("apply", "streamRowtime");
        } else if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(window.timeAttribute())) {
            callSite = SymbolLiteral.bootstrap("apply", "streamProctime");
        } else {
            TypeInformation<?> typeInformation = window.timeAttribute().resultType();
            TypeInformation<Timestamp> typeInformation2 = Types.SQL_TIMESTAMP();
            if (!(typeInformation != null ? !typeInformation.equals(typeInformation2) : typeInformation2 != null)) {
                callSite = SymbolLiteral.bootstrap("apply", "batchRowtime");
            } else {
                throw new TableException("Unknown window type encountered. Please report this bug.");
            }
        }
        return callSite;
    }

    private String propertyName(LogicalWindow window, String name) {
        return new StringBuilder(0).append(((WindowReference)window.aliasAttribute()).name()).append(name).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RexNode replaceGroupAuxiliaries(RexNode node, LogicalWindow window, RelBuilder builder) {
        RexBuilder rexBuilder = builder.getRexBuilder();
        Symbol windowType = this.getWindowType(window);
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (this.isWindowStart(rexCall)) {
                return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "start")), false);
            }
        }
        if (bl && this.isWindowEnd(rexCall)) {
            return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "end")), false);
        }
        if (bl && this.isWindowRowtime(rexCall)) {
            String string;
            Option option;
            String string2;
            Symbol symbol = windowType;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl2 = !option2.isEmpty() && "streamRowtime".equals(string2 = (String)option2.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "batchRowtime".equals(string = (String)option.get());
            if (!bl2) {
                Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
                if (option3.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
                String string3 = (String)option3.get();
                if (!"streamProctime".equals(string3)) throw new TableException("Unknown window type encountered. Please report this bug.");
                throw new ValidationException("A proctime window cannot provide a rowtime attribute.");
            }
            RexInputRef rexInputRef = builder.field(this.propertyName(window, "rowtime"));
            return rexInputRef;
        }
        if (bl && this.isWindowProctime(rexCall)) {
            String string;
            Option option;
            String string4;
            Symbol symbol = windowType;
            Option option4 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl3 = !option4.isEmpty() && "streamProctime".equals(string4 = (String)option4.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "streamRowtime".equals(string = (String)option.get());
            if (!bl3) {
                Option option5 = Symbol$.MODULE$.unapply((Object)symbol);
                if (option5.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
                String string5 = (String)option5.get();
                if (!"batchRowtime".equals(string5)) throw new TableException("Unknown window type encountered. Please report this bug.");
                throw new ValidationException("PROCTIME window property is not supported in batch queries.");
            }
            RexInputRef rexInputRef = builder.field(this.propertyName(window, "proctime"));
            return rexInputRef;
        }
        if (!bl) return rexNode;
        Buffer newOps = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.replaceGroupAuxiliaries((RexNode)x$1, window, builder), Buffer$.MODULE$.canBuildFrom());
        return rexCall.clone(rexCall.getType(), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(newOps));
    }

    private boolean isWindowStart(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_START();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_START();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_START();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowEnd(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_END();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_END();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_END();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowRowtime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_ROWTIME();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_ROWTIME();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_ROWTIME();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowProctime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_PROCTIME();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_PROCTIME();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_PROCTIME();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasGroupAuxiliaries$1(RexNode node2) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node2;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroupAuxiliary()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).exists((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)WindowPropertiesBaseRule.hasGroupAuxiliaries$1(node)));
    }

    public WindowPropertiesBaseRule(RelOptRuleOperand rulePredicate, String ruleName) {
        super(rulePredicate, ruleName);
    }
}

