/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.runtime.RowComparator;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.cep.CEP;
import org.apache.flink.cep.PatternStream;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.MatchCodeGenerator;
import org.apache.flink.table.codegen.MatchCodeGenerator$;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.nodes.CommonMatchRecognize;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.nodes.datastream.PatternVisitor;
import org.apache.flink.table.plan.nodes.datastream.TimeCharacteristic$;
import org.apache.flink.table.plan.rules.datastream.DataStreamRetractionRules$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.plan.util.PythonUtil$;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.RowKeySelector;
import org.apache.flink.table.runtime.RowtimeProcessFunction;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.table.runtime.conversion.CRowToRowMapFunction;
import org.apache.flink.table.runtime.match.EventRowComparator;
import org.apache.flink.table.runtime.match.PatternProcessFunctionRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u0001E\u0011q\u0002R1uCN#(/Z1n\u001b\u0006$8\r\u001b\u0006\u0003\u0007\u0011\t!\u0002Z1uCN$(/Z1n\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u0013MKgn\u001a7f%\u0016d\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005Q\u0019u.\\7p]6\u000bGo\u00195SK\u000e|wM\\5{KB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u000e\t\u0006$\u0018m\u0015;sK\u0006l'+\u001a7\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nqa\u00197vgR,'\u000f\u0005\u0002&O5\taE\u0003\u0002\b-%\u0011\u0001F\n\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011)\u0002!\u0011!Q\u0001\n-\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003K1J!!\f\u0014\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I\u0011N\u001c9vi:{G-\u001a\t\u0003'EJ!A\r\u000b\u0003\u000fI+GNT8eK\"AA\u0007\u0001B\u0001B\u0003%Q'\u0001\u0007m_\u001eL7-\u00197NCR\u001c\u0007\u000e\u0005\u00027s5\tqG\u0003\u00029\r\u00059An\\4jG\u0006d\u0017B\u0001\u001e8\u00059i\u0015\r^2i%\u0016\u001cwn\u001a8ju\u0016D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0007g\u000eDW-\\1\u0011\u0005y\u0002U\"A \u000b\u0005q2\u0011BA!@\u0005%\u0011vn^*dQ\u0016l\u0017\r\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0003-Ig\u000e];u'\u000eDW-\\1\t\u000b\u0015\u0003A\u0011\u0001$\u0002\rqJg.\u001b;?)\u001d9\u0005*\u0013&L\u00196\u0003\"a\b\u0001\t\u000b\r\"\u0005\u0019\u0001\u0013\t\u000b)\"\u0005\u0019A\u0016\t\u000b=\"\u0005\u0019\u0001\u0019\t\u000bQ\"\u0005\u0019A\u001b\t\u000bq\"\u0005\u0019A\u001f\t\u000b\r#\u0005\u0019A\u001f\t\u000b=\u0003A\u0011\t)\u000219,W\rZ:Va\u0012\fG/Z:BgJ+GO]1di&|g.F\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0001\u0005BA\u000b1cY8ogVlWm\u001d*fiJ\f7\r^5p]NDQA\u0017\u0001\u0005Bm\u000bQ\u0002Z3sSZ,'k\\<UsB,G#\u0001/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}#\u0012\u0001\u0002;za\u0016L!!\u00190\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\u0006G\u0002!\t\u0005Z\u0001\u0005G>\u0004\u0018\u0010F\u00021K\u001aDQA\u000b2A\u0002-BQa\u001a2A\u0002!\fa!\u001b8qkR\u001c\bcA5oa5\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\t1K7\u000f\u001e\u0005\u0006c\u0002!\tE]\u0001\ti>\u001cFO]5oOR\t1\u000f\u0005\u0002uw:\u0011Q/\u001f\t\u0003mNk\u0011a\u001e\u0006\u0003qB\ta\u0001\u0010:p_Rt\u0014B\u0001>T\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u001c\u0006BB@\u0001\t\u0003\n\t!\u0001\u0007fqBd\u0017-\u001b8UKJl7\u000f\u0006\u0003\u0002\u0004\u0005%\u0001cA\n\u0002\u0006%\u0019\u0011q\u0001\u000b\u0003\u0013I+Gn\u0016:ji\u0016\u0014\bbBA\u0006}\u0002\u0007\u00111A\u0001\u0003a^Dq!a\u0004\u0001\t\u0013\t\t\"\u0001\nue\u0006t7\u000f\\1uKRKW.\u001a\"pk:$G\u0003BA\n\u0003W\u0001B!!\u0006\u0002(5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003uS6,'\u0002BA\u000f\u0003?\t\u0011b^5oI><\u0018N\\4\u000b\t\u0005\u0005\u00121E\u0001\u0004CBL'bAA\u0013\u0015\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003S\t9B\u0001\u0003US6,\u0007\u0002CA\u0017\u0003\u001b\u0001\r!a\f\u0002\u0011%tG/\u001a:wC2\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k1\u0012a\u0001:fq&!\u0011\u0011HA\u001a\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"!\u0010\u0001\t\u0003Q\u0011qH\u0001\u0011iJ\fgn\u001d7bi\u0016\u0004\u0016\r\u001e;fe:$b!!\u0011\u0002v\u0005\r\u0005c\u0002*\u0002D\u0005\u001d\u00131M\u0005\u0004\u0003\u000b\u001a&A\u0002+va2,'\u0007\u0005\u0005\u0002J\u0005M\u0013qKA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013a\u00029biR,'O\u001c\u0006\u0004\u0003#R\u0011aA2fa&!\u0011QKA&\u0005\u001d\u0001\u0016\r\u001e;fe:\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;R\u0011!\u0002;za\u0016\u001c\u0018\u0002BA1\u00037\u00121AU8x!\u0015\t)'a\u001ct\u001d\u0011\t9'a\u001b\u000f\u0007Y\fI'C\u0001U\u0013\r\tigU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t(a\u001d\u0003\u0011%#XM]1cY\u0016T1!!\u001cT\u0011!\t9(a\u000fA\u0002\u0005e\u0014AB2p]\u001aLw\r\u0005\u0003\u0002|\u0005}TBAA?\u0015\r\t\t\u0003C\u0005\u0005\u0003\u0003\u000biHA\u0006UC\ndWmQ8oM&<\u0007\u0002CAC\u0003w\u0001\r!a\"\u0002\u001b%t\u0007/\u001e;UsB,\u0017J\u001c4p!\u0019\tI)!&\u0002X5\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0005usB,\u0017N\u001c4p\u0015\u0011\t\t*a%\u0002\r\r|W.\\8o\u0015\r\t\tCC\u0005\u0005\u0003/\u000bYIA\bUsB,\u0017J\u001c4pe6\fG/[8oQ\u0011\tY$a'\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000byJA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001eDq!!+\u0001\t\u0003\nY+A\bue\u0006t7\u000f\\1uKR{\u0007\u000b\\1o)\u0011\ti+!2\u0011\r\u0005=\u00161WA\\\u001b\t\t\tLC\u0002\u0004\u0003?IA!!.\u00022\nQA)\u0019;b'R\u0014X-Y7\u0011\t\u0005e\u0016\u0011Y\u0007\u0003\u0003wSA!!\u0018\u0002>*\u0019\u0011q\u0018\u0005\u0002\u000fI,h\u000e^5nK&!\u00111YA^\u0005\u0011\u0019%k\\<\t\u0011\u0005\u001d\u0017q\u0015a\u0001\u0003\u0013\fq\u0001\u001d7b]:,'\u000f\u0005\u0003\u0002L\u0006=WBAAg\u0015\r\t9\rC\u0005\u0005\u0003#\fiMA\u0007TiJ,\u0017-\u001c)mC:tWM\u001d\u0005\b\u0003+\u0004A\u0011BAl\u00039!(/\u00198tY\u0006$Xm\u0014:eKJ$\u0002\"!7\u0003\u0006\t\u001d!1\u0002\t\n%\u0006m\u0017QVAp\u0003kL1!!8T\u0005\u0019!V\u000f\u001d7fgA)!+!9\u0002f&\u0019\u00111]*\u0003\r=\u0003H/[8o!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BA`\u0003WTA!!<\u0002p\u0006IA/\u001f9fkRLGn\u001d\u0006\u0004[\u0006M\u0015\u0002BAz\u0003S\u0014QBU8x\u0007>l\u0007/\u0019:bi>\u0014\b\u0003BA|\u0003{t1aHA}\u0013\r\tYPA\u0001\u0013)&lWm\u00115be\u0006\u001cG/\u001a:jgRL7-\u0003\u0003\u0002\u0000\n\u0005!!\u0002,bYV,\u0017b\u0001B\u0002'\nYQI\\;nKJ\fG/[8o\u0011!\t9-a5A\u0002\u0005%\u0007\u0002\u0003B\u0005\u0003'\u0004\r!!,\u0002\u0013\r\u0014xn^%oaV$\b\u0002\u0003B\u0007\u0003'\u0004\rAa\u0004\u0002\u0013=\u0014H-\u001a:LKf\u001c\bcA\n\u0003\u0012%\u0019!1\u0003\u000b\u0003\u0019I+GnQ8mY\u0006$\u0018n\u001c8\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a\u0005\t\u0012\r\u001d9msB\u000b'\u000f^5uS>t\u0017N\\4\u0015\r\tm!Q\u0004B\u0016!\u0019\ty+a-\u0002X!A!q\u0004B\u000b\u0001\u0004\u0011\t#A\u0007qCJ$\u0018\u000e^5p].+\u0017p\u001d\t\u0005\u0005G\u00119#\u0004\u0002\u0003&)\u00111NF\u0005\u0005\u0005S\u0011)CA\bJ[6,H/\u00192mK\nKGoU3u\u0011!\u0011iC!\u0006A\u0002\tm\u0011aB5oaV$Hi\u001d")
public class DataStreamMatch
extends SingleRel
implements CommonMatchRecognize,
DataStreamRel {
    private final RelOptCluster cluster;
    private final MatchRecognize logicalMatch;
    private final RowSchema schema;
    private final RowSchema inputSchema;

    @Override
    public boolean producesUpdates() {
        return DataStreamRel.producesUpdates$(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public String matchToString(MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return CommonMatchRecognize.matchToString$(this, logicalMatch, fieldNames, expression);
    }

    @Override
    public RelWriter explainMatch(RelWriter pw, MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return CommonMatchRecognize.explainMatch$(this, pw, logicalMatch, fieldNames, expression);
    }

    @Override
    public boolean needsUpdatesAsRetraction() {
        return true;
    }

    @Override
    public boolean consumesRetractions() {
        return true;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataStreamMatch(this.cluster, traitSet, inputs.get(0), this.logicalMatch, this.schema, this.inputSchema);
    }

    @Override
    public String toString() {
        return this.matchToString(this.logicalMatch, this.inputSchema.fieldNames(), (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.explainMatch(super.explainTerms(pw), this.logicalMatch, this.inputSchema.fieldNames(), (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    private Time translateTimeBound(RexNode interval) {
        RexLiteral rexLiteral;
        block3: {
            block2: {
                RexNode rexNode = interval;
                if (!(rexNode instanceof RexLiteral)) break block2;
                rexLiteral = (RexLiteral)rexNode;
                SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
                SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
                if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) break block3;
            }
            throw new TableException("Only constant intervals with millisecond resolution are supported as time constraints of patterns.");
        }
        Time time = Time.milliseconds((long)Predef$.MODULE$.Long2long(rexLiteral.getValueAs(Long.class)));
        return time;
    }

    @VisibleForTesting
    public Tuple2<Pattern<Row, Row>, Iterable<String>> translatePattern(TableConfig config, TypeInformation<Row> inputTypeInfo) {
        Pattern<Row, Row> pattern;
        PatternVisitor patternVisitor = new PatternVisitor(config, inputTypeInfo, this.logicalMatch);
        if (this.logicalMatch.interval() != null) {
            Time interval = this.translateTimeBound(this.logicalMatch.interval());
            pattern = this.logicalMatch.pattern().accept(patternVisitor).within(interval);
        } else {
            pattern = this.logicalMatch.pattern().accept(patternVisitor);
        }
        Pattern<Row, Row> cepPattern = pattern;
        return new Tuple2(cepPattern, patternVisitor.names());
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        PatternStream<Row> patternStream;
        boolean inputIsAccRetract = DataStreamRetractionRules$.MODULE$.isAccRetract(this.getInput());
        TableConfig config = planner.getConfig();
        TypeInformation<Row> inputTypeInfo = this.inputSchema.typeInfo();
        DataStream<CRow> crowInput = ((DataStreamRel)this.getInput()).translateToPlan(planner);
        if (inputIsAccRetract) {
            throw new TableException("Retraction on match recognize is not supported. Note: Match recognize should not follow a non-windowed GroupBy aggregation.");
        }
        Tuple3<DataStream<CRow>, Option<RowComparator>, Enumeration.Value> tuple3 = this.translateOrder(planner, crowInput, this.logicalMatch.orderKeys());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DataStream timestampedInput = (DataStream)tuple3._1();
        Option rowComparator = (Option)tuple3._2();
        Enumeration.Value timeCharacteristic = (Enumeration.Value)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)timestampedInput, (Object)rowComparator, (Object)timeCharacteristic);
        Tuple3 tuple33 = tuple32;
        DataStream timestampedInput2 = (DataStream)tuple33._1();
        Option rowComparator2 = (Option)tuple33._2();
        Enumeration.Value timeCharacteristic2 = (Enumeration.Value)tuple33._3();
        Tuple2<Pattern<Row, Row>, Iterable<String>> tuple2 = this.translatePattern(config, inputTypeInfo);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Pattern cepPattern = (Pattern)tuple2._1();
        Iterable patternNames = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cepPattern, (Object)patternNames);
        Tuple2 tuple23 = tuple22;
        Pattern cepPattern2 = (Pattern)tuple23._1();
        Iterable patternNames2 = (Iterable)tuple23._2();
        if (NFACompiler.canProduceEmptyMatches(cepPattern2)) {
            throw new TableException("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
        }
        if (cepPattern2.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
            throw new TableException("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
        }
        SingleOutputStreamOperator inputDS = timestampedInput2.map((MapFunction)new CRowToRowMapFunction()).setParallelism(timestampedInput2.getParallelism()).name("ConvertToRow").returns(inputTypeInfo);
        ImmutableBitSet partitionKeys = this.logicalMatch.partitionKeys();
        DataStream<Row> partitionedStream = this.applyPartitioning(partitionKeys, (DataStream<Row>)inputDS);
        PatternStream<Row> tmpPatternStream = rowComparator2.isDefined() ? CEP.pattern(partitionedStream, cepPattern2, new EventRowComparator((TypeComparator<Row>)((TypeComparator)rowComparator2.get()))) : CEP.pattern(partitionedStream, cepPattern2);
        Enumeration.Value value = timeCharacteristic2;
        Enumeration.Value value2 = TimeCharacteristic$.MODULE$.ProcessingTime();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            patternStream = tmpPatternStream.inProcessingTime();
        } else {
            Enumeration.Value value3 = timeCharacteristic2;
            Enumeration.Value value4 = TimeCharacteristic$.MODULE$.EventTime();
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                patternStream = tmpPatternStream.inEventTime();
            } else {
                throw new IllegalStateException(new StringBuilder(28).append("Unknown TimeCharacteristic ").append(timeCharacteristic2).append(".").toString());
            }
        }
        PatternStream<Row> patternStream2 = patternStream;
        ImmutableMap<String, RexNode> measures = this.logicalMatch.measures();
        CRowTypeInfo outTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        if (this.logicalMatch.allRows()) {
            throw new TableException("All rows per match mode is not supported yet.");
        }
        MatchCodeGenerator generator = new MatchCodeGenerator(config, inputTypeInfo, (Seq<String>)patternNames2.toSeq(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$4());
        PatternProcessFunctionRunner patternSelectFunction = generator.generateOneRowPerMatchExpression(this.schema, partitionKeys, measures);
        return patternStream2.process(patternSelectFunction, outTypeInfo);
    }

    private Tuple3<DataStream<CRow>, Option<RowComparator>, Enumeration.Value> translateOrder(StreamPlanner planner, DataStream<CRow> crowInput, RelCollation orderKeys) {
        if (orderKeys.getFieldCollations().size() == 0) {
            throw new ValidationException("You must specify either rowtime or proctime for order by.");
        }
        RelDataTypeField timeOrderField = SortUtil$.MODULE$.getFirstSortField(orderKeys, this.inputSchema.relDataType());
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeOrderField.getType())) {
            throw new ValidationException("You must specify either rowtime or proctime for order by as the first one.");
        }
        RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(orderKeys);
        RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
        if (direction == null ? direction2 != null : !((Object)((Object)direction)).equals((Object)direction2)) {
            throw new ValidationException("Primary sort order of a streaming table must be ascending on time.");
        }
        None$ rowComparator = orderKeys.getFieldCollations().size() > 1 ? new Some((Object)SortUtil$.MODULE$.createRowComparator(this.inputSchema.relDataType(), (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orderKeys.getFieldCollations()).asScala()).tail()), planner.getExecutionEnvironment().getConfig())) : None$.MODULE$;
        RelDataType relDataType = timeOrderField.getType();
        Tuple3 tuple3 = FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeOrderField.getType()) ? new Tuple3((Object)crowInput.process((ProcessFunction)new RowtimeProcessFunction(timeOrderField.getIndex(), (TypeInformation<CRow>)CRowTypeInfo$.MODULE$.apply(this.inputSchema.typeInfo()))).setParallelism(crowInput.getParallelism()), (Object)rowComparator, (Object)TimeCharacteristic$.MODULE$.EventTime()) : new Tuple3(crowInput, (Object)rowComparator, (Object)TimeCharacteristic$.MODULE$.ProcessingTime());
        return tuple3;
    }

    private DataStream<Row> applyPartitioning(ImmutableBitSet partitionKeys, DataStream<Row> inputDs) {
        KeyedStream keyedStream;
        if (partitionKeys.size() > 0) {
            int[] keys = partitionKeys.toArray();
            RowKeySelector keySelector = new RowKeySelector(keys, this.inputSchema.projectedTypeInfo(keys));
            keyedStream = inputDs.keyBy((KeySelector)keySelector);
        } else {
            keyedStream = inputDs;
        }
        return keyedStream;
    }

    public DataStreamMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, MatchRecognize logicalMatch, RowSchema schema, RowSchema inputSchema) {
        this.cluster = cluster;
        this.logicalMatch = logicalMatch;
        this.schema = schema;
        this.inputSchema = inputSchema;
        super(cluster, traitSet, inputNode);
        CommonMatchRecognize.$init$(this);
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
        if (JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(logicalMatch.measures().values()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PythonUtil$.MODULE$.containsPythonCall(x$1, PythonUtil$.MODULE$.containsPythonCall$default$2()))) || JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(logicalMatch.patternDefinitions().values()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PythonUtil$.MODULE$.containsPythonCall(x$2, PythonUtil$.MODULE$.containsPythonCall$default$2())))) {
            throw new TableException("Python Function can not be used in MATCH_RECOGNIZE for now.");
        }
    }
}

