/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class JavaDataStreamQueryOperation<E>
implements QueryOperation {
    @Nullable
    private final ObjectIdentifier identifier;
    private final DataStream<E> dataStream;
    private final int[] fieldIndices;
    private final ResolvedSchema resolvedSchema;

    public JavaDataStreamQueryOperation(DataStream<E> dataStream, int[] fieldIndices, ResolvedSchema resolvedSchema) {
        this(null, dataStream, fieldIndices, resolvedSchema);
    }

    public JavaDataStreamQueryOperation(ObjectIdentifier identifier, DataStream<E> dataStream, int[] fieldIndices, ResolvedSchema resolvedSchema) {
        this.identifier = identifier;
        this.dataStream = dataStream;
        this.resolvedSchema = resolvedSchema;
        this.fieldIndices = fieldIndices;
    }

    public DataStream<E> getDataStream() {
        return this.dataStream;
    }

    public Optional<ObjectIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        if (this.identifier != null) {
            args.put("id", this.identifier.asSummaryString());
        } else {
            args.put("id", this.dataStream.getId());
        }
        args.put("fields", this.resolvedSchema.getColumnNames());
        return OperationUtils.formatWithChildren("DataStream", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

