/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleManager.class);
    private LinkedHashMap<String, Module> loadedModules = new LinkedHashMap();
    private List<String> usedModules = new ArrayList<String>();

    public ModuleManager() {
        this.loadedModules.put("core", CoreModule.INSTANCE);
        this.usedModules.add("core");
    }

    public void loadModule(String name, Module module) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)name) ? 1 : 0) != 0, (Object)"name cannot be null or empty string");
        Preconditions.checkNotNull((Object)module, (String)"module cannot be null");
        if (this.loadedModules.containsKey(name)) {
            throw new ValidationException(String.format("A module with name '%s' already exists", name));
        }
        this.usedModules.add(name);
        this.loadedModules.put(name, module);
        LOG.info("Loaded module '{}' from class {}", (Object)name, (Object)module.getClass().getName());
    }

    public void unloadModule(String name) {
        if (!this.loadedModules.containsKey(name)) {
            throw new ValidationException(String.format("No module with name '%s' exists", name));
        }
        this.loadedModules.remove(name);
        boolean used = this.usedModules.remove(name);
        LOG.info("Unloaded an {} module '{}'", (Object)(used ? "used" : "unused"), (Object)name);
    }

    public void useModules(String ... names) {
        Preconditions.checkNotNull((Object)names, (String)"names cannot be null");
        HashSet<String> deduplicateNames = new HashSet<String>();
        for (String name : names) {
            if (!this.loadedModules.containsKey(name)) {
                throw new ValidationException(String.format("No module with name '%s' exists", name));
            }
            if (deduplicateNames.add(name)) continue;
            throw new ValidationException(String.format("Module '%s' appears more than once", name));
        }
        this.usedModules.clear();
        this.usedModules.addAll(Arrays.asList(names));
    }

    public List<String> listModules() {
        return new ArrayList<String>(this.usedModules);
    }

    public List<ModuleEntry> listFullModules() {
        List<ModuleEntry> moduleEntries = this.usedModules.stream().map(name -> new ModuleEntry((String)name, true)).collect(Collectors.toList());
        this.loadedModules.keySet().stream().filter(name -> !this.usedModules.contains(name)).forEach(name -> moduleEntries.add(new ModuleEntry((String)name, false)));
        return moduleEntries;
    }

    public Set<String> listFunctions() {
        return this.usedModules.stream().map(name -> this.loadedModules.get(name).listFunctions()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        for (String moduleName : this.usedModules) {
            if (!this.loadedModules.get(moduleName).listFunctions().stream().anyMatch(name::equalsIgnoreCase)) continue;
            LOG.debug("Got FunctionDefinition '{}' from '{}' module.", (Object)name, (Object)moduleName);
            return this.loadedModules.get(moduleName).getFunctionDefinition(name);
        }
        LOG.debug("Cannot find FunctionDefinition '{}' from any loaded modules.", (Object)name);
        return Optional.empty();
    }

    @VisibleForTesting
    List<String> getUsedModules() {
        return this.usedModules;
    }

    @VisibleForTesting
    Map<String, Module> getLoadedModules() {
        return this.loadedModules;
    }
}

