/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.InputTypeSpec;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.TypeCoercion;
import org.apache.flink.table.util.JavaScalaConversionUtil;
import org.apache.flink.table.validate.ValidationFailure;
import org.apache.flink.table.validate.ValidationResult;

@Internal
public final class PlannerTypeInferenceUtilImpl
implements PlannerTypeInferenceUtil {
    public static final PlannerTypeInferenceUtil INSTANCE = new PlannerTypeInferenceUtilImpl();
    private static final PlannerExpressionConverter CONVERTER = PlannerExpressionConverter.INSTANCE();

    @Override
    public TypeInferenceUtil.Result runTypeInference(UnresolvedCallExpression unresolvedCall, List<ResolvedExpression> resolvedArgs) {
        PlannerExpression plannerCall = (unresolvedCall = unresolvedCall.replaceArgs(new ArrayList<Expression>(resolvedArgs))).accept(CONVERTER);
        if (plannerCall instanceof InputTypeSpec) {
            return this.resolveWithCastedAssignment(unresolvedCall, resolvedArgs, JavaScalaConversionUtil.toJava(((InputTypeSpec)((Object)plannerCall)).expectedTypes()), plannerCall.resultType());
        }
        this.validateArguments(plannerCall);
        List<DataType> expectedArgumentTypes = resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
        return new TypeInferenceUtil.Result(expectedArgumentTypes, null, TypeConversions.fromLegacyInfoToDataType(plannerCall.resultType()));
    }

    private TypeInferenceUtil.Result resolveWithCastedAssignment(UnresolvedCallExpression unresolvedCall, List<ResolvedExpression> args, List<TypeInformation<?>> expectedTypes, TypeInformation<?> resultType) {
        List plannerArgs = unresolvedCall.getChildren().stream().map(e -> e.accept(CONVERTER)).collect(Collectors.toList());
        List<DataType> castedArgs = IntStream.range(0, plannerArgs.size()).mapToObj(idx -> this.castIfNeeded((ResolvedExpression)args.get(idx), (PlannerExpression)plannerArgs.get(idx), (TypeInformation)expectedTypes.get(idx))).collect(Collectors.toList());
        return new TypeInferenceUtil.Result(castedArgs, null, TypeConversions.fromLegacyInfoToDataType(resultType));
    }

    private void validateArguments(PlannerExpression plannerCall) {
        if (!plannerCall.valid()) {
            throw new ValidationException(this.getValidationErrorMessage(plannerCall).orElse("Unexpected behavior, validation failed but can't get error messages!"));
        }
    }

    private Optional<String> getValidationErrorMessage(PlannerExpression plannerCall) {
        ValidationResult validationResult = plannerCall.validateInput();
        if (validationResult instanceof ValidationFailure) {
            return Optional.of(((ValidationFailure)validationResult).message());
        }
        for (Expression plannerExpression : plannerCall.getChildren()) {
            Optional<String> errorMessage = this.getValidationErrorMessage((PlannerExpression)plannerExpression);
            if (!errorMessage.isPresent()) continue;
            return errorMessage;
        }
        return Optional.empty();
    }

    private DataType castIfNeeded(ResolvedExpression child, PlannerExpression plannerChild, TypeInformation<?> expectedType) {
        TypeInformation<?> actualType = plannerChild.resultType();
        if (actualType.equals(expectedType)) {
            return child.getOutputDataType();
        }
        if (TypeCoercion.canSafelyCast(actualType, expectedType)) {
            return TypeConversions.fromLegacyInfoToDataType(expectedType);
        }
        throw new ValidationException(String.format("Incompatible type of argument: %s Expected: %s", child, expectedType));
    }
}

