/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporter;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporterOptions;
import org.apache.flink.metrics.reporter.InterceptInstantiationViaReflection;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterceptInstantiationViaReflection(reporterClassName="org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporter")
public class PrometheusPushGatewayReporterFactory
implements MetricReporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushGatewayReporterFactory.class);

    public PrometheusPushGatewayReporter createMetricReporter(Properties properties) {
        MetricConfig metricConfig = (MetricConfig)properties;
        String host = metricConfig.getString(PrometheusPushGatewayReporterOptions.HOST.key(), (String)PrometheusPushGatewayReporterOptions.HOST.defaultValue());
        int port = metricConfig.getInteger(PrometheusPushGatewayReporterOptions.PORT.key(), ((Integer)PrometheusPushGatewayReporterOptions.PORT.defaultValue()).intValue());
        String configuredJobName = metricConfig.getString(PrometheusPushGatewayReporterOptions.JOB_NAME.key(), (String)PrometheusPushGatewayReporterOptions.JOB_NAME.defaultValue());
        boolean randomSuffix = metricConfig.getBoolean(PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.key(), ((Boolean)PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.defaultValue()).booleanValue());
        boolean deleteOnShutdown = metricConfig.getBoolean(PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.key(), ((Boolean)PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.defaultValue()).booleanValue());
        Map<String, String> groupingKey = PrometheusPushGatewayReporterFactory.parseGroupingKey(metricConfig.getString(PrometheusPushGatewayReporterOptions.GROUPING_KEY.key(), (String)PrometheusPushGatewayReporterOptions.GROUPING_KEY.defaultValue()));
        if (host == null || host.isEmpty() || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        String jobName = configuredJobName;
        if (randomSuffix) {
            jobName = configuredJobName + new AbstractID();
        }
        LOG.info("Configured PrometheusPushGatewayReporter with {host:{}, port:{}, jobName:{}, randomJobNameSuffix:{}, deleteOnShutdown:{}, groupingKey:{}}", new Object[]{host, port, jobName, randomSuffix, deleteOnShutdown, groupingKey});
        return new PrometheusPushGatewayReporter(host, port, jobName, groupingKey, deleteOnShutdown);
    }

    @VisibleForTesting
    static Map<String, String> parseGroupingKey(String groupingKeyConfig) {
        if (!groupingKeyConfig.isEmpty()) {
            String[] kvs;
            HashMap<String, String> groupingKey = new HashMap<String, String>();
            for (String kv : kvs = groupingKeyConfig.split(";")) {
                int idx = kv.indexOf("=");
                if (idx < 0) {
                    LOG.warn("Invalid prometheusPushGateway groupingKey:{}, will be ignored", (Object)kv);
                    continue;
                }
                String labelKey = kv.substring(0, idx);
                String labelValue = kv.substring(idx + 1);
                if (StringUtils.isNullOrWhitespaceOnly((String)labelKey) || StringUtils.isNullOrWhitespaceOnly((String)labelValue)) {
                    LOG.warn("Invalid groupingKey {labelKey:{}, labelValue:{}} must not be empty", (Object)labelKey, (Object)labelValue);
                    continue;
                }
                groupingKey.put(labelKey, labelValue);
            }
            return groupingKey;
        }
        return Collections.emptyMap();
    }
}

