/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class NullableTypeStrategy
implements TypeStrategy {
    private final ConstantArgumentCount includedArguments;
    private final TypeStrategy initialStrategy;

    public NullableTypeStrategy(ConstantArgumentCount includedArguments, TypeStrategy initialStrategy) {
        this.includedArguments = (ConstantArgumentCount)Preconditions.checkNotNull((Object)includedArguments);
        this.initialStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)initialStrategy);
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        return this.initialStrategy.inferType(callContext).map(inferredDataType -> {
            List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
            if (argumentDataTypes.isEmpty()) {
                return (DataType)inferredDataType.notNull();
            }
            int fromArg = this.includedArguments.getMinCount().orElse(0);
            int toArg = Math.min(this.includedArguments.getMaxCount().map(c -> c + 1).orElse(argumentDataTypes.size()), argumentDataTypes.size());
            boolean isNullableArgument = IntStream.range(fromArg, toArg).mapToObj(argumentDataTypes::get).anyMatch(dataType2 -> dataType2.getLogicalType().isNullable());
            if (isNullableArgument) {
                return (DataType)inferredDataType.nullable();
            }
            return (DataType)inferredDataType.notNull();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableTypeStrategy that = (NullableTypeStrategy)o;
        return this.includedArguments.equals(that.includedArguments) && this.initialStrategy.equals(that.initialStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.includedArguments, this.initialStrategy);
    }
}

