/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.BinaryStringData;

@Internal
public final class StringDataSerializer
extends TypeSerializerSingleton<StringData> {
    private static final long serialVersionUID = 1L;
    public static final StringDataSerializer INSTANCE = new StringDataSerializer();

    private StringDataSerializer() {
    }

    public boolean isImmutableType() {
        return true;
    }

    public StringData createInstance() {
        return StringData.fromString("");
    }

    public StringData copy(StringData from) {
        return ((BinaryStringData)from).copy();
    }

    public StringData copy(StringData from, StringData reuse) {
        return ((BinaryStringData)from).copy();
    }

    public int getLength() {
        return -1;
    }

    public void serialize(StringData record, DataOutputView target) throws IOException {
        BinaryStringData string = (BinaryStringData)record;
        string.ensureMaterialized();
        target.writeInt(string.getSizeInBytes());
        BinarySegmentUtils.copyToView(string.getSegments(), string.getOffset(), string.getSizeInBytes(), target);
    }

    public StringData deserialize(DataInputView source) throws IOException {
        return StringDataSerializer.deserializeInternal(source);
    }

    public static StringData deserializeInternal(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return StringData.fromBytes(bytes);
    }

    public StringData deserialize(StringData record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public TypeSerializerSnapshot<StringData> snapshotConfiguration() {
        return new StringDataSerializerSnapshot();
    }

    public static final class StringDataSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<StringData> {
        public StringDataSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

