/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.UnboundedPrecedingOverFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;

public class RowUnboundedPrecedingOverFrame
extends UnboundedPrecedingOverFrame {
    private long rightBound;
    private long inputRightIndex = 0L;

    public RowUnboundedPrecedingOverFrame(GeneratedAggsHandleFunction aggsHandleFunction, long rightBound) {
        super(aggsHandleFunction);
        this.rightBound = rightBound;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        super.prepare(rows);
        this.inputRightIndex = 0L;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (this.nextRow != null && this.inputRightIndex <= (long)index + this.rightBound) {
            this.processor.accumulate(this.nextRow);
            this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
            ++this.inputRightIndex;
            bufferUpdated = true;
        }
        if (bufferUpdated) {
            this.accValue = this.processor.getValue();
        }
        return this.accValue;
    }
}

