/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.UnionStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSpec;
import org.apache.flink.util.Preconditions;

public class TableOperatorWrapperGenerator {
    private final List<Transformation<?>> inputTransforms;
    private final Transformation<?> tailTransform;
    private final int[] readOrders;
    private final List<Pair<Transformation<?>, InputSpec>> inputTransformAndInputSpecPairs;
    private final List<TableOperatorWrapper<?>> headWrappers;
    private TableOperatorWrapper<?> tailWrapper;
    private final Map<Transformation<?>, TableOperatorWrapper<?>> visitedTransforms;
    private int identifierOfSubOp = 0;
    private int parallelism;
    private int maxParallelism;
    private ResourceSpec minResources;
    private ResourceSpec preferredResources;
    private long managedMemoryWeight;

    public TableOperatorWrapperGenerator(List<Transformation<?>> inputTransforms, Transformation<?> tailTransform) {
        this(inputTransforms, tailTransform, new int[inputTransforms.size()]);
    }

    public TableOperatorWrapperGenerator(List<Transformation<?>> inputTransforms, Transformation<?> tailTransform, int[] readOrders) {
        this.inputTransforms = inputTransforms;
        this.tailTransform = tailTransform;
        this.readOrders = readOrders;
        this.inputTransformAndInputSpecPairs = new ArrayList();
        this.headWrappers = new ArrayList();
        this.visitedTransforms = new IdentityHashMap();
        this.parallelism = -1;
        this.maxParallelism = -1;
    }

    public void generate() {
        this.tailWrapper = this.visit(this.tailTransform);
        Preconditions.checkState((this.inputTransforms.size() == this.inputTransformAndInputSpecPairs.size() ? 1 : 0) != 0);
        this.calculateManagedMemoryFraction();
    }

    public List<Pair<Transformation<?>, InputSpec>> getInputTransformAndInputSpecPairs() {
        return this.inputTransformAndInputSpecPairs;
    }

    public List<TableOperatorWrapper<?>> getHeadWrappers() {
        return this.headWrappers;
    }

    public TableOperatorWrapper<?> getTailWrapper() {
        return this.tailWrapper;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public long getManagedMemoryWeight() {
        return this.managedMemoryWeight;
    }

    private TableOperatorWrapper<?> visit(Transformation<?> transform2) {
        if (!(transform2 instanceof UnionTransformation)) {
            this.calcParallelismAndResource(transform2);
        }
        return this.visitedTransforms.computeIfAbsent(transform2, this::visitTransformation);
    }

    private void calcParallelismAndResource(Transformation<?> transform2) {
        this.parallelism = Math.max(this.parallelism, transform2.getParallelism());
        int currentMaxParallelism = transform2.getMaxParallelism();
        if (this.maxParallelism < 0) {
            this.maxParallelism = currentMaxParallelism;
        } else {
            Preconditions.checkState((currentMaxParallelism < 0 || this.maxParallelism == currentMaxParallelism ? 1 : 0) != 0, (Object)"Max parallelism of a transformation in MultipleInput node is different from others. This is a bug.");
        }
        if (this.minResources == null) {
            this.minResources = transform2.getMinResources();
            this.preferredResources = transform2.getPreferredResources();
            this.managedMemoryWeight = transform2.getManagedMemoryOperatorScopeUseCaseWeights().getOrDefault(ManagedMemoryUseCase.OPERATOR, 0).intValue();
        } else {
            this.minResources = this.minResources.merge(transform2.getMinResources());
            this.preferredResources = this.preferredResources.merge(transform2.getPreferredResources());
            this.managedMemoryWeight += (long)transform2.getManagedMemoryOperatorScopeUseCaseWeights().getOrDefault(ManagedMemoryUseCase.OPERATOR, 0).intValue();
        }
    }

    private TableOperatorWrapper<?> visitTransformation(Transformation<?> transform2) {
        if (transform2 instanceof OneInputTransformation) {
            return this.visitOneInputTransformation((OneInputTransformation<RowData, RowData>)((OneInputTransformation)transform2));
        }
        if (transform2 instanceof TwoInputTransformation) {
            return this.visitTwoInputTransformation((TwoInputTransformation<RowData, RowData, RowData>)((TwoInputTransformation)transform2));
        }
        if (transform2 instanceof UnionTransformation) {
            return this.visitUnionTransformation((UnionTransformation<RowData>)((UnionTransformation)transform2));
        }
        throw new RuntimeException("Unsupported Transformation: " + transform2);
    }

    private TableOperatorWrapper<?> visitOneInputTransformation(OneInputTransformation<RowData, RowData> transform2) {
        Transformation input = (Transformation)transform2.getInputs().get(0);
        TableOperatorWrapper wrapper = new TableOperatorWrapper((StreamOperatorFactory<RowData>)transform2.getOperatorFactory(), this.genSubOperatorName((Transformation<?>)transform2), Collections.singletonList(transform2.getInputType()), transform2.getOutputType());
        int inputIdx = this.inputTransforms.indexOf(input);
        if (inputIdx >= 0) {
            this.processInput(input, inputIdx, wrapper, 1);
            this.headWrappers.add(wrapper);
        } else {
            TableOperatorWrapper<?> inputWrapper = this.visit(input);
            wrapper.addInput(inputWrapper, 1);
        }
        return wrapper;
    }

    private TableOperatorWrapper<?> visitTwoInputTransformation(TwoInputTransformation<RowData, RowData, RowData> transform2) {
        Transformation input1 = transform2.getInput1();
        Transformation input2 = transform2.getInput2();
        int inputIdx1 = this.inputTransforms.indexOf(input1);
        int inputIdx2 = this.inputTransforms.indexOf(input2);
        TableOperatorWrapper wrapper = new TableOperatorWrapper((StreamOperatorFactory<RowData>)transform2.getOperatorFactory(), this.genSubOperatorName((Transformation<?>)transform2), Arrays.asList(transform2.getInputType1(), transform2.getInputType2()), transform2.getOutputType());
        if (inputIdx1 >= 0 && inputIdx2 >= 0) {
            this.processInput(input1, inputIdx1, wrapper, 1);
            this.processInput(input2, inputIdx2, wrapper, 2);
            this.headWrappers.add(wrapper);
        } else if (inputIdx1 >= 0) {
            TableOperatorWrapper<?> inputWrapper = this.visit(input2);
            wrapper.addInput(inputWrapper, 2);
            this.processInput(input1, inputIdx1, wrapper, 1);
            this.headWrappers.add(wrapper);
        } else if (inputIdx2 >= 0) {
            TableOperatorWrapper<?> inputWrapper = this.visit(input1);
            wrapper.addInput(inputWrapper, 1);
            this.processInput(input2, inputIdx2, wrapper, 2);
            this.headWrappers.add(wrapper);
        } else {
            TableOperatorWrapper<?> inputWrapper1 = this.visit(input1);
            wrapper.addInput(inputWrapper1, 1);
            TableOperatorWrapper<?> inputWrapper2 = this.visit(input2);
            wrapper.addInput(inputWrapper2, 2);
        }
        return wrapper;
    }

    private TableOperatorWrapper<?> visitUnionTransformation(UnionTransformation<RowData> transform2) {
        TableOperatorWrapper wrapper = new TableOperatorWrapper((StreamOperatorFactory<RowData>)SimpleOperatorFactory.of((StreamOperator)new UnionStreamOperator()), this.genSubOperatorName((Transformation<?>)transform2), transform2.getInputs().stream().map(Transformation::getOutputType).collect(Collectors.toList()), transform2.getOutputType());
        int numberOfHeadInput = 0;
        for (Transformation input : transform2.getInputs()) {
            int inputIdx = this.inputTransforms.indexOf(input);
            if (inputIdx >= 0) {
                ++numberOfHeadInput;
                this.processInput(input, inputIdx, wrapper, 1);
                continue;
            }
            TableOperatorWrapper<?> inputWrapper = this.visit(input);
            wrapper.addInput(inputWrapper, 1);
        }
        if (numberOfHeadInput > 0) {
            this.headWrappers.add(wrapper);
        }
        return wrapper;
    }

    private void processInput(Transformation<?> input, int inputIdx, TableOperatorWrapper<?> outputWrapper, int outputOpInputId) {
        int inputId = this.inputTransformAndInputSpecPairs.size() + 1;
        InputSpec inputSpec = new InputSpec(inputId, this.readOrders[inputIdx], outputWrapper, outputOpInputId);
        this.inputTransformAndInputSpecPairs.add(Pair.of(input, (Object)inputSpec));
    }

    private void calculateManagedMemoryFraction() {
        for (Map.Entry<Transformation<?>, TableOperatorWrapper<?>> entry : this.visitedTransforms.entrySet()) {
            double fraction = 0.0;
            if (this.managedMemoryWeight != 0L) {
                fraction = (double)entry.getKey().getManagedMemoryOperatorScopeUseCaseWeights().getOrDefault(ManagedMemoryUseCase.OPERATOR, 0).intValue() * 1.0 / (double)this.managedMemoryWeight;
            }
            entry.getValue().setManagedMemoryFraction(fraction);
        }
    }

    private String genSubOperatorName(Transformation<?> transformation) {
        return "SubOp" + this.identifierOfSubOp++ + "_" + transformation.getName();
    }
}

