/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.util.Collector;

public class MiniBatchIncrementalGroupAggFunction
extends MapBundleFunction<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedAggsHandleFunction genPartialAggsHandler;
    private final GeneratedAggsHandleFunction genFinalAggsHandler;
    private final KeySelector<RowData, RowData> finalKeySelector;
    private final long stateRetentionTime;
    private transient JoinedRowData resultRow = new JoinedRowData();
    private transient AggsHandleFunction partialAgg = null;
    private transient AggsHandleFunction finalAgg = null;

    public MiniBatchIncrementalGroupAggFunction(GeneratedAggsHandleFunction genPartialAggsHandler, GeneratedAggsHandleFunction genFinalAggsHandler, KeySelector<RowData, RowData> finalKeySelector, long stateRetentionTime) {
        this.genPartialAggsHandler = genPartialAggsHandler;
        this.genFinalAggsHandler = genFinalAggsHandler;
        this.finalKeySelector = finalKeySelector;
        this.stateRetentionTime = stateRetentionTime;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ClassLoader classLoader = ctx.getRuntimeContext().getUserCodeClassLoader();
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(this.stateRetentionTime);
        this.partialAgg = (AggsHandleFunction)this.genPartialAggsHandler.newInstance(classLoader);
        this.partialAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.finalAgg = (AggsHandleFunction)this.genFinalAggsHandler.newInstance(classLoader);
        this.finalAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext(), ttlConfig));
        this.resultRow = new JoinedRowData();
    }

    @Override
    public RowData addInput(@Nullable RowData previousAcc, RowData input) throws Exception {
        RowData currentAcc = previousAcc == null ? this.partialAgg.createAccumulators() : previousAcc;
        this.partialAgg.setAccumulators(currentAcc);
        this.partialAgg.merge(input);
        return this.partialAgg.getAccumulators();
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        HashMap<RowData, Map> finalAggBuffer = new HashMap<RowData, Map>();
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData partialKey = entry.getKey();
            RowData finalKey = (RowData)this.finalKeySelector.getKey((Object)partialKey);
            RowData partialAcc = entry.getValue();
            Map map = finalAggBuffer.computeIfAbsent(finalKey, r -> new HashMap());
            map.put(partialKey, partialAcc);
        }
        for (Map.Entry<RowData, RowData> entry : finalAggBuffer.entrySet()) {
            RowData finalKey = entry.getKey();
            Map accMap = (Map)((Object)entry.getValue());
            this.finalAgg.resetAccumulators();
            for (Map.Entry entry2 : accMap.entrySet()) {
                RowData partialKey = (RowData)entry2.getKey();
                RowData partialAcc = (RowData)entry2.getValue();
                this.ctx.setCurrentKey(partialKey);
                this.finalAgg.merge(partialAcc);
            }
            RowData finalAcc = this.finalAgg.getAccumulators();
            this.resultRow.replace(finalKey, finalAcc);
            out.collect((Object)this.resultRow);
        }
        finalAggBuffer.clear();
    }

    @Override
    public void close() throws Exception {
        if (this.partialAgg != null) {
            this.partialAgg.close();
        }
        if (this.finalAgg != null) {
            this.finalAgg.close();
        }
    }
}

