/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.Optional;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.ExpressionFormat$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WindowJoinUtil$ {
    public static final WindowJoinUtil$ MODULE$;

    static {
        new WindowJoinUtil$();
    }

    public Tuple2<RelWindowProperties, RelWindowProperties> getChildWindowProperties(FlinkLogicalJoin join) {
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(join.getCluster().getMetadataQuery());
        return new Tuple2((Object)fmq.getRelWindowProperties(join.getLeft()), (Object)fmq.getRelWindowProperties(join.getRight()));
    }

    public boolean containsWindowStartEqualityAndEndEquality(FlinkLogicalJoin join) {
        Tuple4<int[], int[], int[], int[]> tuple4 = this.excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(join);
        if (tuple4 != null) {
            Tuple2 tuple2;
            int[] windowStartEqualityLeftKeys = (int[])tuple4._1();
            int[] windowEndEqualityLeftKeys = (int[])tuple4._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)windowStartEqualityLeftKeys, (Object)windowEndEqualityLeftKeys);
            int[] windowStartEqualityLeftKeys2 = (int[])tuple22._1();
            int[] windowEndEqualityLeftKeys2 = (int[])tuple22._2();
            return Predef$.MODULE$.intArrayOps(windowStartEqualityLeftKeys2).nonEmpty() && Predef$.MODULE$.intArrayOps(windowEndEqualityLeftKeys2).nonEmpty();
        }
        throw new MatchError(tuple4);
    }

    public Tuple7<int[], int[], int[], int[], int[], int[], RexNode> excludeWindowStartEqualityAndEndEqualityFromJoinCondition(FlinkLogicalJoin join) {
        Tuple4<int[], int[], int[], int[]> tuple4 = this.excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(join);
        if (tuple4 != null) {
            Tuple3 tuple3;
            Tuple3 tuple32;
            Tuple4 tuple42;
            int[] windowStartEqualityLeftKeys = (int[])tuple4._1();
            int[] windowEndEqualityLeftKeys = (int[])tuple4._2();
            int[] windowStartEqualityRightKeys = (int[])tuple4._3();
            int[] windowEndEqualityRightKeys = (int[])tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)windowStartEqualityLeftKeys, (Object)windowEndEqualityLeftKeys, (Object)windowStartEqualityRightKeys, (Object)windowEndEqualityRightKeys);
            int[] windowStartEqualityLeftKeys2 = (int[])tuple43._1();
            int[] windowEndEqualityLeftKeys2 = (int[])tuple43._2();
            int[] windowStartEqualityRightKeys2 = (int[])tuple43._3();
            int[] windowEndEqualityRightKeys2 = (int[])tuple43._4();
            JoinSpec joinSpec = JoinUtil$.MODULE$.createJoinSpec(join);
            if (Predef$.MODULE$.intArrayOps(windowStartEqualityLeftKeys2).nonEmpty() || Predef$.MODULE$.intArrayOps(windowEndEqualityLeftKeys2).nonEmpty()) {
                java.util.List<RelDataTypeField> leftChildFieldsType = join.getLeft().getRowType().getFieldList();
                java.util.List<RelDataTypeField> rightChildFieldsType = join.getRight().getRowType().getFieldList();
                int leftFieldCnt = join.getLeft().getRowType().getFieldCount();
                RexBuilder rexBuilder = join.getCluster().getRexBuilder();
                ArrayBuffer remainingConditions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                ArrayBuffer remainLeftKeysArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                ArrayBuffer remainRightKeysArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(joinSpec.getLeftKeys()).zip((GenIterable)Predef$.MODULE$.wrapIntArray(joinSpec.getRightKeys()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray(joinSpec.getFilterNulls()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(windowStartEqualityLeftKeys2, windowEndEqualityLeftKeys2, leftChildFieldsType, rightChildFieldsType, leftFieldCnt, rexBuilder, remainingConditions, remainLeftKeysArray, remainRightKeysArray){
                    public static final long serialVersionUID = 0L;
                    private final int[] windowStartEqualityLeftKeys$1;
                    private final int[] windowEndEqualityLeftKeys$1;
                    private final java.util.List leftChildFieldsType$1;
                    private final java.util.List rightChildFieldsType$1;
                    private final int leftFieldCnt$1;
                    private final RexBuilder rexBuilder$1;
                    private final ArrayBuffer remainingConditions$1;
                    private final ArrayBuffer remainLeftKeysArray$1;
                    private final ArrayBuffer remainRightKeysArray$1;

                    public final Object apply(Tuple2<Tuple2<Object, Object>, Object> x0$1) {
                        Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            boolean filterNull = tuple2._2$mcZ$sp();
                            if (tuple22 != null) {
                                BoxedUnit boxedUnit;
                                int source = tuple22._1$mcI$sp();
                                int target = tuple22._2$mcI$sp();
                                if (Predef$.MODULE$.intArrayOps(this.windowStartEqualityLeftKeys$1).contains((Object)BoxesRunTime.boxToInteger((int)source)) || Predef$.MODULE$.intArrayOps(this.windowEndEqualityLeftKeys$1).contains((Object)BoxesRunTime.boxToInteger((int)source))) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    RelDataType leftFieldType = ((RelDataTypeField)this.leftChildFieldsType$1.get(source)).getType();
                                    RexInputRef leftInputRef = new RexInputRef(source, leftFieldType);
                                    RelDataType rightFieldType = ((RelDataTypeField)this.rightChildFieldsType$1.get(target)).getType();
                                    int rightIndex = this.leftFieldCnt$1 + target;
                                    RexInputRef rightInputRef = new RexInputRef(rightIndex, rightFieldType);
                                    SqlBinaryOperator op = filterNull ? SqlStdOperatorTable.EQUALS : SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
                                    RexNode remainEqual = this.rexBuilder$1.makeCall((SqlOperator)op, leftInputRef, rightInputRef);
                                    this.remainingConditions$1.$plus$eq((Object)remainEqual);
                                    this.remainLeftKeysArray$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)source));
                                    boxedUnit = this.remainRightKeysArray$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)target));
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.windowStartEqualityLeftKeys$1 = windowStartEqualityLeftKeys$1;
                        this.windowEndEqualityLeftKeys$1 = windowEndEqualityLeftKeys$1;
                        this.leftChildFieldsType$1 = leftChildFieldsType$1;
                        this.rightChildFieldsType$1 = rightChildFieldsType$1;
                        this.leftFieldCnt$1 = leftFieldCnt$1;
                        this.rexBuilder$1 = rexBuilder$1;
                        this.remainingConditions$1 = remainingConditions$1;
                        this.remainLeftKeysArray$1 = remainLeftKeysArray$1;
                        this.remainRightKeysArray$1 = remainRightKeysArray$1;
                    }
                });
                Optional<RexNode> notEquiCondition = joinSpec.getNonEquiCondition();
                Object object = notEquiCondition.isPresent() ? remainingConditions.$plus$eq((Object)notEquiCondition.get()) : BoxedUnit.UNIT;
                tuple32 = new Tuple3(remainLeftKeysArray.toArray(ClassTag$.MODULE$.Int()), remainRightKeysArray.toArray(ClassTag$.MODULE$.Int()), (Object)RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.seqAsJavaList((Seq)remainingConditions.toList())));
            } else {
                tuple32 = tuple3 = new Tuple3((Object)joinSpec.getLeftKeys(), (Object)joinSpec.getRightKeys(), (Object)join.getCondition());
            }
            if (tuple3 != null) {
                Tuple3 tuple33;
                int[] remainLeftKeys = (int[])tuple3._1();
                int[] remainRightKeys = (int[])tuple3._2();
                RexNode remainCondition = (RexNode)tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)remainLeftKeys, (Object)remainRightKeys, (Object)remainCondition);
                int[] remainLeftKeys2 = (int[])tuple34._1();
                int[] remainRightKeys2 = (int[])tuple34._2();
                RexNode remainCondition2 = (RexNode)tuple34._3();
                return new Tuple7((Object)windowStartEqualityLeftKeys2, (Object)windowEndEqualityLeftKeys2, (Object)windowStartEqualityRightKeys2, (Object)windowEndEqualityRightKeys2, (Object)remainLeftKeys2, (Object)remainRightKeys2, (Object)remainCondition2);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError(tuple4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple4<int[], int[], int[], int[]> excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(FlinkLogicalJoin join) {
        Tuple2 tuple2;
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2<RelWindowProperties, RelWindowProperties> tuple22 = this.getChildWindowProperties(join);
        if (tuple22 == null) throw new MatchError(tuple22);
        RelWindowProperties leftWindowProperties = (RelWindowProperties)tuple22._1();
        RelWindowProperties rightWindowProperties = (RelWindowProperties)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)leftWindowProperties, (Object)rightWindowProperties);
        RelWindowProperties leftWindowProperties2 = (RelWindowProperties)tuple23._1();
        RelWindowProperties rightWindowProperties2 = (RelWindowProperties)tuple23._2();
        ArrayBuffer windowStartEqualityLeftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowEndEqualityLeftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowStartEqualityRightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowEndEqualityRightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (leftWindowProperties2 != null && rightWindowProperties2 != null) {
            ImmutableBitSet leftWindowStartColumns = leftWindowProperties2.getWindowStartColumns();
            ImmutableBitSet rightWindowStartColumns = rightWindowProperties2.getWindowStartColumns();
            ImmutableBitSet leftWindowEndColumns = leftWindowProperties2.getWindowEndColumns();
            ImmutableBitSet rightWindowEndColumns = rightWindowProperties2.getWindowEndColumns();
            JavaConversions$.MODULE$.asScalaBuffer(joinInfo.pairs()).foreach((Function1)new Serializable(windowStartEqualityLeftKeys, windowEndEqualityLeftKeys, windowStartEqualityRightKeys, windowEndEqualityRightKeys, leftWindowStartColumns, rightWindowStartColumns, leftWindowEndColumns, rightWindowEndColumns){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer windowStartEqualityLeftKeys$2;
                private final ArrayBuffer windowEndEqualityLeftKeys$2;
                private final ArrayBuffer windowStartEqualityRightKeys$1;
                private final ArrayBuffer windowEndEqualityRightKeys$1;
                private final ImmutableBitSet leftWindowStartColumns$1;
                private final ImmutableBitSet rightWindowStartColumns$1;
                private final ImmutableBitSet leftWindowEndColumns$1;
                private final ImmutableBitSet rightWindowEndColumns$1;

                public final Object apply(IntPair pair) {
                    Object object;
                    int leftKey = pair.source;
                    int rightKey = pair.target;
                    if (this.leftWindowStartColumns$1.get(leftKey) && this.rightWindowStartColumns$1.get(rightKey)) {
                        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.windowStartEqualityLeftKeys$2).add(BoxesRunTime.boxToInteger((int)leftKey));
                        object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.windowStartEqualityRightKeys$1).add(BoxesRunTime.boxToInteger((int)rightKey)));
                    } else if (this.leftWindowEndColumns$1.get(leftKey) && this.rightWindowEndColumns$1.get(rightKey)) {
                        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.windowEndEqualityLeftKeys$2).add(BoxesRunTime.boxToInteger((int)leftKey));
                        object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.windowEndEqualityRightKeys$1).add(BoxesRunTime.boxToInteger((int)rightKey)));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                {
                    this.windowStartEqualityLeftKeys$2 = windowStartEqualityLeftKeys$2;
                    this.windowEndEqualityLeftKeys$2 = windowEndEqualityLeftKeys$2;
                    this.windowStartEqualityRightKeys$1 = windowStartEqualityRightKeys$1;
                    this.windowEndEqualityRightKeys$1 = windowEndEqualityRightKeys$1;
                    this.leftWindowStartColumns$1 = leftWindowStartColumns$1;
                    this.rightWindowStartColumns$1 = rightWindowStartColumns$1;
                    this.leftWindowEndColumns$1 = leftWindowEndColumns$1;
                    this.rightWindowEndColumns$1 = rightWindowEndColumns$1;
                }
            });
        }
        if (windowStartEqualityLeftKeys.nonEmpty() && windowEndEqualityLeftKeys.nonEmpty()) {
            LogicalType logicalType = leftWindowProperties2.getTimeAttributeType();
            LogicalType logicalType2 = rightWindowProperties2.getTimeAttributeType();
            if (logicalType != null ? !((Object)logicalType).equals(logicalType2) : logicalType2 != null) throw new TableException(new StringBuilder().append((Object)"Currently, window join doesn't support different time attribute type of left and right inputs.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The left time attribute type is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftWindowProperties2.getTimeAttributeType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The right time attribute type is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightWindowProperties2.getTimeAttributeType()}))).toString());
            WindowSpec windowSpec = leftWindowProperties2.getWindowSpec();
            WindowSpec windowSpec2 = rightWindowProperties2.getWindowSpec();
            if (!(windowSpec == null ? windowSpec2 != null : !windowSpec.equals(windowSpec2))) return new Tuple4(windowStartEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowStartEqualityRightKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityRightKeys.toArray(ClassTag$.MODULE$.Int()));
            throw new TableException(new StringBuilder().append((Object)"Currently, window join doesn't support different window table function of left and right inputs.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The left window table function is ", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftWindowProperties2.getWindowSpec()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The right window table function is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightWindowProperties2.getWindowSpec()}))).toString());
        }
        if (!windowStartEqualityLeftKeys.nonEmpty() && !windowEndEqualityLeftKeys.nonEmpty()) return new Tuple4(windowStartEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowStartEqualityRightKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityRightKeys.toArray(ClassTag$.MODULE$.Int()));
        List leftFieldNames = JavaConversions$.MODULE$.asScalaBuffer(join.getLeft().getRowType().getFieldNames()).toList();
        List rightFieldNames = JavaConversions$.MODULE$.asScalaBuffer(join.getRight().getRowType().getFieldNames()).toList();
        List inputFieldNames = (List)leftFieldNames.$plus$plus((GenTraversableOnce)rightFieldNames, List$.MODULE$.canBuildFrom());
        String condition = join.getExpressionString(join.getCondition(), (List<String>)inputFieldNames, (Option<List<RexNode>>)None$.MODULE$, ExpressionFormat$.MODULE$.Infix());
        throw new TableException(new StringBuilder().append((Object)"Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"But the current JOIN ON condition is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition}))).toString());
    }

    private WindowJoinUtil$() {
        MODULE$ = this;
    }
}

