/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalSortAggregate;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalAggRuleBase;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalAggRuleBase$;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public abstract class BatchPhysicalAggRuleBase$class {
    public static RelDataType inferLocalAggType(BatchPhysicalAggRuleBase $this, RelDataType inputRowType, Aggregate agg, int[] groupSet, int[] auxGroupSet, UserDefinedFunction[] aggFunctions, LogicalType[][] aggBufferTypes) {
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)agg.getCluster().getTypeFactory();
        String[] aggCallNames = (String[])JavaConversions$.MODULE$.asScalaBuffer(Util.skip(agg.getRowType().getFieldNames(), groupSet.length + auxGroupSet.length)).toList().toArray(ClassTag$.MODULE$.apply(String.class));
        return $this.inferLocalAggType(inputRowType, typeFactory, aggCallNames, groupSet, auxGroupSet, aggFunctions, aggBufferTypes);
    }

    public static RelDataType inferLocalAggType(BatchPhysicalAggRuleBase $this, RelDataType inputRowType, FlinkTypeFactory typeFactory, String[] aggCallNames, int[] groupSet, int[] auxGroupSet, UserDefinedFunction[] aggFunctions, LogicalType[][] aggBufferTypes) {
        String[][] aggBufferFieldNames = new String[aggFunctions.length][];
        IntRef index = IntRef.create((int)-1);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])aggFunctions).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable($this, aggBufferFieldNames, index, aggCallNames){
            public static final long serialVersionUID = 0L;
            private final String[][] aggBufferFieldNames$1;
            public final IntRef index$1;
            private final String[] aggCallNames$1;

            public final void apply(Tuple2<UserDefinedFunction, Object> x0$1) {
                Tuple2<UserDefinedFunction, Object> tuple2;
                block4: {
                    UserDefinedFunction userDefinedFunction;
                    block7: {
                        String[] stringArray;
                        block6: {
                            block5: {
                                tuple2 = x0$1;
                                if (tuple2 == null) break block4;
                                UserDefinedFunction udf = (UserDefinedFunction)tuple2._1();
                                int aggIndex = tuple2._2$mcI$sp();
                                userDefinedFunction = udf;
                                if (!(userDefinedFunction instanceof AggregateFunction)) break block5;
                                stringArray = (String[])((Object[])new String[]{this.aggCallNames$1[aggIndex]});
                                break block6;
                            }
                            if (!(userDefinedFunction instanceof DeclarativeAggregateFunction)) break block7;
                            DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                            stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.aggBufferAttributes()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BatchPhysicalAggRuleBase$.anonfun.inferLocalAggType.1 $outer;

                                public final String apply(UnresolvedReferenceExpression attr) {
                                    ++this.$outer.index$1.elem;
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.getName(), BoxesRunTime.boxToInteger((int)this.$outer.index$1.elem)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        }
                        this.aggBufferFieldNames$1[aggIndex] = stringArray;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    if (userDefinedFunction != null) {
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't get localAgg merge name"})).s((Seq)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)userDefinedFunction);
                }
                throw new MatchError(tuple2);
            }
            {
                this.aggBufferFieldNames$1 = aggBufferFieldNames$1;
                this.index$1 = index$1;
                this.aggCallNames$1 = aggCallNames$1;
            }
        });
        RelDataType[] aggBufferSqlTypes = (RelDataType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes).flatten((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<LogicalType> apply(LogicalType[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(LogicalType.class))).map((Function1)new Serializable($this, typeFactory){
            public static final long serialVersionUID = 0L;
            private final FlinkTypeFactory typeFactory$1;

            public final RelDataType apply(LogicalType t) {
                boolean nullable = !FlinkTypeFactory$.MODULE$.isTimeIndicatorType(t);
                return this.typeFactory$1.createFieldTypeFromLogicalType(t);
            }
            {
                this.typeFactory$1 = typeFactory$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)));
        List localAggFieldTypes = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable($this, inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final RelDataType apply(int x$1) {
                return this.inputRowType$1.getFieldList().get(x$1).getType();
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(auxGroupSet).map((Function1)new Serializable($this, inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final RelDataType apply(int x$2) {
                return this.inputRowType$1.getFieldList().get(x$2).getType();
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])aggBufferSqlTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).toList();
        List localAggFieldNames = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable($this, inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final String apply(int x$3) {
                return this.inputRowType$1.getFieldList().get(x$3).getName();
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(auxGroupSet).map((Function1)new Serializable($this, inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final String apply(int x$4) {
                return this.inputRowType$1.getFieldList().get(x$4).getName();
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])aggBufferFieldNames).flatten((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<String> apply(String[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(String.class))).toArray(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
        return typeFactory.createStructType(JavaConversions$.MODULE$.seqAsJavaList((Seq)localAggFieldTypes), JavaConversions$.MODULE$.seqAsJavaList((Seq)localAggFieldNames));
    }

    public static boolean isTwoPhaseAggWorkable(BatchPhysicalAggRuleBase $this, UserDefinedFunction[] aggFunctions, TableConfig tableConfig) {
        AggregatePhaseStrategy aggregatePhaseStrategy = TableConfigUtils.getAggPhaseStrategy(tableConfig);
        boolean bl = ((Object)((Object)AggregatePhaseStrategy.ONE_PHASE)).equals((Object)aggregatePhaseStrategy) ? false : $this.doAllSupportMerge(aggFunctions);
        return bl;
    }

    public static boolean isOnePhaseAggWorkable(BatchPhysicalAggRuleBase $this, Aggregate agg, UserDefinedFunction[] aggFunctions, TableConfig tableConfig) {
        AggregatePhaseStrategy aggregatePhaseStrategy;
        block6: {
            boolean bl;
            block4: {
                RelMetadataQuery mq;
                block5: {
                    block3: {
                        aggregatePhaseStrategy = TableConfigUtils.getAggPhaseStrategy(tableConfig);
                        if (!((Object)((Object)AggregatePhaseStrategy.ONE_PHASE)).equals((Object)aggregatePhaseStrategy)) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!((Object)((Object)AggregatePhaseStrategy.TWO_PHASE)).equals((Object)aggregatePhaseStrategy)) break block5;
                    bl = !$this.doAllSupportMerge(aggFunctions);
                    break block4;
                }
                if (!((Object)((Object)AggregatePhaseStrategy.AUTO)).equals((Object)aggregatePhaseStrategy)) break block6;
                bl = $this.doAllSupportMerge(aggFunctions) ? (mq = agg.getCluster().getMetadataQuery()).getDistinctRowCount(agg.getInput(), agg.getGroupSet(), null) != null : true;
            }
            return bl;
        }
        throw new MatchError((Object)aggregatePhaseStrategy);
    }

    public static boolean doAllSupportMerge(BatchPhysicalAggRuleBase $this, UserDefinedFunction[] aggFunctions) {
        boolean supportLocalAgg = Predef$.MODULE$.refArrayOps((Object[])aggFunctions).forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UserDefinedFunction x0$2) {
                UserDefinedFunction userDefinedFunction = x0$2;
                boolean bl = userDefinedFunction instanceof DeclarativeAggregateFunction ? true : UserDefinedFunctionUtils$.MODULE$.ifMethodExistInFunction("merge", userDefinedFunction);
                return bl;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])aggFunctions).isEmpty() || supportLocalAgg;
    }

    public static boolean isEnforceOnePhaseAgg(BatchPhysicalAggRuleBase $this, TableConfig tableConfig) {
        AggregatePhaseStrategy aggregatePhaseStrategy = TableConfigUtils.getAggPhaseStrategy(tableConfig);
        AggregatePhaseStrategy aggregatePhaseStrategy2 = AggregatePhaseStrategy.ONE_PHASE;
        return !(aggregatePhaseStrategy != null ? !((Object)((Object)aggregatePhaseStrategy)).equals((Object)aggregatePhaseStrategy2) : aggregatePhaseStrategy2 != null);
    }

    public static boolean isEnforceTwoPhaseAgg(BatchPhysicalAggRuleBase $this, TableConfig tableConfig) {
        AggregatePhaseStrategy aggregatePhaseStrategy = TableConfigUtils.getAggPhaseStrategy(tableConfig);
        AggregatePhaseStrategy aggregatePhaseStrategy2 = AggregatePhaseStrategy.TWO_PHASE;
        return !(aggregatePhaseStrategy != null ? !((Object)((Object)aggregatePhaseStrategy)).equals((Object)aggregatePhaseStrategy2) : aggregatePhaseStrategy2 != null);
    }

    public static boolean isAggBufferFixedLength(BatchPhysicalAggRuleBase $this, Aggregate agg) {
        Tuple2<int[], Seq<AggregateCall>> tuple2 = AggregateUtil$.MODULE$.checkAndSplitAggCalls(agg);
        if (tuple2 != null) {
            Seq aggCallsWithoutAuxGroupCalls;
            Seq seq;
            Seq aggCallsWithoutAuxGroupCalls2 = seq = (aggCallsWithoutAuxGroupCalls = (Seq)tuple2._2());
            Tuple3<int[][], DataType[][], UserDefinedFunction[]> tuple3 = AggregateUtil$.MODULE$.transformToBatchAggregateFunctions(FlinkTypeFactory$.MODULE$.toLogicalRowType(agg.getInput().getRowType()), (Seq<AggregateCall>)aggCallsWithoutAuxGroupCalls2, AggregateUtil$.MODULE$.transformToBatchAggregateFunctions$default$3());
            if (tuple3 != null) {
                DataType[][] aggBufferTypes;
                DataType[][] dataTypeArray;
                DataType[][] aggBufferTypes2 = dataTypeArray = (aggBufferTypes = (DataType[][])tuple3._2());
                return $this.isAggBufferFixedLength((LogicalType[][])Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes2).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final LogicalType[] apply(DataType[] x$5) {
                        return (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])x$5).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LogicalType apply(DataType x$1) {
                                return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(x$1);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(LogicalType.class)))));
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(tuple2);
    }

    public static boolean isAggBufferFixedLength(BatchPhysicalAggRuleBase $this, LogicalType[][] aggBufferTypes) {
        LogicalType[] aggBuffAttributesTypes = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes).flatten((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<LogicalType> apply(LogicalType[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(LogicalType.class));
        boolean isAggBufferFixedLength2 = Predef$.MODULE$.refArrayOps((Object[])aggBuffAttributesTypes).forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogicalType t) {
                return BinaryRowData.isMutable(t);
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])aggBuffAttributesTypes).isEmpty() || isAggBufferFixedLength2;
    }

    public static RelCollation createRelCollation(BatchPhysicalAggRuleBase $this, int[] groupSet) {
        ArrayList<RelFieldCollation> fields2 = new ArrayList<RelFieldCollation>();
        Predef$.MODULE$.intArrayOps(groupSet).foreach((Function1)new Serializable($this, fields2){
            public static final long serialVersionUID = 0L;
            private final ArrayList fields$1;

            public final boolean apply(int field) {
                return this.apply$mcZI$sp(field);
            }

            public boolean apply$mcZI$sp(int field) {
                return this.fields$1.add(FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(field));
            }
            {
                this.fields$1 = fields$1;
            }
        });
        return RelCollations.of(fields2);
    }

    public static Tuple2 getGlobalAggGroupSetPair(BatchPhysicalAggRuleBase $this, int[] localAggGroupSet, int[] localAggAuxGroupSet) {
        int[] globalGroupSet = (int[])Predef$.MODULE$.intArrayOps(localAggGroupSet).indices().toArray(ClassTag$.MODULE$.Int());
        int[] globalAuxGroupSet = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(localAggGroupSet.length), localAggGroupSet.length + localAggAuxGroupSet.length).toArray(ClassTag$.MODULE$.Int());
        return new Tuple2((Object)globalGroupSet, (Object)globalAuxGroupSet);
    }

    public static BatchPhysicalGroupAggregateBase createLocalAgg(BatchPhysicalAggRuleBase $this, RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType originalAggRowType, int[] grouping, int[] auxGrouping, DataType[][] aggBufferTypes, Seq aggCallToAggFunction, boolean isLocalHashAgg) {
        RelDataType inputRowType = input.getRowType();
        UserDefinedFunction[] aggFunctions = (UserDefinedFunction[])((TraversableOnce)aggCallToAggFunction.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final UserDefinedFunction apply(Tuple2<AggregateCall, UserDefinedFunction> x$6) {
                return (UserDefinedFunction)x$6._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UserDefinedFunction.class));
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)input.getCluster().getTypeFactory();
        String[] aggCallNames = (String[])JavaConversions$.MODULE$.asScalaBuffer(Util.skip(originalAggRowType.getFieldNames(), grouping.length + auxGrouping.length)).toList().toArray(ClassTag$.MODULE$.apply(String.class));
        RelDataType localAggRowType = $this.inferLocalAggType(inputRowType, typeFactory, aggCallNames, grouping, auxGrouping, aggFunctions, (LogicalType[][])Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final LogicalType[] apply(DataType[] x$7) {
                return (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])x$7).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogicalType apply(DataType x$1) {
                        return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(x$1);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(LogicalType.class)))));
        return isLocalHashAgg ? new BatchPhysicalLocalHashAggregate(cluster, traitSet, input, localAggRowType, inputRowType, grouping, auxGrouping, (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)aggCallToAggFunction) : new BatchPhysicalLocalSortAggregate(cluster, traitSet, input, localAggRowType, inputRowType, grouping, auxGrouping, (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)aggCallToAggFunction);
    }

    public static void $init$(BatchPhysicalAggRuleBase $this) {
    }
}

