/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

public class PushProjectIntoTableSourceScanRule
extends RelOptRule {
    public static final PushProjectIntoTableSourceScanRule INSTANCE = new PushProjectIntoTableSourceScanRule();

    public PushProjectIntoTableSourceScanRule() {
        super(PushProjectIntoTableSourceScanRule.operand(LogicalProject.class, PushProjectIntoTableSourceScanRule.operand(LogicalTableScan.class, PushProjectIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushProjectIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable == null || !(tableSourceTable.tableSource() instanceof SupportsProjectionPushDown)) {
            return false;
        }
        return Arrays.stream(tableSourceTable.abilitySpecs()).noneMatch(spec -> spec instanceof ProjectPushDownSpec);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RowType newProducedType;
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        int[] refFields = RexNodeExtractor.extractRefInputFields(project.getProjects());
        TableSourceTable oldTableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        ResolvedSchema oldSchema = oldTableSourceTable.catalogTable().getResolvedSchema();
        DynamicTableSource oldSource = oldTableSourceTable.tableSource();
        TableConfig config = ShortcutUtils.unwrapContext(scan).getTableConfig();
        boolean supportsNestedProjection = ((SupportsProjectionPushDown)((Object)oldTableSourceTable.tableSource())).supportsNestedProjection();
        List<String> fieldNames = scan.getRowType().getFieldNames();
        if (!supportsNestedProjection && refFields.length == fieldNames.size()) {
            return;
        }
        ArrayList<RexNode> oldProjectsWithPK = new ArrayList<RexNode>(project.getProjects());
        FlinkTypeFactory flinkTypeFactory = ShortcutUtils.unwrapTypeFactory(scan);
        if (PushProjectIntoTableSourceScanRule.isPrimaryKeyFieldsRequired(oldTableSourceTable, config)) {
            oldSchema.getPrimaryKey().ifPresent(pks -> {
                for (String name : pks.getColumns()) {
                    int index = fieldNames.indexOf(name);
                    Column col = oldSchema.getColumn(index).get();
                    oldProjectsWithPK.add(new RexInputRef(index, flinkTypeFactory.createFieldTypeFromLogicalType(col.getDataType().getLogicalType())));
                }
            });
        }
        RowType originType = DynamicSourceUtils.createProducedType(oldSchema, oldSource);
        NestedSchema nestedSchema = NestedProjectionUtil.build(oldProjectsWithPK, flinkTypeFactory.buildRelNodeRowType(originType));
        if (!supportsNestedProjection) {
            for (NestedColumn column : nestedSchema.columns().values()) {
                column.markLeaf();
            }
        }
        DataType producedDataType = TypeConversions.fromLogicalToDataType(originType);
        ArrayList<SourceAbilitySpec> sourceAbilitySpecs = new ArrayList<SourceAbilitySpec>();
        if (oldSource instanceof SupportsReadingMetadata) {
            List<String> metadataKeys = DynamicSourceUtils.createRequiredMetadataKeys(oldSchema, oldSource);
            newProducedType = PushProjectIntoTableSourceScanRule.applyPhysicalAndMetadataPushDown(nestedSchema, metadataKeys, originType, sourceAbilitySpecs);
        } else {
            int[][] projectedFields = NestedProjectionUtil.convertToIndexArray(nestedSchema);
            newProducedType = (RowType)DataTypeUtils.projectRow(producedDataType, projectedFields).getLogicalType();
            sourceAbilitySpecs.add(new ProjectPushDownSpec(projectedFields, newProducedType));
        }
        DynamicTableSource newSource = oldSource.copy();
        SourceAbilityContext context = SourceAbilityContext.from(scan);
        for (SourceAbilitySpec pushDownSpec : sourceAbilitySpecs) {
            pushDownSpec.apply(newSource, context);
        }
        RelDataType newRowType = flinkTypeFactory.buildRelNodeRowType(newProducedType);
        TableSourceTable newTableSourceTable = oldTableSourceTable.copy(newSource, newRowType, new String[]{"project=[" + String.join((CharSequence)", ", newRowType.getFieldNames()) + "]"}, sourceAbilitySpecs.toArray(new SourceAbilitySpec[0]));
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), scan.getHints(), newTableSourceTable);
        List<RexNode> newProjects = NestedProjectionUtil.rewrite(project.getProjects(), nestedSchema, call.builder().getRexBuilder());
        Project newProject = project.copy(project.getTraitSet(), (RelNode)newScan, (List)newProjects, project.getRowType());
        if (ProjectRemoveRule.isTrivial(newProject)) {
            call.transformTo(newScan);
        } else {
            call.transformTo(newProject);
        }
    }

    private static boolean isPrimaryKeyFieldsRequired(TableSourceTable table, TableConfig config) {
        return DynamicSourceUtils.isUpsertSource(table.catalogTable(), table.tableSource()) || DynamicSourceUtils.isSourceChangeEventsDuplicate(table.catalogTable(), table.tableSource(), config);
    }

    /*
     * Exception decompiling
     */
    private static RowType applyPhysicalAndMetadataPushDown(NestedSchema nestedSchema, List<String> metadataKeys, RowType originType, List<SourceAbilitySpec> sourceAbilitySpecs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ int[][] lambda$applyPhysicalAndMetadataPushDown$3(int x$0) {
        return new int[x$0][];
    }
}

