/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.rules.logical.PushLimitIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.sources.LimitableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001'\t1\u0003+^:i\u0019&l\u0017\u000e^%oi>dUmZ1dsR\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u001a\u001b\u00051\"BA\u0004\u0018\u0015\tAb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005i1\"A\u0003*fY>\u0003HOU;mK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001\u0005\u0006C\u0001!\tEI\u0001\b[\u0006$8\r[3t)\t\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0004C_>dW-\u00198\t\u000b)\u0002\u0003\u0019A\u0016\u0002\t\r\fG\u000e\u001c\t\u0003+1J!!\f\f\u0003\u001dI+Gn\u00149u%VdWmQ1mY\")q\u0006\u0001C!a\u00059qN\\'bi\u000eDGCA\u00195!\t!#'\u0003\u00024K\t!QK\\5u\u0011\u0015Qc\u00061\u0001,\u0011\u00151\u0004\u0001\"\u00038\u0003)\t\u0007\u000f\u001d7z\u0019&l\u0017\u000e\u001e\u000b\u0005q){E\u000b\r\u0002:\u0003B\u0019!(P \u000e\u0003mR!\u0001\u0010\u0004\u0002\rM\u001c\u0007.Z7b\u0013\tq4H\u0001\fMK\u001e\f7-\u001f+bE2,7k\\;sG\u0016$\u0016M\u00197f!\t\u0001\u0015\t\u0004\u0001\u0005\u0013\t+\u0014\u0011!A\u0001\u0006\u0003\u0019%aA0%mE\u0011Ai\u0012\t\u0003I\u0015K!AR\u0013\u0003\u000f9{G\u000f[5oOB\u0011A\u0005S\u0005\u0003\u0013\u0016\u00121!\u00118z\u0011\u0015YU\u00071\u0001M\u0003\u0015a\u0017.\\5u!\t!S*\u0003\u0002OK\t!Aj\u001c8h\u0011\u0015\u0001V\u00071\u0001R\u0003-\u0011X\r\\(qiR\u000b'\r\\3\u0011\u0005i\u0012\u0016BA*<\u0005]1E.\u001b8l!J,\u0007/\u0019:j]\u001e$\u0016M\u00197f\u0005\u0006\u001cX\rC\u0003Vk\u0001\u0007a+\u0001\u0006sK2\u0014U/\u001b7eKJ\u0004\"a\u0016.\u000e\u0003aS!!W\f\u0002\u000bQ|w\u000e\\:\n\u0005mC&A\u0003*fY\n+\u0018\u000e\u001c3fe\u001e)QL\u0001E\u0001=\u00061\u0003+^:i\u0019&l\u0017\u000e^%oi>dUmZ1dsR\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3\u0011\u0005}yf!B\u0001\u0003\u0011\u0003\u00017CA0b!\t!#-\u0003\u0002dK\t1\u0011I\\=SK\u001aDQ\u0001H0\u0005\u0002\u0015$\u0012A\u0018\u0005\bO~\u0013\r\u0011\"\u0001i\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\u000b\t\r)|\u0006\u0015!\u0003\u0015\u0003%Iej\u0015+B\u001d\u000e+\u0005\u0005")
public class PushLimitIntoLegacyTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushLimitIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean onlyLimit;
        Sort sort = (Sort)call.rel(0);
        boolean bl = onlyLimit = sort.getCollation().getFieldCollations().isEmpty() && sort.fetch != null;
        if (onlyLimit) {
            LegacyTableSourceTable legacyTableSourceTable = ((TableScan)call.rel(1)).getTable().unwrap(LegacyTableSourceTable.class);
            if (legacyTableSourceTable != null) {
                LegacyTableSourceTable legacyTableSourceTable2 = legacyTableSourceTable;
                TableSource tableSource = legacyTableSourceTable2.tableSource();
                if (tableSource instanceof LimitableTableSource) {
                    TableSource tableSource2 = tableSource;
                    return !((LimitableTableSource)((Object)tableSource2)).isLimitPushedDown();
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        FlinkLogicalLegacyTableSourceScan scan = (FlinkLogicalLegacyTableSourceScan)call.rel(1);
        LegacyTableSourceTable tableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue(sort.offset);
        int limit = offset + RexLiteral.intValue(sort.fetch);
        RelBuilder relBuilder = call.builder();
        LegacyTableSourceTable<?> newRelOptTable = this.applyLimit(limit, tableSourceTable, relBuilder);
        FlinkLogicalLegacyTableSourceScan newScan = scan.copy(scan.getTraitSet(), newRelOptTable);
        TableSource newTableSource = newRelOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        TableSource oldTableSource = tableSourceTable.unwrap(LegacyTableSourceTable.class).tableSource();
        if (((LimitableTableSource)((Object)newTableSource)).isLimitPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push limit into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        call.transformTo(sort.copy(sort.getTraitSet(), Collections.singletonList(newScan)));
    }

    private LegacyTableSourceTable<?> applyLimit(long limit, FlinkPreparingTableBase relOptTable, RelBuilder relBuilder) {
        LegacyTableSourceTable tableSourceTable = relOptTable.unwrap(LegacyTableSourceTable.class);
        LimitableTableSource limitedSource = (LimitableTableSource)((Object)tableSourceTable.tableSource());
        TableSource newTableSource = limitedSource.applyLimit(limit);
        FlinkStatistic statistic2 = relOptTable.getStatistic();
        long newRowCount = statistic2.getRowCount() == null ? limit : Math.min(limit, (long)Predef$.MODULE$.Double2double(statistic2.getRowCount()));
        TableStats newTableStats = new TableStats(newRowCount);
        FlinkStatistic newStatistic = FlinkStatistic$.MODULE$.builder().statistic(statistic2).tableStats(newTableStats).build();
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    public PushLimitIntoLegacyTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalSort.class, RelOptRule.operand(FlinkLogicalLegacyTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushLimitIntoLegacyTableSourceScanRule");
    }
}

