/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoSourceScanRuleBase;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import scala.Tuple2;

public class PushFilterIntoTableSourceScanRule
extends PushFilterIntoSourceScanRuleBase {
    public static final PushFilterIntoTableSourceScanRule INSTANCE = new PushFilterIntoTableSourceScanRule();

    public PushFilterIntoTableSourceScanRule() {
        super(PushFilterIntoTableSourceScanRule.operand(Filter.class, PushFilterIntoTableSourceScanRule.operand(LogicalTableScan.class, PushFilterIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        if (!super.matches(call)) {
            return false;
        }
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        return this.canPushdownFilter(tableSourceTable);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable table = scan.getTable().unwrap(TableSourceTable.class);
        this.pushFilterIntoScan(call, filter, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkPreparingTableBase relOptTable) {
        RelBuilder relBuilder = call.builder();
        Tuple2<RexNode[], RexNode[]> extractedPredicates = this.extractPredicates(filter.getInput().getRowType().getFieldNames().toArray(new String[0]), filter.getCondition(), scan, relBuilder.getRexBuilder());
        RexNode[] convertiblePredicates = (RexNode[])extractedPredicates._1;
        RexNode[] unconvertedPredicates = (RexNode[])extractedPredicates._2;
        if (convertiblePredicates.length == 0) {
            return;
        }
        Tuple2<SupportsFilterPushDown.Result, TableSourceTable> scanAfterPushdownWithResult = this.resolveFiltersAndCreateTableSourceTable(convertiblePredicates, relOptTable.unwrap(TableSourceTable.class), scan, relBuilder);
        SupportsFilterPushDown.Result result = (SupportsFilterPushDown.Result)scanAfterPushdownWithResult._1;
        TableSourceTable tableSourceTable = (TableSourceTable)scanAfterPushdownWithResult._2;
        LogicalTableScan newScan = LogicalTableScan.create(scan.getCluster(), tableSourceTable, scan.getHints());
        if (result.getRemainingFilters().isEmpty() && unconvertedPredicates.length == 0) {
            call.transformTo(newScan);
        } else {
            RexNode remainingCondition = this.createRemainingCondition(relBuilder, result.getRemainingFilters(), unconvertedPredicates);
            RexNode simplifiedRemainingCondition = FlinkRexUtil.simplify(relBuilder.getRexBuilder(), remainingCondition);
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, simplifiedRemainingCondition);
            call.transformTo(newFilter);
        }
    }
}

