/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecRank;
import org.apache.flink.table.planner.plan.utils.RankProcessStrategy;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.types.logical.RowType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecLimit
extends StreamExecRank {
    @JsonIgnore
    private final long limitEnd;

    public StreamExecLimit(long limitStart, long limitEnd, boolean generateUpdateBefore, boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(new ConstantRankRange(limitStart + 1L, limitEnd), StreamExecLimit.getRankStrategy(needRetraction), generateUpdateBefore, StreamExecLimit.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecLimit(@JsonProperty(value="rankRange") ConstantRankRange rankRange, @JsonProperty(value="rankStrategy") RankProcessStrategy rankStrategy, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(RankType.ROW_NUMBER, PartitionSpec.ALL_IN_ONE, SortSpec.ANY, rankRange, rankStrategy, false, generateUpdateBefore, id, inputProperties, outputType, description);
        this.limitEnd = rankRange.getRankEnd();
    }

    private static RankProcessStrategy getRankStrategy(boolean needRetraction) {
        if (needRetraction) {
            return RankProcessStrategy.RETRACT_STRATEGY;
        }
        return RankProcessStrategy.APPEND_FAST_STRATEGY;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        if (this.limitEnd == Long.MAX_VALUE) {
            throw new TableException("FETCH is missed, which on streaming table is not supported currently.");
        }
        return super.translateToPlanInternal(planner);
    }
}

