/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;

public class CatalogTableJsonSerializer
extends StdSerializer<ResolvedCatalogTable> {
    private static final long serialVersionUID = 1L;

    public CatalogTableJsonSerializer() {
        super(ResolvedCatalogTable.class);
    }

    public void serialize(ResolvedCatalogTable catalogTable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Map<String, String> properties;
        try {
            properties = catalogTable.toProperties();
        }
        catch (Exception e) {
            throw new TableException("Unable to serialize catalog table: " + catalogTable, e);
        }
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }
}

