/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import scala.Option;

@JsonTypeName(value="WatermarkPushDown")
public class WatermarkPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_WATERMARK_EXPR = "watermarkExpr";
    public static final String FIELD_NAME_IDLE_TIMEOUT_MILLIS = "idleTimeoutMillis";
    @JsonProperty(value="watermarkExpr")
    private final RexNode watermarkExpr;
    @JsonProperty(value="idleTimeoutMillis")
    private final long idleTimeoutMillis;

    @JsonCreator
    public WatermarkPushDownSpec(@JsonProperty(value="watermarkExpr") RexNode watermarkExpr, @JsonProperty(value="idleTimeoutMillis") long idleTimeoutMillis, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.watermarkExpr = (RexNode)Preconditions.checkNotNull((Object)watermarkExpr);
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        WatermarkStrategy watermarkStrategy;
        if (tableSource instanceof SupportsWatermarkPushDown) {
            GeneratedWatermarkGenerator generatedWatermarkGenerator = WatermarkGeneratorCodeGenerator.generateWatermarkGenerator(context.getTableConfig(), context.getSourceRowType(), this.watermarkExpr, (Option<String>)Option.apply((Object)"context"));
            Configuration configuration = context.getTableConfig().getConfiguration();
            DefaultWatermarkGeneratorSupplier supplier = new DefaultWatermarkGeneratorSupplier(configuration, generatedWatermarkGenerator);
            watermarkStrategy = WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)supplier);
            if (this.idleTimeoutMillis > 0L) {
                watermarkStrategy = watermarkStrategy.withIdleness(Duration.ofMillis(this.idleTimeoutMillis));
            }
        } else {
            throw new TableException(String.format("%s does not support SupportsWatermarkPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsWatermarkPushDown)((Object)tableSource)).applyWatermark((WatermarkStrategy<RowData>)watermarkStrategy);
    }

    public static class DefaultWatermarkGeneratorSupplier
    implements WatermarkGeneratorSupplier<RowData> {
        private static final long serialVersionUID = 1L;
        private final Configuration configuration;
        private final GeneratedWatermarkGenerator generatedWatermarkGenerator;

        public DefaultWatermarkGeneratorSupplier(Configuration configuration, GeneratedWatermarkGenerator generatedWatermarkGenerator) {
            this.configuration = configuration;
            this.generatedWatermarkGenerator = generatedWatermarkGenerator;
        }

        public WatermarkGenerator<RowData> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
            ArrayList<Object> references = new ArrayList<Object>(Arrays.asList(this.generatedWatermarkGenerator.getReferences()));
            references.add(context);
            org.apache.flink.table.runtime.generated.WatermarkGenerator innerWatermarkGenerator = (org.apache.flink.table.runtime.generated.WatermarkGenerator)((Object)new GeneratedWatermarkGenerator(this.generatedWatermarkGenerator.getClassName(), this.generatedWatermarkGenerator.getCode(), references.toArray()).newInstance(Thread.currentThread().getContextClassLoader()));
            try {
                innerWatermarkGenerator.open(this.configuration);
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to instantiate generated watermark generator.", e);
            }
            return new DefaultWatermarkGenerator(innerWatermarkGenerator);
        }

        public static class DefaultWatermarkGenerator
        implements WatermarkGenerator<RowData> {
            private static final long serialVersionUID = 1L;
            private final org.apache.flink.table.runtime.generated.WatermarkGenerator innerWatermarkGenerator;
            private Long currentWatermark = Long.MIN_VALUE;

            public DefaultWatermarkGenerator(org.apache.flink.table.runtime.generated.WatermarkGenerator watermarkGenerator) {
                this.innerWatermarkGenerator = watermarkGenerator;
            }

            public void onEvent(RowData event, long eventTimestamp, WatermarkOutput output) {
                try {
                    Long watermark = this.innerWatermarkGenerator.currentWatermark(event);
                    if (watermark != null) {
                        this.currentWatermark = watermark;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Generated WatermarkGenerator fails to generate for row: %s.", event), e);
                }
            }

            public void onPeriodicEmit(WatermarkOutput output) {
                output.emitWatermark(new Watermark(this.currentWatermark.longValue()));
            }
        }
    }
}

