/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class SumWithRetractAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef("sum");
    private UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef("count");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum, this.count};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType(), DataTypes.BIGINT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType()), ExpressionBuilder.literal(0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), this.operand(0), ExpressionBuilder.plus(this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.count, ExpressionBuilder.plus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), ExpressionBuilder.minus(this.zeroLiteral(), this.operand(0)), ExpressionBuilder.minus(this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.count, ExpressionBuilder.minus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.mergeOperand(this.sum)), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), this.mergeOperand(this.sum), ExpressionBuilder.plus(this.sum, this.mergeOperand(this.sum)))), ExpressionBuilder.plus(this.count, this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        return ExpressionBuilder.ifThenElse(ExpressionBuilder.equalTo(this.count, ExpressionBuilder.literal(0L)), ExpressionBuilder.nullOf(this.getResultType()), this.sum);
    }

    protected abstract Expression zeroLiteral();

    public static class DecimalSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        private DecimalType decimalType;

        public DecimalSumWithRetractAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType(this.decimalType);
            return DataTypes.DECIMAL(sumType.getPrecision(), sumType.getScale());
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }

    public static class DoubleSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0.0);
        }
    }

    public static class FloatSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(Float.valueOf(0.0f));
        }
    }

    public static class LongSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0L);
        }
    }

    public static class ShortSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((short)0);
        }
    }

    public static class ByteSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((byte)0);
        }
    }

    public static class IntSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }
}

