/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class Sum0AggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum0 = ApiExpressionUtils.unresolvedRef("sum");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum0};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum0, ExpressionBuilder.plus(this.sum0, this.operand(0)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.sum0, ExpressionBuilder.minus(this.sum0, this.operand(0)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.plus(this.sum0, this.mergeOperand(this.sum0))};
    }

    @Override
    public Expression getValueExpression() {
        return this.sum0;
    }

    public static class DecimalSum0AggFunction
    extends Sum0AggFunction {
        private DecimalType decimalType;

        public DecimalSum0AggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType(this.decimalType);
            return DataTypes.DECIMAL(sumType.getPrecision(), sumType.getScale());
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(new BigDecimal(0), (DataType)this.getResultType().notNull())};
        }
    }

    public static class DoubleSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class FloatSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(Float.valueOf(0.0f), (DataType)this.getResultType().notNull())};
        }
    }

    public static class LongSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0L, (DataType)this.getResultType().notNull())};
        }
    }

    public static class ShortSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal((short)0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class ByteSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal((byte)0, (DataType)this.getResultType().notNull())};
        }
    }

    public static class IntSum0AggFunction
    extends Sum0AggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0, (DataType)this.getResultType().notNull())};
        }
    }
}

