/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;

public class DefaultParserFactory
implements ParserFactory {
    @Override
    public Parser create(CatalogManager catalogManager, PlannerContext plannerContext) {
        return new ParserImpl(catalogManager, () -> plannerContext.createFlinkPlanner(catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase()), plannerContext::createCalciteParser, plannerContext.getSqlExprToRexConverterFactory());
    }

    @Override
    public Map<String, String> optionalContext() {
        DescriptorProperties properties = new DescriptorProperties();
        return properties.asMap();
    }

    @Override
    public Map<String, String> requiredContext() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(TableConfigOptions.TABLE_SQL_DIALECT.key(), SqlDialect.DEFAULT.name().toLowerCase());
        return properties.asMap();
    }

    @Override
    public List<String> supportedProperties() {
        return Collections.singletonList(TableConfigOptions.TABLE_SQL_DIALECT.key());
    }
}

