/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.schema.GenericRelDataType;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FlinkTypeFactory$ {
    public static final FlinkTypeFactory$ MODULE$;
    private final FlinkTypeFactory INSTANCE;

    static {
        new FlinkTypeFactory$();
    }

    public FlinkTypeFactory INSTANCE() {
        return this.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIndicatorType(LogicalType t) {
        LogicalType logicalType = t;
        if (logicalType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)logicalType;
            TimestampKind timestampKind = timestampType.getKind();
            TimestampKind timestampKind2 = TimestampKind.ROWTIME;
            if (timestampKind == null) {
                if (timestampKind2 == null) return true;
            } else if (((Object)((Object)timestampKind)).equals((Object)timestampKind2)) {
                return true;
            }
        }
        if (!(logicalType instanceof LocalZonedTimestampType)) return false;
        LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType;
        TimestampKind timestampKind = localZonedTimestampType.getKind();
        TimestampKind timestampKind3 = TimestampKind.PROCTIME;
        if (timestampKind != null) {
            if (!((Object)((Object)timestampKind)).equals((Object)timestampKind3)) return false;
            return true;
        }
        if (timestampKind3 == null) return true;
        return false;
    }

    public boolean isTimeIndicatorType(RelDataType relDataType) {
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType;
        return bl;
    }

    public boolean isRowtimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    public boolean isProctimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    public boolean isTimestampLtzIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).originalType().getSqlTypeName().equals((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        return bl;
    }

    @Deprecated
    public boolean isProctimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && !(timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isRowtimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && (timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isTimeIndicatorType(TypeInformation<?> typeInfo) {
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo;
        return bl;
    }

    public LogicalType toLogicalType(RelDataType relDataType) {
        SqlTypeName sqlTypeName;
        block36: {
            LogicalType logicalType;
            block6: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    block26: {
                                                        block25: {
                                                            block24: {
                                                                boolean bl;
                                                                block23: {
                                                                    boolean bl2;
                                                                    block22: {
                                                                        block21: {
                                                                            block20: {
                                                                                SqlTypeName sqlTypeName2;
                                                                                block18: {
                                                                                    block19: {
                                                                                        SqlTypeName sqlTypeName3;
                                                                                        block17: {
                                                                                            block16: {
                                                                                                block15: {
                                                                                                    block14: {
                                                                                                        block13: {
                                                                                                            block12: {
                                                                                                                block11: {
                                                                                                                    block10: {
                                                                                                                        block9: {
                                                                                                                            block8: {
                                                                                                                                block7: {
                                                                                                                                    block5: {
                                                                                                                                        bl2 = false;
                                                                                                                                        sqlTypeName3 = null;
                                                                                                                                        bl = false;
                                                                                                                                        sqlTypeName2 = null;
                                                                                                                                        sqlTypeName = relDataType.getSqlTypeName();
                                                                                                                                        if (!((Object)((Object)SqlTypeName.BOOLEAN)).equals((Object)sqlTypeName)) break block5;
                                                                                                                                        logicalType = new BooleanType();
                                                                                                                                        break block6;
                                                                                                                                    }
                                                                                                                                    if (!((Object)((Object)SqlTypeName.TINYINT)).equals((Object)sqlTypeName)) break block7;
                                                                                                                                    logicalType = new TinyIntType();
                                                                                                                                    break block6;
                                                                                                                                }
                                                                                                                                if (!((Object)((Object)SqlTypeName.SMALLINT)).equals((Object)sqlTypeName)) break block8;
                                                                                                                                logicalType = new SmallIntType();
                                                                                                                                break block6;
                                                                                                                            }
                                                                                                                            if (!((Object)((Object)SqlTypeName.INTEGER)).equals((Object)sqlTypeName)) break block9;
                                                                                                                            logicalType = new IntType();
                                                                                                                            break block6;
                                                                                                                        }
                                                                                                                        if (!((Object)((Object)SqlTypeName.BIGINT)).equals((Object)sqlTypeName)) break block10;
                                                                                                                        logicalType = new BigIntType();
                                                                                                                        break block6;
                                                                                                                    }
                                                                                                                    if (!((Object)((Object)SqlTypeName.FLOAT)).equals((Object)sqlTypeName)) break block11;
                                                                                                                    logicalType = new FloatType();
                                                                                                                    break block6;
                                                                                                                }
                                                                                                                if (!((Object)((Object)SqlTypeName.DOUBLE)).equals((Object)sqlTypeName)) break block12;
                                                                                                                logicalType = new DoubleType();
                                                                                                                break block6;
                                                                                                            }
                                                                                                            if (!((Object)((Object)SqlTypeName.CHAR)).equals((Object)sqlTypeName)) break block13;
                                                                                                            logicalType = relDataType.getPrecision() == 0 ? CharType.ofEmptyLiteral() : new CharType(relDataType.getPrecision());
                                                                                                            break block6;
                                                                                                        }
                                                                                                        if (!((Object)((Object)SqlTypeName.VARCHAR)).equals((Object)sqlTypeName)) break block14;
                                                                                                        logicalType = relDataType.getPrecision() == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(relDataType.getPrecision());
                                                                                                        break block6;
                                                                                                    }
                                                                                                    if (!((Object)((Object)SqlTypeName.BINARY)).equals((Object)sqlTypeName)) break block15;
                                                                                                    logicalType = relDataType.getPrecision() == 0 ? BinaryType.ofEmptyLiteral() : new BinaryType(relDataType.getPrecision());
                                                                                                    break block6;
                                                                                                }
                                                                                                if (!((Object)((Object)SqlTypeName.VARBINARY)).equals((Object)sqlTypeName)) break block16;
                                                                                                logicalType = relDataType.getPrecision() == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(relDataType.getPrecision());
                                                                                                break block6;
                                                                                            }
                                                                                            if (!((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName)) break block17;
                                                                                            logicalType = new DecimalType(relDataType.getPrecision(), relDataType.getScale());
                                                                                            break block6;
                                                                                        }
                                                                                        if (!((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName)) break block18;
                                                                                        bl2 = true;
                                                                                        sqlTypeName3 = sqlTypeName;
                                                                                        if (!(relDataType instanceof TimeIndicatorRelDataType)) break block18;
                                                                                        TimeIndicatorRelDataType indicator = (TimeIndicatorRelDataType)relDataType;
                                                                                        if (!indicator.isEventTime()) break block19;
                                                                                        logicalType = new TimestampType(true, TimestampKind.ROWTIME, 3);
                                                                                        break block6;
                                                                                    }
                                                                                    throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time indicator only supports"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LocalZonedTimestampType, but actual is TimestampType."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" This is a bug in planner, please file an issue."})).s((Seq)Nil$.MODULE$)).toString());
                                                                                }
                                                                                if (!((Object)((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)sqlTypeName)) break block20;
                                                                                bl = true;
                                                                                sqlTypeName2 = sqlTypeName;
                                                                                if (!(relDataType instanceof TimeIndicatorRelDataType)) break block20;
                                                                                TimeIndicatorRelDataType indicator = (TimeIndicatorRelDataType)relDataType;
                                                                                logicalType = indicator.isEventTime() ? new LocalZonedTimestampType(true, TimestampKind.ROWTIME, 3) : new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3);
                                                                                break block6;
                                                                            }
                                                                            if (!((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName)) break block21;
                                                                            logicalType = new DateType();
                                                                            break block6;
                                                                        }
                                                                        if (!((Object)((Object)SqlTypeName.TIME)).equals((Object)sqlTypeName)) break block22;
                                                                        if (relDataType.getPrecision() > 3) {
                                                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIME precision is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)relDataType.getPrecision())})));
                                                                        }
                                                                        logicalType = new TimeType();
                                                                        break block6;
                                                                    }
                                                                    if (!bl2) break block23;
                                                                    logicalType = new TimestampType(relDataType.getPrecision());
                                                                    break block6;
                                                                }
                                                                if (!bl) break block24;
                                                                logicalType = new LocalZonedTimestampType(relDataType.getPrecision());
                                                                break block6;
                                                            }
                                                            if (!SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block25;
                                                            logicalType = DataTypes.INTERVAL(DataTypes.MONTH()).getLogicalType();
                                                            break block6;
                                                        }
                                                        if (!SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)sqlTypeName)) break block26;
                                                        if (relDataType.getPrecision() > 3) {
                                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DAY_INTERVAL_TYPES precision is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)relDataType.getPrecision())})));
                                                        }
                                                        logicalType = DataTypes.INTERVAL(DataTypes.SECOND(3)).getLogicalType();
                                                        break block6;
                                                    }
                                                    if (!((Object)((Object)SqlTypeName.NULL)).equals((Object)sqlTypeName)) break block27;
                                                    logicalType = new NullType();
                                                    break block6;
                                                }
                                                if (!((Object)((Object)SqlTypeName.SYMBOL)).equals((Object)sqlTypeName)) break block28;
                                                logicalType = new TypeInformationRawType(TypeExtractor.createTypeInfo(Enum.class));
                                                break block6;
                                            }
                                            if (!((Object)((Object)SqlTypeName.ANY)).equals((Object)sqlTypeName) || !(relDataType instanceof GenericRelDataType)) break block29;
                                            GenericRelDataType genericRelDataType = (GenericRelDataType)relDataType;
                                            logicalType = genericRelDataType.genericType();
                                            break block6;
                                        }
                                        if (!((Object)((Object)SqlTypeName.ROW)).equals((Object)sqlTypeName) || !(relDataType instanceof RelRecordType)) break block30;
                                        logicalType = this.toLogicalRowType(relDataType);
                                        break block6;
                                    }
                                    if (!((Object)((Object)SqlTypeName.STRUCTURED)).equals((Object)sqlTypeName) || !(relDataType instanceof StructuredRelDataType)) break block31;
                                    logicalType = ((StructuredRelDataType)relDataType).getStructuredType();
                                    break block6;
                                }
                                if (!((Object)((Object)SqlTypeName.MULTISET)).equals((Object)sqlTypeName)) break block32;
                                logicalType = new MultisetType(this.toLogicalType(relDataType.getComponentType()));
                                break block6;
                            }
                            if (!((Object)((Object)SqlTypeName.ARRAY)).equals((Object)sqlTypeName)) break block33;
                            logicalType = new ArrayType(this.toLogicalType(relDataType.getComponentType()));
                            break block6;
                        }
                        if (!((Object)((Object)SqlTypeName.MAP)).equals((Object)sqlTypeName) || !(relDataType instanceof MapSqlType)) break block34;
                        MapSqlType mapRelDataType = (MapSqlType)relDataType;
                        logicalType = new MapType(this.toLogicalType(mapRelDataType.getKeyType()), this.toLogicalType(mapRelDataType.getValueType()));
                        break block6;
                    }
                    if (!((Object)((Object)SqlTypeName.CURSOR)).equals((Object)sqlTypeName)) break block35;
                    logicalType = new TypeInformationRawType(new NothingTypeInfo());
                    break block6;
                }
                if (!((Object)((Object)SqlTypeName.OTHER)).equals((Object)sqlTypeName) || !(relDataType instanceof RawRelDataType)) break block36;
                logicalType = ((RawRelDataType)relDataType).getRawType();
            }
            BooleanType logicalType2 = logicalType;
            return ((LogicalType)logicalType2).copy(relDataType.isNullable());
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type is not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlTypeName})));
    }

    public TableSchema toTableSchema(RelDataType relDataType) {
        String[] fieldNames = (String[])relDataType.getFieldNames().toArray((Object[])new String[0]);
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relDataType.getFieldList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(RelDataTypeField field) {
                return LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory$.MODULE$.toLogicalType(field.getType()));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(fieldNames, fieldTypes).build();
    }

    public RowType toLogicalRowType(RelDataType relType) {
        Preconditions.checkArgument((boolean)relType.isStruct());
        return RowType.of((LogicalType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(RelDataTypeField fieldType) {
                return FlinkTypeFactory$.MODULE$.toLogicalType(fieldType.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class)), (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private FlinkTypeFactory$() {
        MODULE$ = this;
        this.INSTANCE = new FlinkTypeFactory(new FlinkTypeSystem());
    }
}

