/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.SessionWithGapOnTimeWithAlias;
import org.apache.flink.table.api.SlideWithSizeAndSlideOnTimeWithAlias;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TumbleWithSizeOnTimeWithAlias;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.operations.AggregateQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;

@Internal
final class AggregateOperationFactory {
    private final boolean isStreamingMode;
    private final NoNestedAggregates noNestedAggregates = new NoNestedAggregates();
    private final ValidateDistinct validateDistinct = new ValidateDistinct();
    private final AggregationExpressionValidator aggregationsValidator = new AggregationExpressionValidator();
    private final IsKeyTypeChecker isKeyTypeChecker = new IsKeyTypeChecker();

    AggregateOperationFactory(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    QueryOperation createAggregate(List<ResolvedExpression> groupings, List<ResolvedExpression> aggregates, QueryOperation child) {
        this.validateGroupings(groupings);
        this.validateAggregates(aggregates);
        DataType[] fieldTypes = (DataType[])Stream.concat(groupings.stream().map(ResolvedExpression::getOutputDataType), aggregates.stream().flatMap(this::extractAggregateResultDataTypes)).toArray(DataType[]::new);
        String[] groupNames = (String[])groupings.stream().map(expr -> OperationExpressionsUtils.extractName(expr).orElseGet(expr::toString)).toArray(String[]::new);
        String[] fieldNames = (String[])Stream.concat(Stream.of(groupNames), aggregates.stream().flatMap(p -> this.extractAggregateNames((ResolvedExpression)p, Arrays.asList(groupNames)))).toArray(String[]::new);
        return new AggregateQueryOperation(groupings, aggregates, child, ResolvedSchema.physical(fieldNames, fieldTypes));
    }

    QueryOperation createWindowAggregate(List<ResolvedExpression> groupings, List<ResolvedExpression> aggregates, List<ResolvedExpression> windowProperties, WindowAggregateQueryOperation.ResolvedGroupWindow window, QueryOperation child) {
        this.validateGroupings(groupings);
        this.validateAggregates(aggregates);
        this.validateWindowProperties(windowProperties, window);
        DataType[] fieldTypes = (DataType[])AggregateOperationFactory.concat(groupings.stream().map(ResolvedExpression::getOutputDataType), aggregates.stream().flatMap(this::extractAggregateResultDataTypes), windowProperties.stream().map(ResolvedExpression::getOutputDataType)).toArray(DataType[]::new);
        String[] groupNames = (String[])groupings.stream().map(expr -> OperationExpressionsUtils.extractName(expr).orElseGet(expr::toString)).toArray(String[]::new);
        String[] fieldNames = (String[])AggregateOperationFactory.concat(Stream.of(groupNames), aggregates.stream().flatMap(p -> this.extractAggregateNames((ResolvedExpression)p, Arrays.asList(groupNames))), windowProperties.stream().map(expr -> OperationExpressionsUtils.extractName(expr).orElseGet(expr::toString))).toArray(String[]::new);
        return new WindowAggregateQueryOperation(groupings, aggregates, windowProperties, window, child, ResolvedSchema.physical(fieldNames, fieldTypes));
    }

    private Stream<DataType> extractAggregateResultDataTypes(ResolvedExpression expression2) {
        if (ApiExpressionUtils.isFunctionOfKind(expression2, FunctionKind.TABLE_AGGREGATE)) {
            DataType outputDataType = expression2.getOutputDataType();
            LogicalType outputType = expression2.getOutputDataType().getLogicalType();
            if (outputType instanceof LegacyTypeInformationType) {
                TypeInformation<?> legacyInfo = TypeConversions.fromDataTypeToLegacyInfo(expression2.getOutputDataType());
                return Stream.of(FieldInfoUtils.getFieldTypes(legacyInfo)).map(TypeConversions::fromLegacyInfoToDataType);
            }
            return DataTypeUtils.flattenToDataTypes(outputDataType).stream();
        }
        return Stream.of(expression2.getOutputDataType());
    }

    private Stream<String> extractAggregateNames(ResolvedExpression expression2, List<String> groupNames) {
        if (ApiExpressionUtils.isFunctionOfKind(expression2, FunctionKind.TABLE_AGGREGATE)) {
            DataType outputDataType = expression2.getOutputDataType();
            LogicalType outputType = expression2.getOutputDataType().getLogicalType();
            if (outputType instanceof LegacyTypeInformationType) {
                TypeInformation<?> legacyInfo = TypeConversions.fromDataTypeToLegacyInfo(expression2.getOutputDataType());
                return Arrays.stream(FieldInfoUtils.getFieldNames(legacyInfo, groupNames));
            }
            return DataTypeUtils.flattenToNames(outputDataType, groupNames).stream();
        }
        return Stream.of(OperationExpressionsUtils.extractName(expression2).orElseGet(expression2::toString));
    }

    WindowAggregateQueryOperation.ResolvedGroupWindow createResolvedWindow(GroupWindow window, ExpressionResolver resolver) {
        Expression alias2 = window.getAlias();
        if (!(alias2 instanceof UnresolvedReferenceExpression)) {
            throw new ValidationException("Only unresolved reference supported for alias of a group window.");
        }
        String windowName = ((UnresolvedReferenceExpression)alias2).getName();
        FieldReferenceExpression timeField = this.getValidatedTimeAttribute(window, resolver);
        if (window instanceof TumbleWithSizeOnTimeWithAlias) {
            return this.validateAndCreateTumbleWindow((TumbleWithSizeOnTimeWithAlias)window, windowName, timeField);
        }
        if (window instanceof SlideWithSizeAndSlideOnTimeWithAlias) {
            return this.validateAndCreateSlideWindow((SlideWithSizeAndSlideOnTimeWithAlias)window, windowName, timeField);
        }
        if (window instanceof SessionWithGapOnTimeWithAlias) {
            return this.validateAndCreateSessionWindow((SessionWithGapOnTimeWithAlias)window, windowName, timeField);
        }
        throw new TableException("Unknown window type: " + window);
    }

    private FieldReferenceExpression getValidatedTimeAttribute(GroupWindow window, ExpressionResolver resolver) {
        List<ResolvedExpression> timeFieldExprs = resolver.resolve(Collections.singletonList(window.getTimeField()));
        if (timeFieldExprs.size() != 1) {
            throw new ValidationException("A group window only supports a single time field column.");
        }
        Expression timeFieldExpr = timeFieldExprs.get(0);
        if (!(timeFieldExpr instanceof FieldReferenceExpression)) {
            throw new ValidationException("A group window expects a time attribute for grouping.");
        }
        FieldReferenceExpression timeField = (FieldReferenceExpression)timeFieldExpr;
        LogicalType timeFieldType = timeField.getOutputDataType().getLogicalType();
        this.validateTimeAttributeType(timeFieldType);
        return timeField;
    }

    private void validateTimeAttributeType(LogicalType timeFieldType) {
        if (this.isStreamingMode) {
            this.validateStreamTimeAttribute(timeFieldType);
        } else {
            this.validateBatchTimeAttribute(timeFieldType);
        }
    }

    private void validateBatchTimeAttribute(LogicalType timeFieldType) {
        if (!(LogicalTypeChecks.hasRoot(timeFieldType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) || LogicalTypeChecks.hasRoot(timeFieldType, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) || LogicalTypeChecks.hasRoot(timeFieldType, LogicalTypeRoot.BIGINT))) {
            throw new ValidationException("A group window expects a time attribute for grouping in a batch environment.");
        }
    }

    private void validateStreamTimeAttribute(LogicalType timeFieldType) {
        if (!LogicalTypeChecks.hasRoot(timeFieldType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && !LogicalTypeChecks.hasRoot(timeFieldType, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) || !LogicalTypeChecks.isTimeAttribute(timeFieldType)) {
            throw new ValidationException("A group window expects a time attribute for grouping in a stream environment.");
        }
    }

    private WindowAggregateQueryOperation.ResolvedGroupWindow validateAndCreateTumbleWindow(TumbleWithSizeOnTimeWithAlias window, String windowName, FieldReferenceExpression timeField) {
        ValueLiteralExpression windowSize = this.getAsValueLiteral(window.getSize(), "A tumble window expects a size value literal.");
        LogicalType timeFieldType = timeField.getOutputDataType().getLogicalType();
        LogicalType windowSizeType = windowSize.getOutputDataType().getLogicalType();
        if (!LogicalTypeChecks.hasRoot(windowSizeType, LogicalTypeRoot.BIGINT) && !LogicalTypeChecks.hasRoot(windowSizeType, LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            throw new ValidationException("Tumbling window expects a size literal of a day-time interval or BIGINT type.");
        }
        this.validateWindowIntervalType(timeFieldType, windowSizeType);
        return WindowAggregateQueryOperation.ResolvedGroupWindow.tumblingWindow(windowName, timeField, windowSize);
    }

    private WindowAggregateQueryOperation.ResolvedGroupWindow validateAndCreateSlideWindow(SlideWithSizeAndSlideOnTimeWithAlias window, String windowName, FieldReferenceExpression timeField) {
        ValueLiteralExpression windowSize = this.getAsValueLiteral(window.getSize(), "A sliding window expects a size value literal.");
        ValueLiteralExpression windowSlide = this.getAsValueLiteral(window.getSlide(), "A sliding window expects a slide value literal.");
        LogicalType timeFieldType = timeField.getOutputDataType().getLogicalType();
        LogicalType windowSizeType = windowSize.getOutputDataType().getLogicalType();
        LogicalType windowSlideType = windowSlide.getOutputDataType().getLogicalType();
        if (!LogicalTypeChecks.hasRoot(windowSizeType, LogicalTypeRoot.BIGINT) && !LogicalTypeChecks.hasRoot(windowSizeType, LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            throw new ValidationException("A sliding window expects a size literal of a day-time interval or BIGINT type.");
        }
        if (!windowSizeType.equals(windowSlideType)) {
            throw new ValidationException("A sliding window expects the same type of size and slide.");
        }
        this.validateWindowIntervalType(timeFieldType, windowSizeType);
        return WindowAggregateQueryOperation.ResolvedGroupWindow.slidingWindow(windowName, timeField, windowSize, windowSlide);
    }

    private WindowAggregateQueryOperation.ResolvedGroupWindow validateAndCreateSessionWindow(SessionWithGapOnTimeWithAlias window, String windowName, FieldReferenceExpression timeField) {
        ValueLiteralExpression windowGap = this.getAsValueLiteral(window.getGap(), "A session window expects a gap value literal.");
        LogicalType windowGapType = windowGap.getOutputDataType().getLogicalType();
        if (!LogicalTypeChecks.hasRoot(windowGapType, LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            throw new ValidationException("A session window expects a gap literal of a day-time interval type.");
        }
        return WindowAggregateQueryOperation.ResolvedGroupWindow.sessionWindow(windowName, timeField, windowGap);
    }

    private void validateWindowIntervalType(LogicalType timeFieldType, LogicalType intervalType) {
        if (LogicalTypeChecks.hasRoot(intervalType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && LogicalTypeChecks.isRowtimeAttribute(timeFieldType) && LogicalTypeChecks.hasRoot(intervalType, LogicalTypeRoot.BIGINT)) {
            throw new ValidationException("Event-time grouping windows on row intervals in a stream environment are currently not supported.");
        }
    }

    private ValueLiteralExpression getAsValueLiteral(Expression expression2, String exceptionMessage) {
        if (!(expression2 instanceof ValueLiteralExpression)) {
            throw new ValidationException(exceptionMessage);
        }
        return (ValueLiteralExpression)expression2;
    }

    private void validateWindowProperties(List<ResolvedExpression> windowProperties, WindowAggregateQueryOperation.ResolvedGroupWindow window) {
        DataType windowType;
        if (!windowProperties.isEmpty() && (window.getType() == WindowAggregateQueryOperation.ResolvedGroupWindow.WindowType.TUMBLE || window.getType() == WindowAggregateQueryOperation.ResolvedGroupWindow.WindowType.SLIDE) && LogicalTypeChecks.hasRoot((windowType = window.getSize().get().getOutputDataType()).getLogicalType(), LogicalTypeRoot.BIGINT)) {
            throw new ValidationException(String.format("Window start and Window end cannot be selected for a row-count %s window.", window.getType().toString().toLowerCase()));
        }
    }

    private static <T> Stream<T> concat(Stream<T> first, Stream<T> second, Stream<T> third) {
        Stream<T> firstConcat = Stream.concat(first, second);
        return Stream.concat(firstConcat, third);
    }

    private void validateGroupings(List<ResolvedExpression> groupings) {
        groupings.forEach(expr -> expr.getOutputDataType().getLogicalType().accept(this.isKeyTypeChecker));
    }

    private void validateAggregates(List<ResolvedExpression> aggregates) {
        aggregates.forEach(agg -> agg.accept(this.aggregationsValidator));
    }

    Tuple2<ResolvedExpression, List<String>> extractTableAggFunctionAndAliases(Expression callExpr) {
        TableAggFunctionCallResolver visitor = new TableAggFunctionCallResolver();
        return Tuple2.of((Object)callExpr.accept(visitor), visitor.getAlias());
    }

    private static class TableAggFunctionCallResolver
    extends ResolvedExpressionDefaultVisitor<ResolvedExpression> {
        private List<String> alias = new LinkedList<String>();

        private TableAggFunctionCallResolver() {
        }

        public List<String> getAlias() {
            return this.alias;
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            FunctionDefinition definition = call.getFunctionDefinition();
            if (definition == BuiltInFunctionDefinitions.AS) {
                return this.unwrapFromAlias(call);
            }
            if (ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.TABLE_AGGREGATE)) {
                return call;
            }
            return this.defaultMethod(call);
        }

        private ResolvedExpression unwrapFromAlias(CallExpression call) {
            List<ResolvedExpression> children = call.getResolvedChildren();
            List<String> aliases = children.subList(1, children.size()).stream().map(alias2 -> ExpressionUtils.extractValue(alias2, String.class).orElseThrow(() -> new ValidationException("Unexpected alias: " + alias2))).collect(Collectors.toList());
            if (!ApiExpressionUtils.isFunctionOfKind(children.get(0), FunctionKind.TABLE_AGGREGATE)) {
                throw this.fail();
            }
            this.validateAlias(aliases, (CallExpression)children.get(0));
            this.alias = aliases;
            return children.get(0);
        }

        private void validateAlias(List<String> aliases, CallExpression call) {
            int aliasesSize = aliases.size();
            LogicalType outputType = call.getOutputDataType().getLogicalType();
            int callArity = LogicalTypeChecks.getFieldCount(outputType);
            if (aliasesSize > 0 && aliasesSize != callArity) {
                throw new ValidationException(String.format("List of column aliases must have same degree as table; the returned table of function '%s' has %d columns, whereas alias list has %d columns", call.getFunctionName(), callArity, aliasesSize));
            }
        }

        @Override
        protected ResolvedExpression defaultMethod(ResolvedExpression expression2) {
            throw this.fail();
        }

        private ValidationException fail() {
            return new ValidationException("A flatAggregate only accepts an expression which defines a table aggregate function that might be followed by some alias.");
        }
    }

    private static class IsKeyTypeChecker
    extends LogicalTypeDefaultVisitor<Boolean> {
        private IsKeyTypeChecker() {
        }

        @Override
        public Boolean visit(StructuredType structuredType) {
            StructuredType.StructuredComparision comparision = structuredType.getComparision();
            return comparision == StructuredType.StructuredComparision.FULL || comparision == StructuredType.StructuredComparision.EQUALS;
        }

        @Override
        protected Boolean defaultMethod(LogicalType logicalType) {
            if (logicalType.getTypeRoot() == LogicalTypeRoot.RAW) {
                return false;
            }
            if (logicalType instanceof LegacyTypeInformationType) {
                return ((LegacyTypeInformationType)logicalType).getTypeInformation().isKeyType();
            }
            return logicalType.getChildren().stream().allMatch(c -> c.accept(this));
        }
    }

    private class NoNestedAggregates
    extends ResolvedExpressionDefaultVisitor<Void> {
        private NoNestedAggregates() {
        }

        @Override
        public Void visit(CallExpression call) {
            if (ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.AGGREGATE) || ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.TABLE_AGGREGATE)) {
                throw new ValidationException("It's not allowed to use an aggregate function as input of another aggregate function");
            }
            call.getChildren().forEach(expr -> expr.accept(this));
            return null;
        }

        @Override
        protected Void defaultMethod(ResolvedExpression expression2) {
            return null;
        }
    }

    private class ValidateDistinct
    extends ResolvedExpressionDefaultVisitor<Void> {
        private ValidateDistinct() {
        }

        @Override
        public Void visit(CallExpression call) {
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.DISTINCT) {
                throw new ValidationException("It's not allowed to use an aggregate function as input of another aggregate function");
            }
            if (!ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.AGGREGATE) && !ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.TABLE_AGGREGATE)) {
                throw new ValidationException("Distinct operator can only be applied to aggregation expressions!");
            }
            call.getChildren().forEach(child -> child.accept(AggregateOperationFactory.this.noNestedAggregates));
            return null;
        }

        @Override
        protected Void defaultMethod(ResolvedExpression expression2) {
            return null;
        }
    }

    private class AggregationExpressionValidator
    extends ResolvedExpressionDefaultVisitor<Void> {
        private AggregationExpressionValidator() {
        }

        @Override
        public Void visit(CallExpression call) {
            FunctionDefinition functionDefinition = call.getFunctionDefinition();
            if (ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.AGGREGATE) || ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.TABLE_AGGREGATE)) {
                if (functionDefinition == BuiltInFunctionDefinitions.DISTINCT) {
                    call.getChildren().forEach(expr -> expr.accept(AggregateOperationFactory.this.validateDistinct));
                } else {
                    if (this.requiresOver(functionDefinition)) {
                        throw new ValidationException(String.format("OVER clause is necessary for window functions: [%s].", call));
                    }
                    call.getChildren().forEach(child -> child.accept(AggregateOperationFactory.this.noNestedAggregates));
                }
            } else if (functionDefinition == BuiltInFunctionDefinitions.AS) {
                call.getChildren().get(0).accept(this);
            } else {
                this.failExpression(call);
            }
            return null;
        }

        private boolean requiresOver(FunctionDefinition functionDefinition) {
            return functionDefinition.getRequirements().contains((Object)FunctionRequirement.OVER_WINDOW_ONLY);
        }

        @Override
        protected Void defaultMethod(ResolvedExpression expression2) {
            this.failExpression(expression2);
            return null;
        }

        protected void failExpression(ResolvedExpression expression2) {
            throw new ValidationException(String.format("Expression '%s' is invalid because it is neither present in GROUP BY nor an aggregate function", expression2));
        }
    }
}

