/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;

public class CompactMessages {
    private CompactMessages() {
    }

    public static class EndCompaction
    implements CoordinatorOutput {
        private static final long serialVersionUID = 1L;
        private final long checkpointId;

        public EndCompaction(long checkpointId) {
            this.checkpointId = checkpointId;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }
    }

    public static class CompactionUnit
    implements CoordinatorOutput {
        private static final long serialVersionUID = 1L;
        private final int unitId;
        private final String partition;
        private final String[] pathStrings;

        public CompactionUnit(int unitId, String partition2, List<Path> unit) {
            this.unitId = unitId;
            this.partition = partition2;
            this.pathStrings = (String[])unit.stream().map(Path::toUri).map(URI::toString).toArray(String[]::new);
        }

        public boolean isTaskMessage(int taskNumber, int taskId) {
            return this.unitId % taskNumber == taskId;
        }

        public int getUnitId() {
            return this.unitId;
        }

        public String getPartition() {
            return this.partition;
        }

        public List<Path> getPaths() {
            return Arrays.stream(this.pathStrings).map(URI::create).map(Path::new).collect(Collectors.toList());
        }
    }

    public static interface CoordinatorOutput
    extends Serializable {
    }

    public static class EndCheckpoint
    implements CoordinatorInput {
        private static final long serialVersionUID = 1L;
        private final long checkpointId;
        private final int taskId;
        private final int numberOfTasks;

        public EndCheckpoint(long checkpointId, int taskId, int numberOfTasks) {
            this.checkpointId = checkpointId;
            this.taskId = taskId;
            this.numberOfTasks = numberOfTasks;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public int getNumberOfTasks() {
            return this.numberOfTasks;
        }
    }

    public static class InputFile
    implements CoordinatorInput {
        private static final long serialVersionUID = 1L;
        private final String partition;
        private final Path file;

        public InputFile(String partition2, Path file) {
            this.partition = partition2;
            this.file = file;
        }

        public String getPartition() {
            return this.partition;
        }

        public Path getFile() {
            return this.file;
        }
    }

    public static interface CoordinatorInput
    extends Serializable {
    }
}

