/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.filesystem.EmptyMetaStoreFactory;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.MetastoreCommitPolicy;
import org.apache.flink.table.filesystem.PartitionCommitPolicy;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;
import org.apache.flink.table.filesystem.stream.PartitionCommitInfo;
import org.apache.flink.table.filesystem.stream.PartitionCommitTrigger;
import org.apache.flink.table.filesystem.stream.TaskTracker;
import org.apache.flink.table.utils.PartitionPathUtils;

public class PartitionCommitter
extends AbstractStreamOperator<Void>
implements OneInputStreamOperator<PartitionCommitInfo, Void> {
    private static final long serialVersionUID = 1L;
    private final Configuration conf;
    private final Path locationPath;
    private final ObjectIdentifier tableIdentifier;
    private final List<String> partitionKeys;
    private final TableMetaStoreFactory metaStoreFactory;
    private final FileSystemFactory fsFactory;
    private transient PartitionCommitTrigger trigger;
    private transient TaskTracker taskTracker;
    private transient long currentWatermark;
    private transient List<PartitionCommitPolicy> policies;

    public PartitionCommitter(Path locationPath, ObjectIdentifier tableIdentifier, List<String> partitionKeys, TableMetaStoreFactory metaStoreFactory, FileSystemFactory fsFactory, Configuration conf) {
        this.locationPath = locationPath;
        this.tableIdentifier = tableIdentifier;
        this.partitionKeys = partitionKeys;
        this.metaStoreFactory = metaStoreFactory;
        this.fsFactory = fsFactory;
        this.conf = conf;
        PartitionCommitPolicy.validatePolicyChain(metaStoreFactory instanceof EmptyMetaStoreFactory, (String)conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_POLICY_KIND));
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.currentWatermark = Long.MIN_VALUE;
        this.trigger = PartitionCommitTrigger.create(context.isRestored(), context.getOperatorStateStore(), this.conf, this.getUserCodeClassloader(), this.partitionKeys, this.getProcessingTimeService());
        this.policies = PartitionCommitPolicy.createPolicyChain(this.getUserCodeClassloader(), (String)this.conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_POLICY_KIND), (String)this.conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_POLICY_CLASS), (String)this.conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME), () -> {
            try {
                return this.fsFactory.create(this.locationPath.toUri());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void processElement(StreamRecord<PartitionCommitInfo> element) throws Exception {
        boolean needCommit;
        PartitionCommitInfo message = (PartitionCommitInfo)element.getValue();
        for (String partition2 : message.getPartitions()) {
            this.trigger.addPartition(partition2);
        }
        if (this.taskTracker == null) {
            this.taskTracker = new TaskTracker(message.getNumberOfTasks());
        }
        if (needCommit = this.taskTracker.add(message.getCheckpointId(), message.getTaskId())) {
            this.commitPartitions(message.getCheckpointId());
        }
    }

    private void commitPartitions(long checkpointId) throws Exception {
        List<String> partitions;
        List<String> list = partitions = checkpointId == Long.MAX_VALUE ? this.trigger.endInput() : this.trigger.committablePartitions(checkpointId);
        if (partitions.isEmpty()) {
            return;
        }
        try (TableMetaStoreFactory.TableMetaStore metaStore = this.metaStoreFactory.createTableMetaStore();){
            for (String partition2 : partitions) {
                LinkedHashMap<String, String> partSpec = PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition2));
                LOG.info("Partition {} of table {} is ready to be committed", partSpec, (Object)this.tableIdentifier);
                Path path = new Path(this.locationPath, PartitionPathUtils.generatePartitionPath(partSpec));
                CommitPolicyContextImpl context = new CommitPolicyContextImpl(new ArrayList<String>(partSpec.values()), path);
                for (PartitionCommitPolicy policy : this.policies) {
                    if (policy instanceof MetastoreCommitPolicy) {
                        ((MetastoreCommitPolicy)policy).setMetastore(metaStore);
                    }
                    policy.commit(context);
                }
            }
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.trigger.snapshotState(context.getCheckpointId(), this.currentWatermark);
    }

    private class CommitPolicyContextImpl
    implements PartitionCommitPolicy.Context {
        private final List<String> partitionValues;
        private final Path partitionPath;

        private CommitPolicyContextImpl(List<String> partitionValues, Path partitionPath) {
            this.partitionValues = partitionValues;
            this.partitionPath = partitionPath;
        }

        @Override
        public String catalogName() {
            return PartitionCommitter.this.tableIdentifier.getCatalogName();
        }

        @Override
        public String databaseName() {
            return PartitionCommitter.this.tableIdentifier.getDatabaseName();
        }

        @Override
        public String tableName() {
            return PartitionCommitter.this.tableIdentifier.getObjectName();
        }

        @Override
        public List<String> partitionKeys() {
            return PartitionCommitter.this.partitionKeys;
        }

        @Override
        public List<String> partitionValues() {
            return this.partitionValues;
        }

        @Override
        public Path partitionPath() {
            return this.partitionPath;
        }
    }
}

