/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class ArrayObjectArrayConverter<E>
implements DataStructureConverter<ArrayData, E[]> {
    private static final long serialVersionUID = 1L;
    private final Class<E> elementClass;
    private final int elementSize;
    private final BinaryArrayWriter.NullSetter writerNullSetter;
    private final BinaryWriter.ValueSetter writerValueSetter;
    private final GenericToJavaArrayConverter<E> genericToJavaArrayConverter;
    private transient BinaryArrayData reuseArray;
    private transient BinaryArrayWriter reuseWriter;
    final boolean hasInternalElements;
    final ArrayData.ElementGetter elementGetter;
    final DataStructureConverter<Object, E> elementConverter;

    private ArrayObjectArrayConverter(Class<E> elementClass, int elementSize, BinaryArrayWriter.NullSetter writerNullSetter, BinaryWriter.ValueSetter writerValueSetter, GenericToJavaArrayConverter<E> genericToJavaArrayConverter, ArrayData.ElementGetter elementGetter, DataStructureConverter<Object, E> elementConverter) {
        this.elementClass = elementClass;
        this.elementSize = elementSize;
        this.writerNullSetter = writerNullSetter;
        this.writerValueSetter = writerValueSetter;
        this.genericToJavaArrayConverter = genericToJavaArrayConverter;
        this.hasInternalElements = elementConverter.isIdentityConversion();
        this.elementGetter = elementGetter;
        this.elementConverter = elementConverter;
    }

    @Override
    public void open(ClassLoader classLoader) {
        this.reuseArray = new BinaryArrayData();
        this.reuseWriter = new BinaryArrayWriter(this.reuseArray, 0, this.elementSize);
        this.elementConverter.open(classLoader);
    }

    @Override
    public ArrayData toInternal(E[] external) {
        return this.hasInternalElements ? new GenericArrayData(external) : this.toBinaryArrayData(external);
    }

    @Override
    public E[] toExternal(ArrayData internal) {
        if (this.hasInternalElements && internal instanceof GenericArrayData) {
            GenericArrayData genericArray = (GenericArrayData)internal;
            if (genericArray.isPrimitiveArray()) {
                return this.genericToJavaArrayConverter.convert((GenericArrayData)internal);
            }
            return genericArray.toObjectArray();
        }
        return this.toJavaArray(internal);
    }

    private ArrayData toBinaryArrayData(E[] external) {
        int length = external.length;
        this.allocateWriter(length);
        for (int pos = 0; pos < length; ++pos) {
            this.writeElement(pos, external[pos]);
        }
        return this.completeWriter().copy();
    }

    private E[] toJavaArray(ArrayData internal) {
        int size = internal.size();
        Object[] values = (Object[])Array.newInstance(this.elementClass, size);
        for (int pos = 0; pos < size; ++pos) {
            Object value = this.elementGetter.getElementOrNull(internal, pos);
            values[pos] = this.elementConverter.toExternalOrNull(value);
        }
        return values;
    }

    void allocateWriter(int length) {
        if (this.reuseWriter.getNumElements() != length) {
            this.reuseWriter = new BinaryArrayWriter(this.reuseArray, length, this.elementSize);
        } else {
            this.reuseWriter.reset();
        }
    }

    void writeElement(int pos, E element) {
        if (element == null) {
            this.writerNullSetter.setNull(this.reuseWriter, pos);
        } else {
            this.writerValueSetter.setValue(this.reuseWriter, pos, this.elementConverter.toInternal(element));
        }
    }

    BinaryArrayData completeWriter() {
        this.reuseWriter.complete();
        return this.reuseArray;
    }

    public static ArrayObjectArrayConverter<?> create(DataType dataType2) {
        return ArrayObjectArrayConverter.createForElement(dataType2.getChildren().get(0));
    }

    public static <E> ArrayObjectArrayConverter<E> createForElement(DataType elementDataType) {
        LogicalType elementType = elementDataType.getLogicalType();
        return new ArrayObjectArrayConverter<Object>(ClassUtils.primitiveToWrapper(elementDataType.getConversionClass()), BinaryArrayData.calculateFixLengthPartSize(elementType), BinaryArrayWriter.createNullSetter(elementType), BinaryWriter.createValueSetter(elementType), ArrayObjectArrayConverter.createGenericToJavaArrayConverter(elementType), ArrayData.createElementGetter(elementType), DataStructureConverters.getConverter(elementDataType));
    }

    private static <E> GenericToJavaArrayConverter<E> createGenericToJavaArrayConverter(LogicalType elementType) {
        switch (elementType.getTypeRoot()) {
            case BOOLEAN: {
                return internal -> ArrayUtils.toObject((boolean[])internal.toBooleanArray());
            }
            case TINYINT: {
                return internal -> ArrayUtils.toObject((byte[])internal.toByteArray());
            }
            case SMALLINT: {
                return internal -> ArrayUtils.toObject((short[])internal.toShortArray());
            }
            case INTEGER: {
                return internal -> ArrayUtils.toObject((int[])internal.toIntArray());
            }
            case BIGINT: {
                return internal -> ArrayUtils.toObject((long[])internal.toLongArray());
            }
            case FLOAT: {
                return internal -> ArrayUtils.toObject((float[])internal.toFloatArray());
            }
            case DOUBLE: {
                return internal -> ArrayUtils.toObject((double[])internal.toDoubleArray());
            }
            case DISTINCT_TYPE: {
                return ArrayObjectArrayConverter.createGenericToJavaArrayConverter(((DistinctType)elementType).getSourceType());
            }
        }
        return internal -> {
            throw new IllegalStateException();
        };
    }

    static interface GenericToJavaArrayConverter<E>
    extends Serializable {
        public E[] convert(GenericArrayData var1);
    }
}

