/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.module.ModuleManager;

public final class StreamTableEnvironmentImpl$ {
    public static final StreamTableEnvironmentImpl$ MODULE$;

    static {
        new StreamTableEnvironmentImpl$();
    }

    public StreamTableEnvironmentImpl create(StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings, TableConfig tableConfig) {
        tableConfig.addConfiguration(settings.toConfiguration());
        if (settings.isStreamingMode()) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ModuleManager moduleManager = new ModuleManager();
            CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog(settings.getBuiltInCatalogName(), new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).executionConfig(executionEnvironment.getConfig()).build();
            FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogManager, moduleManager);
            Map<String, String> executorProperties = settings.toExecutorProperties();
            Executor executor = this.lookupExecutor(executorProperties, executionEnvironment);
            Map<String, String> plannerProperties = settings.toPlannerProperties();
            Planner planner = ComponentFactoryService.find(PlannerFactory.class, plannerProperties).create(plannerProperties, executor, tableConfig, functionCatalog, catalogManager);
            return new StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode(), classLoader);
        }
        throw new TableException("StreamTableEnvironment can not run in batch mode for now, please use TableEnvironment.");
    }

    private Executor lookupExecutor(Map<String, String> executorProperties, StreamExecutionEnvironment executionEnvironment) {
        try {
            ExecutorFactory executorFactory = ComponentFactoryService.find(ExecutorFactory.class, executorProperties);
            Method createMethod = executorFactory.getClass().getMethod("create", Map.class, org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executorProperties, executionEnvironment.getWrappedStreamExecutionEnvironment());
        }
        catch (Exception exception) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", exception);
        }
    }

    private StreamTableEnvironmentImpl$() {
        MODULE$ = this;
    }
}

