/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala;

import java.lang.reflect.Constructor;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.scala.BatchTableEnvironment;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.module.ModuleManager;

public final class BatchTableEnvironment$ {
    public static final BatchTableEnvironment$ MODULE$;

    static {
        new BatchTableEnvironment$();
    }

    public BatchTableEnvironment create(ExecutionEnvironment executionEnvironment) {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        TableConfig config = new TableConfig();
        config.addConfiguration(configuration);
        return this.create(executionEnvironment, config);
    }

    public BatchTableEnvironment create(ExecutionEnvironment executionEnvironment, TableConfig tableConfig) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ModuleManager moduleManager = new ModuleManager();
            String defaultCatalog = "default_catalog";
            CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog(defaultCatalog, new GenericInMemoryCatalog(defaultCatalog, "default_database")).executionConfig(executionEnvironment.getConfig()).build();
            Class<?> clazz = Class.forName("org.apache.flink.table.api.bridge.scala.internal.BatchTableEnvironmentImpl");
            Constructor<?> con = clazz.getConstructor(ExecutionEnvironment.class, TableConfig.class, CatalogManager.class, ModuleManager.class);
            return (BatchTableEnvironment)con.newInstance(executionEnvironment, tableConfig, catalogManager, moduleManager);
        }
        catch (Throwable throwable) {
            throw new TableException("Create BatchTableEnvironment failed.", throwable);
        }
    }

    private BatchTableEnvironment$() {
        MODULE$ = this;
    }
}

