/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.result.ChangelogResult;
import org.apache.flink.table.client.gateway.local.result.CollectResultBase;
import org.apache.flink.types.Row;

public class ChangelogCollectResult
extends CollectResultBase
implements ChangelogResult {
    private final List<Row> changeRecordBuffer = new ArrayList<Row>();
    @VisibleForTesting
    protected static final int CHANGE_RECORD_BUFFER_SIZE = 5000;

    public ChangelogCollectResult(TableResult tableResult) {
        super(tableResult);
        this.retrievalThread.start();
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<List<Row>> retrieveChanges() {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.isRetrieving() && this.executionException.get() == null) {
                if (this.changeRecordBuffer.isEmpty()) {
                    return TypedResult.empty();
                }
                ArrayList<Row> change = new ArrayList<Row>(this.changeRecordBuffer);
                this.changeRecordBuffer.clear();
                this.resultLock.notify();
                return TypedResult.payload(change);
            }
            if (!this.isRetrieving() && !this.changeRecordBuffer.isEmpty()) {
                ArrayList<Row> change = new ArrayList<Row>(this.changeRecordBuffer);
                this.changeRecordBuffer.clear();
                return TypedResult.payload(change);
            }
            return this.handleMissingResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(Row row) {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.changeRecordBuffer.size() >= 5000) {
                try {
                    this.resultLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.changeRecordBuffer.add(row);
        }
    }
}

