/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.java.BatchTableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.SinkTableEntry;
import org.apache.flink.table.client.config.entries.SourceSinkTableEntry;
import org.apache.flink.table.client.config.entries.SourceTableEntry;
import org.apache.flink.table.client.config.entries.TemporalTableEntry;
import org.apache.flink.table.client.config.entries.ViewEntry;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModuleFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionService;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.TemporaryClassLoaderContext;

@Deprecated
public class LegacyTableEnvironmentInitializer {
    public static void initializeSessionState(TableEnvironment tableEnv, Environment environment, URLClassLoader classLoader) {
        LinkedHashMap<String, Module> modules = new LinkedHashMap<String, Module>();
        environment.getModules().forEach((name, entry) -> modules.put((String)name, LegacyTableEnvironmentInitializer.createModule(entry.asMap(), classLoader)));
        if (!modules.isEmpty()) {
            tableEnv.unloadModule("core");
            modules.forEach((arg_0, arg_1) -> ((TableEnvironment)tableEnv).loadModule(arg_0, arg_1));
        }
        LegacyTableEnvironmentInitializer.registerFunctions(tableEnv, environment, classLoader);
        LegacyTableEnvironmentInitializer.initializeCatalogs(tableEnv, environment, classLoader);
    }

    private static void initializeCatalogs(TableEnvironment tableEnv, Environment environment, URLClassLoader classLoader) {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            environment.getCatalogs().forEach((name, entry) -> {
                Catalog catalog = LegacyTableEnvironmentInitializer.createCatalog(tableEnv, name, entry.asMap(), classLoader);
                tableEnv.registerCatalog(name, catalog);
            });
        }
        HashMap<String, TableSource> tableSources = new HashMap<String, TableSource>();
        HashMap<String, TableSink> tableSinks = new HashMap<String, TableSink>();
        environment.getTables().forEach((name, entry) -> {
            if (entry instanceof SourceTableEntry || entry instanceof SourceSinkTableEntry) {
                tableSources.put((String)name, (TableSource)LegacyTableEnvironmentInitializer.createTableSource(tableEnv, environment.getExecution().isStreamingPlanner(), classLoader, name, entry.asMap()));
            }
            if (entry instanceof SinkTableEntry || entry instanceof SourceSinkTableEntry) {
                tableSinks.put((String)name, (TableSink)LegacyTableEnvironmentInitializer.createTableSink(tableEnv, environment.getExecution().isStreamingPlanner(), environment.getExecution().inBatchMode(), classLoader, name, entry.asMap()));
            }
        });
        tableSources.forEach((arg_0, arg_1) -> ((TableEnvironmentInternal)((TableEnvironmentInternal)tableEnv)).registerTableSourceInternal(arg_0, arg_1));
        tableSinks.forEach((arg_0, arg_1) -> ((TableEnvironmentInternal)((TableEnvironmentInternal)tableEnv)).registerTableSinkInternal(arg_0, arg_1));
        environment.getTables().forEach((name, entry) -> {
            if (entry instanceof TemporalTableEntry) {
                TemporalTableEntry temporalTableEntry = (TemporalTableEntry)entry;
                LegacyTableEnvironmentInitializer.registerTemporalTable(tableEnv, temporalTableEntry);
            }
        });
        environment.getTables().forEach((name, entry) -> {
            if (entry instanceof ViewEntry) {
                ViewEntry viewEntry = (ViewEntry)entry;
                LegacyTableEnvironmentInitializer.registerTemporaryView(tableEnv, viewEntry);
            }
        });
        Optional<String> catalog = environment.getExecution().getCurrentCatalog();
        catalog.ifPresent(arg_0 -> ((TableEnvironment)tableEnv).useCatalog(arg_0));
        Optional<String> database = environment.getExecution().getCurrentDatabase();
        database.ifPresent(arg_0 -> ((TableEnvironment)tableEnv).useDatabase(arg_0));
    }

    private static Module createModule(Map<String, String> moduleProperties, ClassLoader classLoader) {
        ModuleFactory factory = (ModuleFactory)TableFactoryService.find(ModuleFactory.class, moduleProperties, (ClassLoader)classLoader);
        return factory.createModule(moduleProperties);
    }

    private static Catalog createCatalog(TableEnvironment tableEnv, String catalogName, Map<String, String> catalogProperties, ClassLoader classLoader) {
        return FactoryUtil.createCatalog((String)catalogName, catalogProperties, (ReadableConfig)tableEnv.getConfig().getConfiguration(), (ClassLoader)classLoader);
    }

    private static TableSource<?> createTableSource(TableEnvironment tableEnv, boolean isStreamingPlanner, URLClassLoader classLoader, String name, Map<String, String> sourceProperties) {
        if (isStreamingPlanner) {
            TableSourceFactory factory = (TableSourceFactory)TableFactoryService.find(TableSourceFactory.class, sourceProperties, (ClassLoader)classLoader);
            return factory.createTableSource((TableSourceFactory.Context)new TableSourceFactoryContextImpl(ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)name), (CatalogTable)CatalogTableImpl.fromProperties(sourceProperties), (ReadableConfig)tableEnv.getConfig().getConfiguration(), true));
        }
        BatchTableSourceFactory factory = (BatchTableSourceFactory)TableFactoryService.find(BatchTableSourceFactory.class, sourceProperties, (ClassLoader)classLoader);
        return factory.createBatchTableSource(sourceProperties);
    }

    private static TableSink<?> createTableSink(TableEnvironment tableEnv, boolean isStreamingPlanner, boolean isBounded, URLClassLoader classLoader, String name, Map<String, String> sinkProperties) {
        if (isStreamingPlanner) {
            TableSinkFactory factory = (TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, sinkProperties, (ClassLoader)classLoader);
            return factory.createTableSink((TableSinkFactory.Context)new TableSinkFactoryContextImpl(ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)name), (CatalogTable)CatalogTableImpl.fromProperties(sinkProperties), (ReadableConfig)tableEnv.getConfig().getConfiguration(), isBounded, true));
        }
        BatchTableSinkFactory factory = (BatchTableSinkFactory)TableFactoryService.find(BatchTableSinkFactory.class, sinkProperties, (ClassLoader)classLoader);
        return factory.createBatchTableSink(sinkProperties);
    }

    private static void registerFunctions(TableEnvironment tableEnv, Environment environment, URLClassLoader classLoader) {
        LinkedHashMap<String, FunctionDefinition> functions = new LinkedHashMap<String, FunctionDefinition>();
        environment.getFunctions().forEach((name, entry) -> {
            UserDefinedFunction function = FunctionService.createFunction((FunctionDescriptor)entry.getDescriptor(), (ClassLoader)classLoader, (boolean)false, (ReadableConfig)tableEnv.getConfig().getConfiguration());
            functions.put((String)name, (FunctionDefinition)function);
        });
        if (tableEnv instanceof StreamTableEnvironment) {
            StreamTableEnvironment streamTableEnvironment = (StreamTableEnvironment)tableEnv;
            functions.forEach((k, v) -> {
                if (environment.getExecution().isBlinkPlanner()) {
                    if (v instanceof ScalarFunction || v instanceof TableFunction) {
                        streamTableEnvironment.createTemporarySystemFunction(k, (UserDefinedFunction)v);
                        return;
                    } else {
                        if (!(v instanceof AggregateFunction)) throw new SqlExecutionException("Unsupported function type: " + v.getClass().getName());
                        streamTableEnvironment.registerFunction(k, (AggregateFunction)v);
                    }
                    return;
                } else if (v instanceof ScalarFunction) {
                    streamTableEnvironment.registerFunction(k, (ScalarFunction)v);
                    return;
                } else if (v instanceof AggregateFunction) {
                    streamTableEnvironment.registerFunction(k, (AggregateFunction)v);
                    return;
                } else {
                    if (!(v instanceof TableFunction)) throw new SqlExecutionException("Unsupported function type: " + v.getClass().getName());
                    streamTableEnvironment.registerFunction(k, (TableFunction)v);
                }
            });
        } else {
            BatchTableEnvironment batchTableEnvironment = (BatchTableEnvironment)tableEnv;
            functions.forEach((k, v) -> {
                if (v instanceof ScalarFunction) {
                    batchTableEnvironment.registerFunction(k, (ScalarFunction)v);
                } else if (v instanceof AggregateFunction) {
                    batchTableEnvironment.registerFunction(k, (AggregateFunction)v);
                } else if (v instanceof TableFunction) {
                    batchTableEnvironment.registerFunction(k, (TableFunction)v);
                } else {
                    throw new SqlExecutionException("Unsupported function type: " + v.getClass().getName());
                }
            });
        }
    }

    private static void registerTemporaryView(TableEnvironment tableEnv, ViewEntry viewEntry) {
        try {
            tableEnv.createTemporaryView(viewEntry.getName(), tableEnv.sqlQuery(viewEntry.getQuery()));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Invalid view '" + viewEntry.getName() + "' with query:\n" + viewEntry.getQuery() + "\nCause: " + e.getMessage());
        }
    }

    private static void registerTemporalTable(TableEnvironment tableEnv, TemporalTableEntry temporalTableEntry) {
        try {
            Table table = tableEnv.from(temporalTableEntry.getHistoryTable());
            List<String> primaryKeyFields = temporalTableEntry.getPrimaryKeyFields();
            if (primaryKeyFields.size() > 1) {
                throw new ValidationException("Temporal tables over a composite primary key are not supported yet.");
            }
            TemporalTableFunction function = table.createTemporalTableFunction((Expression)Expressions.$((String)temporalTableEntry.getTimeAttribute()), (Expression)Expressions.$((String)primaryKeyFields.get(0)));
            if (tableEnv instanceof StreamTableEnvironment) {
                StreamTableEnvironment streamTableEnvironment = (StreamTableEnvironment)tableEnv;
                streamTableEnvironment.registerFunction(temporalTableEntry.getName(), (TableFunction)function);
            } else {
                BatchTableEnvironment batchTableEnvironment = (BatchTableEnvironment)tableEnv;
                batchTableEnvironment.registerFunction(temporalTableEntry.getName(), (TableFunction)function);
            }
        }
        catch (Exception e) {
            throw new SqlExecutionException("Invalid temporal table '" + temporalTableEntry.getName() + "' over table '" + temporalTableEntry.getHistoryTable() + ".\nCause: " + e.getMessage());
        }
    }
}

