/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.java.internal.BatchTableEnvironmentImpl;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.util.TemporaryClassLoaderContext;

public class ExecutionContext {
    private final Configuration flinkConfig;
    private final SessionContext.SessionState sessionState;
    private final URLClassLoader classLoader;
    private final TableEnvironment tableEnv;

    public ExecutionContext(Configuration flinkConfig, URLClassLoader classLoader, SessionContext.SessionState sessionState) {
        this.flinkConfig = flinkConfig;
        this.sessionState = sessionState;
        this.classLoader = classLoader;
        this.tableEnv = this.createTableEnvironment();
    }

    public ExecutionContext(ExecutionContext context) {
        this.flinkConfig = context.flinkConfig;
        this.sessionState = context.sessionState;
        this.classLoader = context.classLoader;
        this.tableEnv = this.createTableEnvironment();
    }

    public <R> R wrapClassLoader(Supplier<R> supplier) {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)this.classLoader);){
            R r = supplier.get();
            return r;
        }
    }

    public TableEnvironment getTableEnvironment() {
        return this.tableEnv;
    }

    private TableEnvironment createTableEnvironment() {
        EnvironmentSettings settings = EnvironmentSettings.fromConfiguration((Configuration)this.flinkConfig);
        TableConfig config = new TableConfig();
        config.addConfiguration(this.flinkConfig);
        if (!settings.isStreamingMode() && !settings.isBlinkPlanner()) {
            ExecutionEnvironment execEnv = this.createExecutionEnvironment();
            return new BatchTableEnvironmentImpl(execEnv, config, this.sessionState.catalogManager, this.sessionState.moduleManager);
        }
        StreamExecutionEnvironment streamExecEnv = this.createStreamExecutionEnvironment();
        Map executorProperties = settings.toExecutorProperties();
        Executor executor = this.lookupExecutor(executorProperties, streamExecEnv);
        return this.createStreamTableEnvironment(streamExecEnv, settings, config, executor, this.sessionState.catalogManager, this.sessionState.moduleManager, this.sessionState.functionCatalog, this.classLoader);
    }

    private TableEnvironment createStreamTableEnvironment(StreamExecutionEnvironment env, EnvironmentSettings settings, TableConfig config, Executor executor, CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog, ClassLoader userClassLoader) {
        Map plannerProperties = settings.toPlannerProperties();
        Planner planner = ((PlannerFactory)ComponentFactoryService.find(PlannerFactory.class, (Map)plannerProperties)).create(plannerProperties, executor, config, functionCatalog, catalogManager);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, config, env, planner, executor, settings.isStreamingMode(), userClassLoader);
    }

    private Executor lookupExecutor(Map<String, String> executorProperties, StreamExecutionEnvironment executionEnvironment) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)ComponentFactoryService.find(ExecutorFactory.class, executorProperties);
            Method createMethod = executorFactory.getClass().getMethod("create", Map.class, StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executorProperties, executionEnvironment);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }

    private StreamExecutionEnvironment createStreamExecutionEnvironment() {
        return new StreamExecutionEnvironment(new Configuration(this.flinkConfig), (ClassLoader)this.classLoader);
    }

    private ExecutionEnvironment createExecutionEnvironment() {
        ExecutionEnvironment execEnv = ExecutionEnvironment.getExecutionEnvironment();
        execEnv.getConfiguration().addAll(this.flinkConfig);
        return execEnv;
    }
}

