/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliInputView;
import org.apache.flink.table.client.cli.CliResultView;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.jline.keymap.KeyMap;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class CliTableResultView
extends CliResultView<ResultTableOperation> {
    private int pageCount;
    private int page;
    private LocalTime lastRetrieval;
    private int previousResultsPage;
    private final ZoneId sessionTimeZone;
    private static final int DEFAULT_REFRESH_INTERVAL = 3;
    private static final int MIN_REFRESH_INTERVAL = 1;
    private static final int LAST_PAGE = 0;

    public CliTableResultView(CliClient client, ResultDescriptor resultDescriptor) {
        super(client, resultDescriptor);
        this.refreshInterval = 3;
        this.pageCount = 1;
        this.page = 0;
        this.previousResults = Collections.emptyList();
        this.previousResultsPage = 1;
        this.results = Collections.emptyList();
        this.sessionTimeZone = CliUtils.getSessionTimeZone(client.getExecutor().getSessionConfig(client.getSessionId()));
    }

    @Override
    protected String[] getRow(String[] resultRow) {
        return resultRow;
    }

    @Override
    protected int computeColumnWidth(int idx) {
        return 30;
    }

    @Override
    protected void refresh() {
        TypedResult<Integer> result;
        try {
            result = this.client.getExecutor().snapshotResult(this.client.getSessionId(), this.resultDescriptor.getResultId(), this.getVisibleMainHeight());
        }
        catch (SqlExecutionException e) {
            this.close(e);
            return;
        }
        if (result.getType() == TypedResult.ResultType.EOS) {
            this.stopRetrieval(false);
        } else if (result.getType() == TypedResult.ResultType.PAYLOAD) {
            int newPageCount;
            this.pageCount = newPageCount = result.getPayload().intValue();
            if (this.page > newPageCount) {
                this.page = 0;
            }
            this.updatePage();
        }
        this.lastRetrieval = LocalTime.now();
        this.resetAllParts();
    }

    @Override
    protected KeyMap<ResultTableOperation> getKeys() {
        KeyMap<ResultTableOperation> keys = new KeyMap<ResultTableOperation>();
        keys.setAmbiguousTimeout(200L);
        keys.bind(ResultTableOperation.QUIT, "q", "Q", KeyMap.esc(), KeyMap.ctrl('c'));
        keys.bind(ResultTableOperation.REFRESH, "r", "R", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_f5));
        keys.bind(ResultTableOperation.UP, "w", "W", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_up));
        keys.bind(ResultTableOperation.DOWN, "s", "S", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_down));
        keys.bind(ResultTableOperation.LEFT, "a", "A", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_left));
        keys.bind(ResultTableOperation.RIGHT, "d", "D", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_right));
        keys.bind(ResultTableOperation.OPEN, "o", "O", "\r");
        keys.bind(ResultTableOperation.GOTO, "g", "G");
        keys.bind(ResultTableOperation.NEXT, "n", "N");
        keys.bind(ResultTableOperation.PREV, "p", "P");
        keys.bind(ResultTableOperation.LAST, "l", "L", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_end));
        keys.bind(ResultTableOperation.INC_REFRESH, (CharSequence)"+");
        keys.bind(ResultTableOperation.DEC_REFRESH, (CharSequence)"-");
        return keys;
    }

    @Override
    protected void evaluate(ResultTableOperation operation, String binding) {
        switch (operation) {
            case QUIT: {
                this.close();
                break;
            }
            case REFRESH: {
                this.refresh();
                break;
            }
            case UP: {
                this.selectRowUp();
                break;
            }
            case DOWN: {
                this.selectRowDown();
                break;
            }
            case OPEN: {
                this.openRow();
                break;
            }
            case GOTO: {
                this.gotoPage();
                break;
            }
            case NEXT: {
                this.gotoNextPage();
                break;
            }
            case PREV: {
                this.gotoPreviousPage();
                break;
            }
            case LAST: {
                this.gotoLastPage();
                break;
            }
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case INC_REFRESH: {
                this.increaseRefreshInterval();
                break;
            }
            case DEC_REFRESH: {
                this.decreaseRefreshInterval(1);
            }
        }
    }

    @Override
    protected String getTitle() {
        return "SQL Query Result (Table)";
    }

    @Override
    protected List<AttributedString> computeHeaderLines() {
        AttributedStringBuilder statusLine = new AttributedStringBuilder();
        statusLine.style(AttributedStyle.INVERSE);
        String left = this.isRetrieving() ? " Refresh: " + (String)((Tuple2)CliTableResultView.REFRESH_INTERVALS.get((int)this.refreshInterval)).f0 : " Table program finished.";
        StringBuilder middleBuilder = new StringBuilder();
        middleBuilder.append("Page:");
        middleBuilder.append(' ');
        if (this.page == 0) {
            middleBuilder.append("Last");
        } else {
            middleBuilder.append(this.page);
        }
        middleBuilder.append(" of ");
        middleBuilder.append(this.pageCount);
        String middle = middleBuilder.toString();
        String right = this.lastRetrieval == null ? "Updated: Unknown " : "Updated: " + this.lastRetrieval.format(CliUtils.TIME_FORMATTER) + " ";
        int totalLeftSpace = this.getWidth() - middle.length();
        int leftSpace = totalLeftSpace / 2 - left.length();
        statusLine.append(left);
        CliUtils.repeatChar(statusLine, ' ', leftSpace);
        statusLine.append(middle);
        int rightSpacing = this.getWidth() - statusLine.length() - right.length();
        CliUtils.repeatChar(statusLine, ' ', rightSpacing);
        statusLine.append(right);
        return Arrays.asList(statusLine.toAttributedString(), AttributedString.EMPTY);
    }

    @Override
    protected List<AttributedString> computeMainHeaderLines() {
        AttributedStringBuilder schemaHeader = new AttributedStringBuilder();
        this.resultDescriptor.getResultSchema().getColumnNames().forEach(s -> {
            schemaHeader.append(' ');
            schemaHeader.style(AttributedStyle.DEFAULT.underline());
            CliUtils.normalizeColumn(schemaHeader, s, 30);
            schemaHeader.style(AttributedStyle.DEFAULT);
        });
        return Collections.singletonList(schemaHeader.toAttributedString());
    }

    @Override
    protected List<AttributedString> computeFooterLines() {
        return CliUtils.formatTwoLineHelpOptions(this.getWidth(), this.getHelpOptions());
    }

    private void updatePage() {
        List<Row> rows;
        int retrievalPage = this.page == 0 ? this.pageCount : this.page;
        try {
            rows = this.client.getExecutor().retrieveResultPage(this.resultDescriptor.getResultId(), retrievalPage);
        }
        catch (SqlExecutionException e) {
            this.close(e);
            return;
        }
        List stringRows = rows.stream().map(r -> PrintUtils.rowToString((Row)r, (ResolvedSchema)this.resultDescriptor.getResultSchema(), (ZoneId)this.sessionTimeZone)).collect(Collectors.toList());
        if (this.previousResultsPage == retrievalPage) {
            this.previousResults = this.results;
        } else {
            this.previousResults = null;
            this.previousResultsPage = retrievalPage;
        }
        this.results = stringRows;
        if (this.selectedRow != -1 && this.selectedRow >= this.results.size()) {
            this.selectedRow = -1;
        }
        this.resetAllParts();
    }

    private List<Tuple2<String, String>> getHelpOptions() {
        ArrayList<Tuple2<String, String>> options = new ArrayList<Tuple2<String, String>>();
        options.add(Tuple2.of((Object)"Q", (Object)"Quit"));
        options.add(Tuple2.of((Object)"R", (Object)"Refresh"));
        options.add(Tuple2.of((Object)"+", (Object)"Inc Refresh"));
        options.add(Tuple2.of((Object)"-", (Object)"Dec Refresh"));
        options.add(Tuple2.of((Object)"G", (Object)"Goto Page"));
        options.add(Tuple2.of((Object)"L", (Object)"Last Page"));
        options.add(Tuple2.of((Object)"N", (Object)"Next Page"));
        options.add(Tuple2.of((Object)"P", (Object)"Prev Page"));
        options.add(Tuple2.of((Object)"O", (Object)"Open Row"));
        return options;
    }

    private void gotoPage() {
        CliInputView view = new CliInputView(this.client, "Enter page number: [1 to " + this.pageCount + "]", s -> {
            int newPage;
            try {
                newPage = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return newPage > 0 && newPage <= this.pageCount;
        });
        view.open();
        if (view.getResult() != null) {
            this.page = Integer.parseInt((String)view.getResult());
            this.updatePage();
        }
    }

    private void gotoNextPage() {
        int curPageIndex;
        int n = curPageIndex = this.page == 0 ? this.pageCount : this.page;
        if (curPageIndex < this.pageCount) {
            this.page = curPageIndex + 1;
        }
        this.updatePage();
    }

    private void gotoPreviousPage() {
        int curPageIndex;
        int n = curPageIndex = this.page == 0 ? this.pageCount : this.page;
        if (curPageIndex > 1) {
            this.page = curPageIndex - 1;
        }
        this.updatePage();
    }

    private void gotoLastPage() {
        this.page = 0;
        this.updatePage();
    }

    public static enum ResultTableOperation {
        QUIT,
        REFRESH,
        UP,
        DOWN,
        OPEN,
        GOTO,
        NEXT,
        PREV,
        LAST,
        LEFT,
        RIGHT,
        INC_REFRESH,
        DEC_REFRESH;

    }
}

