/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.transforms.DataTypeConversionClassTransformation;
import org.apache.flink.table.types.inference.transforms.LegacyRawTypeTransformation;
import org.apache.flink.table.types.inference.transforms.LegacyToNonLegacyTransformation;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;

@Internal
public final class TypeTransformations {
    public static final TypeTransformation TO_INTERNAL_CLASS = dataType2 -> (DataType)dataType2.bridgedTo(LogicalTypeUtils.toInternalConversionClass(dataType2.getLogicalType()));

    public static TypeTransformation timeToSqlTypes() {
        HashMap conversions = new HashMap();
        conversions.put(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, Timestamp.class);
        conversions.put(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, Time.class);
        conversions.put(LogicalTypeRoot.DATE, Date.class);
        return new DataTypeConversionClassTransformation(conversions);
    }

    public static TypeTransformation legacyRawToTypeInfoRaw() {
        return LegacyRawTypeTransformation.INSTANCE;
    }

    public static TypeTransformation legacyToNonLegacy() {
        return LegacyToNonLegacyTransformation.INSTANCE;
    }

    public static TypeTransformation toNullable() {
        return AbstractDataType::nullable;
    }

    private TypeTransformations() {
    }
}

