/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.runtime.types.CRow;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Internal
@ScalaSignature(bytes="\u0006\u0001\u0005Ec!B\u0001\u0003\u0003\u0003y!\u0001\f\"bg\u0016$vo\\%oaV$8\u000b\u001e:fC6|\u0005/\u001a:bi>\u0014x+\u001b;i'R\fG/\u001a*fi\u0016tG/[8o\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!\u0001\u001a\u0003cA\t\u001955\t!C\u0003\u0002\u0014)\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003+Y\t1!\u00199j\u0015\t9\u0002\"A\u0005tiJ,\u0017-\\5oO&\u0011\u0011D\u0005\u0002\u0017\u0003\n\u001cHO]1diN#(/Z1n\u001fB,'/\u0019;peB\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0006if\u0004Xm]\u0005\u0003?q\u0011Aa\u0011*poB)\u0011#\t\u000e\u001b5%\u0011!E\u0005\u0002\u0017)^|\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peB!\u0011\u0003\n\u0014-\u0013\t)#CA\u0006Ue&<w-\u001a:bE2,\u0007CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA!osB\u0011Q&M\u0007\u0002])\u0011q\u0006M\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!I!A\r\u0018\u0003\u001bY{\u0017\u000e\u001a(b[\u0016\u001c\b/Y2f\u0011!!\u0004A!A!\u0002\u0013)\u0014\u0001E7j]J+G/\u001a8uS>tG+[7f!\t9c'\u0003\u00028Q\t!Aj\u001c8h\u0011!I\u0004A!A!\u0002\u0013)\u0014\u0001E7bqJ+G/\u001a8uS>tG+[7f\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0019a\u0014N\\5u}Q\u0019Qh\u0010!\u0011\u0005y\u0002Q\"\u0001\u0002\t\u000bQR\u0004\u0019A\u001b\t\u000beR\u0004\u0019A\u001b\t\u000f\t\u0003!\u0019!C\u0005\u0007\u0006\t2\tT#B\u001dV\u0003v\fV%N\u000bN#\u0016)\u0014)\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\t1\fgn\u001a\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0004TiJLgn\u001a\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002#\u0002%\rcU)\u0011(V!~#\u0016*T#T)\u0006k\u0005\u000b\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003D\u0003E!\u0016*T#S'~\u001bF+\u0011+F?:\u000bU*\u0012\u0005\u0007#\u0002\u0001\u000b\u0011\u0002#\u0002%QKU*\u0012*T?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\n'\u0002\u0001\r\u00111A\u0005\nQ\u000bA\u0004\\1uKN$(+Z4jgR,'/\u001a3DY\u0016\fg.\u00169US6,'/F\u0001V!\r16,X\u0007\u0002/*\u0011q\u0006\u0017\u0006\u00033j\u000baaY8n[>t'BA\u000b\t\u0013\tavK\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004\"!\u00120\n\u0005]2\u0005\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0003b\u0003\u0001b\u0017\r^3tiJ+w-[:uKJ,Gm\u00117fC:,\u0006\u000fV5nKJ|F%Z9\u0015\u0005\t,\u0007CA\u0014d\u0013\t!\u0007F\u0001\u0003V]&$\bb\u00024`\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0004B\u00025\u0001A\u0003&Q+A\u000fmCR,7\u000f\u001e*fO&\u001cH/\u001a:fI\u000ecW-\u00198VaRKW.\u001a:!\u0011\u001dQ\u0007A1A\u0005\u0012-\fAc\u001d;bi\u0016\u001cE.Z1oS:<WI\\1cY\u0016$W#\u00017\u0011\u0005\u001dj\u0017B\u00018)\u0005\u001d\u0011un\u001c7fC:Da\u0001\u001d\u0001!\u0002\u0013a\u0017!F:uCR,7\t\\3b]&tw-\u00128bE2,G\r\t\u0005\ne\u0002\u0001\r\u00111A\u0005\u0012M\fA\u0002^5nKJ\u001cVM\u001d<jG\u0016,\u0012\u0001\u001e\t\u0003kZl\u0011\u0001F\u0005\u0003oR\u0011!cU5na2,G+[7feN+'O^5dK\"I\u0011\u0010\u0001a\u0001\u0002\u0004%\tB_\u0001\u0011i&lWM]*feZL7-Z0%KF$\"AY>\t\u000f\u0019D\u0018\u0011!a\u0001i\"1Q\u0010\u0001Q!\nQ\fQ\u0002^5nKJ\u001cVM\u001d<jG\u0016\u0004\u0003BB@\u0001\t\u0003\n\t!\u0001\u0003pa\u0016tG#\u00012\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\u0002\u00051\u0012N\\5uS\u0006d\u0017N_3US6,'oU3sm&\u001cW\rC\u0004\u0002\n\u0001!\t\"!\u0001\u0002=I,w-[:uKJ\u0004&o\\2fgNLgnZ\"mK\u0006tW\u000b\u001d+j[\u0016\u0014\bbBA\u0007\u0001\u0011%\u0011qB\u0001\u0013kB$\u0017\r^3DY\u0016\fg.\u00169US6,'\u000fF\u0003c\u0003#\t)\u0002C\u0004\u0002\u0014\u0005-\u0001\u0019A/\u0002+\r,(O]3oiB\u0013xnY3tg&tw\rV5nK\"A\u0011qCA\u0006\u0001\u0004\tI\"\u0001\ndkJ\u0014XM\u001c;DY\u0016\fg.\u00169US6,\u0007#BA\u000e\u0003CiVBAA\u000f\u0015\r\ty\u0002S\u0001\u0005kRLG.\u0003\u0003\u0002$\u0005u!\u0001C(qi&|g.\u00197\t\u000f\u0005\u001d\u0002\u0001\"\u0005\u0002\u0002\u0005\u00012\r\\3b]V\u0003H*Y:u)&lWM\u001d\u0005\b\u0003W\u0001AQIA\u0017\u0003Ayg\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rF\u0002c\u0003_A\u0001\"!\r\u0002*\u0001\u0007\u00111G\u0001\u0006i&lWM\u001d\t\u0006#\u0005Ub\u0005L\u0005\u0004\u0003o\u0011\"!D%oi\u0016\u0014h.\u00197US6,'\u000fC\u0004\u0002<\u00011\t!!\u0010\u0002\u0019\rdW-\u00198VaN#\u0018\r^3\u0015\u0007\t\fy\u0004C\u0004\u0002B\u0005e\u0002\u0019A\u001b\u0002\tQLW.\u001a\u0015\u0004\u0001\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-\u0003\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002J\tA\u0011J\u001c;fe:\fG\u000e")
public abstract class BaseTwoInputStreamOperatorWithStateRetention
extends AbstractStreamOperator<CRow>
implements TwoInputStreamOperator<CRow, CRow, CRow>,
Triggerable<Object, VoidNamespace> {
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final String CLEANUP_TIMESTAMP;
    private final String TIMERS_STATE_NAME;
    private ValueState<Long> latestRegisteredCleanUpTimer;
    private final boolean stateCleaningEnabled;
    private SimpleTimerService timerService;

    private String CLEANUP_TIMESTAMP() {
        return this.CLEANUP_TIMESTAMP;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private ValueState<Long> latestRegisteredCleanUpTimer() {
        return this.latestRegisteredCleanUpTimer;
    }

    private void latestRegisteredCleanUpTimer_$eq(ValueState<Long> x$1) {
        this.latestRegisteredCleanUpTimer = x$1;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    public SimpleTimerService timerService() {
        return this.timerService;
    }

    public void timerService_$eq(SimpleTimerService x$1) {
        this.timerService = x$1;
    }

    public void open() {
        this.initializeTimerService();
        if (this.stateCleaningEnabled()) {
            ValueStateDescriptor cleanUpStateDescriptor = new ValueStateDescriptor(this.CLEANUP_TIMESTAMP(), Types.LONG());
            this.latestRegisteredCleanUpTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(cleanUpStateDescriptor));
        }
    }

    private void initializeTimerService() {
        InternalTimerService internalTimerService = this.getInternalTimerService(this.TIMERS_STATE_NAME(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.timerService_$eq(new SimpleTimerService(internalTimerService));
    }

    public void registerProcessingCleanUpTimer() {
        if (this.stateCleaningEnabled()) {
            long currentProcessingTime = this.timerService().currentProcessingTime();
            Optional<Object> currentCleanUpTime = Optional.ofNullable(this.latestRegisteredCleanUpTimer().value());
            if (!currentCleanUpTime.isPresent() || currentProcessingTime + this.minRetentionTime > Predef$.MODULE$.Long2long((Long)currentCleanUpTime.get())) {
                this.updateCleanUpTimer(Predef$.MODULE$.long2Long(currentProcessingTime), currentCleanUpTime);
            }
        }
    }

    private void updateCleanUpTimer(Long currentProcessingTime, Optional<Long> currentCleanUpTime) {
        if (currentCleanUpTime.isPresent()) {
            this.timerService().deleteProcessingTimeTimer(Predef$.MODULE$.Long2long(currentCleanUpTime.get()));
        }
        Long newCleanUpTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentProcessingTime) + this.maxRetentionTime);
        this.timerService().registerProcessingTimeTimer(Predef$.MODULE$.Long2long(newCleanUpTime));
        this.latestRegisteredCleanUpTimer().update((Object)newCleanUpTime);
    }

    public void cleanUpLastTimer() {
        Optional<Object> currentCleanUpTime;
        if (this.stateCleaningEnabled() && (currentCleanUpTime = Optional.ofNullable(this.latestRegisteredCleanUpTimer().value())).isPresent()) {
            this.latestRegisteredCleanUpTimer().clear();
            this.timerService().deleteProcessingTimeTimer(Predef$.MODULE$.Long2long((Long)currentCleanUpTime.get()));
        }
    }

    public final void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        if (this.stateCleaningEnabled()) {
            long timerTime = timer.getTimestamp();
            Long cleanupTime = (Long)this.latestRegisteredCleanUpTimer().value();
            if (cleanupTime != null && BoxesRunTime.equalsNumObject((Number)cleanupTime, (Object)BoxesRunTime.boxToLong((long)timerTime))) {
                this.cleanUpState(Predef$.MODULE$.Long2long(cleanupTime));
                this.latestRegisteredCleanUpTimer().clear();
            }
        }
    }

    public abstract void cleanUpState(long var1);

    public BaseTwoInputStreamOperatorWithStateRetention(long minRetentionTime, long maxRetentionTime) {
        this.minRetentionTime = minRetentionTime;
        this.maxRetentionTime = maxRetentionTime;
        this.CLEANUP_TIMESTAMP = "cleanup-timestamp";
        this.TIMERS_STATE_NAME = "timers";
        this.stateCleaningEnabled = minRetentionTime > 1L;
    }
}

