/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\bCA\u001a7\u001b\u0005!$BA\u001b\u0007\u0003\u0011)H/\u001b7\n\u0005]\"$a\u0002'pO\u001eLgn\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002+w%\u0011Ah\u000b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"Aa\b\u0001B\u0001B\u0003%q(\u0001\tj]R,'/\\3eS\u0006$X\rV=qKB\u0019\u0001iR%\u000e\u0003\u0005S!AQ\"\u0002\u0011QL\b/Z5oM>T!\u0001R#\u0002\r\r|W.\\8o\u0015\t1\u0005\"A\u0002ba&L!\u0001S!\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"A\u0013'\u000e\u0003-S!A\n\u0005\n\u00055[%a\u0001*po\"Aq\n\u0001B\u0001B\u0003%\u0001+A\u0005j]B,H\u000fV=qKB\u0019\u0001iR\u0012\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b!B]8x)&lW-\u00133y!\tYB+\u0003\u0002V9\t\u0019\u0011J\u001c;\t\u0011]\u0003!\u0011!Q\u0001\na\u000b\u0001#\\5o%\u0016$XM\u001c;j_:$\u0016.\\3\u0011\u0005mI\u0016B\u0001.\u001d\u0005\u0011auN\\4\t\u0011q\u0003!\u0011!Q\u0001\na\u000b\u0001#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3\t\u000by\u0003A\u0011A0\u0002\rqJg.\u001b;?)\u001d\u0001\u0017MY2eK\u001a\u00042A\u0005\u0001\u0016\u0011\u0015IT\f1\u0001;\u0011\u0015qT\f1\u0001@\u0011\u0015yU\f1\u0001Q\u0011\u0015\u0011V\f1\u0001T\u0011\u00159V\f1\u0001Y\u0011\u0015aV\f1\u0001Y\u0011%A\u0007\u00011AA\u0002\u0013E\u0011.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I1\u000e\u0001a\u0001\u0002\u0004%\t\u0002\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA7q!\tYb.\u0003\u0002p9\t!QK\\5u\u0011\u001d\t(.!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019\u0019\b\u0001)Q\u0005G\u00059q.\u001e;qkR\u0004\u0003\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0003w\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-F\u0001x!\rA80S\u0007\u0002s*\u0011!pQ\u0001\u0006gR\fG/Z\u0005\u0003yf\u0014!BV1mk\u0016\u001cF/\u0019;f\u0011%q\b\u00011AA\u0002\u0013%q0\u0001\u000bbG\u000e,X.\u001e7bi>\u00148\u000b^1uK~#S-\u001d\u000b\u0004[\u0006\u0005\u0001bB9~\u0003\u0003\u0005\ra\u001e\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003x\u0003E\t7mY;nk2\fGo\u001c:Ti\u0006$X\r\t\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY!A\u0006s_^l\u0015\r]*uCR,WCAA\u0007!\u0019A\u0018q\u0002-\u0002\u0014%\u0019\u0011\u0011C=\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004R!!\u0006\u0002\u001e%k!!a\u0006\u000b\u0007U\nIB\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"a\u0006\u0003\t1K7\u000f\u001e\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0013\t)#A\bs_^l\u0015\r]*uCR,w\fJ3r)\ri\u0017q\u0005\u0005\nc\u0006\u0005\u0012\u0011!a\u0001\u0003\u001bA\u0001\"a\u000b\u0001A\u0003&\u0011QB\u0001\re><X*\u00199Ti\u0006$X\r\t\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t$\u0001\tt_J$X\r\u001a+j[\u0016\u001cH/Y7qgV\u0011\u00111\u0007\t\u0006\u0003+\t)\u0004W\u0005\u0005\u0003o\t9B\u0001\u0006MS:\\W\r\u001a'jgRD1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>\u0005!2o\u001c:uK\u0012$\u0016.\\3ti\u0006l\u0007o]0%KF$2!\\A \u0011%\t\u0018\u0011HA\u0001\u0002\u0004\t\u0019\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0015BA\u001a\u0003E\u0019xN\u001d;fIRKW.Z:uC6\u00048\u000f\t\u0005\f\u0003\u000f\u0002\u0001\u0019!a\u0001\n#\tI%\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003bCA'\u0001\u0001\u0007\t\u0019!C\t\u0003\u001f\nABZ;oGRLwN\\0%KF$2!\\A)\u0011!\t\u00181JA\u0001\u0002\u0004y\u0003bBA+\u0001\u0001\u0006KaL\u0001\nMVt7\r^5p]\u0002Bq!!\u0017\u0001\t\u0003\nY&\u0001\u0003pa\u0016tGcA7\u0002^!A\u0011qLA,\u0001\u0004\t\t'\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\tY'!\u001a\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\ty\u0007\u0001C!\u0003c\na\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG\u000fF\u0004n\u0003g\n9(a%\t\u000f\u0005U\u0014Q\u000ea\u0001G\u00051\u0011N\u001c9vi\u000eC\u0001\"!\u001f\u0002n\u0001\u0007\u00111P\u0001\u0004GRD\b\u0003BA?\u0003\u001f\u0003r!a \u0002\fV\u00193%\u0004\u0002\u0002\u0002*!\u00111QAC\u0003%1WO\\2uS>t7OC\u0002G\u0003\u000fS1!!#\t\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002\u000e\u0006\u0005%\u0001F&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002\u0012\u0006-%aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003+\u000bi\u00071\u0001\u0002\u0018\u0006\u0019q.\u001e;\u0011\u000b\u0005e\u0015QT\u0012\u000e\u0005\u0005m%BA\u001b\t\u0013\u0011\ty*a'\u0003\u0013\r{G\u000e\\3di>\u0014\bbBAR\u0001\u0011\u0005\u0013QU\u0001\b_:$\u0016.\\3s)\u001di\u0017qUAV\u0003gCq!!+\u0002\"\u0002\u0007\u0001,A\u0005uS6,7\u000f^1na\"A\u0011\u0011PAQ\u0001\u0004\ti\u000b\u0005\u0003\u0002~\u0005=\u0016\u0002BAY\u0003\u0017\u0013ab\u00148US6,'oQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0016\u0006\u0005\u0006\u0019AAL\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000b!#\u001b8tKJ$Hk\\*peR,G\rT5tiR\u0019Q.a/\t\u000f\u0005u\u0016Q\u0017a\u00011\u0006y!/Z2pe\u0012$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002B\u00021\t!a1\u0002AA\u0014xnY3tg\u0016cW-\\3oiN<\u0016\u000e\u001e5TC6,G+[7fgR\fW\u000e\u001d\u000b\b[\u0006\u0015\u0017\u0011ZAg\u0011!\t9-a0A\u0002\u0005M\u0011AC2veJ{w\u000fT5ti\"9\u00111ZA`\u0001\u0004I\u0015a\u00047bgR\f5mY;nk2\fGo\u001c:\t\u0011\u0005U\u0015q\u0018a\u0001\u0003/Cq!!5\u0001\t\u0003\n\u0019.A\u0003dY>\u001cX\rF\u0001n\u0001")
public abstract class RowTimeUnboundedOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp > curWatermark) {
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (true) {
                if (this.sortedTimestamps().isEmpty()) {
                    this.accumulatorState().update((Object)lastAccumulator);
                    if (!existEarlyRecord) break;
                    ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
                    break;
                }
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
        }
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
        boolean bl = true;
        while (listIterator.hasPrevious() && bl) {
            long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
            if (recordTimestamp < timestamp) continue;
            listIterator.next();
            listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
            bl = false;
        }
        if (bl) {
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

