/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001rc\u0005\u0003\u0001#%\u0012\u0004#\u0002\n\u0014+\r\u001aS\"\u0001\u0002\n\u0005Q\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012Aa\u0011*poB\u0019!&L\u0018\u000e\u0003-R!\u0001\f\u0004\u0002\u000f\r|G-Z4f]&\u0011af\u000b\u0002\t\u0007>l\u0007/\u001b7feB\u0011!\u0003M\u0005\u0003c\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u00024m5\tAG\u0003\u00026\r\u0005!Q\u000f^5m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0002!\u0011!Q\u0001\ni\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003UmJ!\u0001P\u0016\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002%\u0019&\u0011Q*\n\u0002\r\u0007J{w\u000fV=qK&sgm\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\u0006y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u0002\u001c#&\u0011!\u000b\b\u0002\u0005\u0019>tw\r\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0003)\u0011xn\u001e+j[\u0016LE\r\u001f\t\u00037YK!a\u0016\u000f\u0003\u0007%sG\u000f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003Q\u0003Ai\u0017N\u001c*fi\u0016tG/[8o)&lW\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Q\u0003Ai\u0017\r\u001f*fi\u0016tG/[8o)&lW\rC\u0003^\u0001\u0011\u0005a,\u0001\u0004=S:LGO\u0010\u000b\t?\u0002\f'm\u00193fMB\u0019!\u0003A\u000b\t\u000beb\u0006\u0019\u0001\u001e\t\u000byb\u0006\u0019A \t\u000b)c\u0006\u0019A&\t\u000b=c\u0006\u0019\u0001)\t\u000bQc\u0006\u0019A+\t\u000bec\u0006\u0019\u0001)\t\u000bmc\u0006\u0019\u0001)\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0013I\u0017AB8viB,H/F\u0001$\u0011%Y\u0007\u00011AA\u0002\u0013%A.\u0001\u0006pkR\u0004X\u000f^0%KF$\"!\u001c9\u0011\u0005mq\u0017BA8\u001d\u0005\u0011)f.\u001b;\t\u000fET\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\rM\u0004\u0001\u0015)\u0003$\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002<\u0002+1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uKV\tq\u000fE\u0002y{Bk\u0011!\u001f\u0006\u0003un\fQa\u001d;bi\u0016T!\u0001`#\u0002\r\r|W.\\8o\u0013\tq\u0018P\u0001\u0006WC2,Xm\u0015;bi\u0016D1\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004\u0005IB.Y:u)JLwmZ3sS:<Gk]*uCR,w\fJ3r)\ri\u0017Q\u0001\u0005\bc~\f\t\u00111\u0001x\u0011\u001d\tI\u0001\u0001Q!\n]\fa\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X\r\t\u0005\u000b\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u00131\u0018A\u00043bi\u0006\u001cu.\u001e8u'R\fG/\u001a\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"\u0001\neCR\f7i\\;oiN#\u0018\r^3`I\u0015\fHcA7\u0002\u0016!A\u0011/a\u0004\u0002\u0002\u0003\u0007q\u000fC\u0004\u0002\u001a\u0001\u0001\u000b\u0015B<\u0002\u001f\u0011\fG/Y\"pk:$8\u000b^1uK\u0002B1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 \u0005\u0001\u0012mY2v[Vd\u0017\r^8s'R\fG/Z\u000b\u0003\u0003C\u0001B\u0001_?\u0002$A!\u0011QEA\u0015\u001b\t\t9C\u0003\u0002'\u0011%!\u00111FA\u0014\u0005\r\u0011vn\u001e\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t$\u0001\u000bbG\u000e,X.\u001e7bi>\u00148\u000b^1uK~#S-\u001d\u000b\u0004[\u0006M\u0002\"C9\u0002.\u0005\u0005\t\u0019AA\u0011\u0011!\t9\u0004\u0001Q!\n\u0005\u0005\u0012!E1dGVlW\u000f\\1u_J\u001cF/\u0019;fA!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0003%!\u0017\r^1Ti\u0006$X-\u0006\u0002\u0002@A1\u00010!\u0011Q\u0003\u000bJ1!a\u0011z\u0005!i\u0015\r]*uCR,\u0007CBA$\u0003\u001b\n\u0019#\u0004\u0002\u0002J)\u0019Q'a\u0013\u000b\u0003\u0011KA!a\u0014\u0002J\t!A*[:u\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0004%I!!\u0016\u0002\u001b\u0011\fG/Y*uCR,w\fJ3r)\ri\u0017q\u000b\u0005\nc\u0006E\u0013\u0011!a\u0001\u0003\u007fA\u0001\"a\u0017\u0001A\u0003&\u0011qH\u0001\u000bI\u0006$\u0018m\u0015;bi\u0016\u0004\u0003bCA0\u0001\u0001\u0007\t\u0019!C\u0005\u0003C\n\u0001BZ;oGRLwN\\\u000b\u0002_!Y\u0011Q\r\u0001A\u0002\u0003\u0007I\u0011BA4\u000311WO\\2uS>tw\fJ3r)\ri\u0017\u0011\u000e\u0005\tc\u0006\r\u0014\u0011!a\u0001_!9\u0011Q\u000e\u0001!B\u0013y\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\t\t\b\u0001C!\u0003g\nAa\u001c9f]R\u0019Q.!\u001e\t\u0011\u0005]\u0014q\u000ea\u0001\u0003s\naaY8oM&<\u0007\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}\u0004\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003\u0007\u000biHA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003\u000f\u0003A\u0011IAE\u00039\u0001(o\\2fgN,E.Z7f]R$r!\\AF\u0003\u001f\u000bY\u000bC\u0004\u0002\u000e\u0006\u0015\u0005\u0019A\u0012\u0002\r%t\u0007/\u001e;D\u0011!\t\t*!\"A\u0002\u0005M\u0015aA2uqB!\u0011QSAT!\u001d\t9*a)\u0016G\rj!!!'\u000b\t\u0005m\u0015QT\u0001\nMVt7\r^5p]NT1ARAP\u0015\r\t\t\u000bC\u0001\ngR\u0014X-Y7j]\u001eLA!!*\u0002\u001a\n!2*Z=fIB\u0013xnY3tg\u001a+hn\u0019;j_:LA!!+\u0002$\n91i\u001c8uKb$\b\u0002CAW\u0003\u000b\u0003\r!a,\u0002\u0007=,H\u000fE\u0003\u00022\u0006U6%\u0004\u0002\u00024*\u0011Q\u0007C\u0005\u0005\u0003o\u000b\u0019LA\u0005D_2dWm\u0019;pe\"9\u00111\u0018\u0001\u0005B\u0005u\u0016aB8o)&lWM\u001d\u000b\b[\u0006}\u00161YAf\u0011\u001d\t\t-!/A\u0002A\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005E\u0015\u0011\u0018a\u0001\u0003\u000b\u0004B!!&\u0002H&!\u0011\u0011ZAR\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"!,\u0002:\u0002\u0007\u0011q\u0016\u0005\b\u0003\u001f\u0004A\u0011IAi\u0003\u0015\u0019Gn\\:f)\u0005i\u0007")
public class RowTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

