/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkRelBuilderFactory;
import org.apache.flink.table.calcite.FlinkRelOptClusterFactory;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.calcite.FlinkTypeSystem;
import org.apache.flink.table.catalog.BasicOperatorTable;
import org.apache.flink.table.catalog.CatalogReader;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionCatalogOperatorTable;
import org.apache.flink.table.codegen.ExpressionReducer;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.parse.CalciteParser;
import org.apache.flink.table.plan.cost.DataSetCostFactory;
import org.apache.flink.table.util.JavaScalaConversionUtil;

@Internal
public class PlanningConfigurationBuilder {
    private final RelOptCostFactory costFactory = new DataSetCostFactory();
    private final RelDataTypeSystem typeSystem = new FlinkTypeSystem();
    private final FlinkTypeFactory typeFactory = new FlinkTypeFactory(this.typeSystem);
    private final RelOptPlanner planner;
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final Context context;
    private final TableConfig tableConfig;
    private final FunctionCatalog functionCatalog;
    private CalciteSchema rootSchema;

    public PlanningConfigurationBuilder(TableConfig tableConfig, FunctionCatalog functionCatalog, CalciteSchema rootSchema, ExpressionBridge<PlannerExpression> expressionBridge) {
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.context = Contexts.of(expressionBridge, tableConfig);
        this.planner = new VolcanoPlanner(this.costFactory, this.context);
        this.planner.setExecutor(new ExpressionReducer(tableConfig));
        this.planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        this.expressionBridge = expressionBridge;
        this.rootSchema = rootSchema;
    }

    public FlinkRelBuilder createRelBuilder(String currentCatalog, String currentDatabase) {
        RelOptCluster cluster = FlinkRelOptClusterFactory.create(this.planner, new RexBuilder(this.typeFactory));
        CatalogReader relOptSchema = this.createCatalogReader(false, currentCatalog, currentDatabase);
        Context chain = Contexts.of(this.context, this.createFlinkPlanner(currentCatalog, currentDatabase), RelBuilder.Config.DEFAULT.withBloat(-1));
        return new FlinkRelBuilder(chain, cluster, relOptSchema, this.expressionBridge);
    }

    public FlinkPlannerImpl createFlinkPlanner(String currentCatalog, String currentDatabase) {
        return new FlinkPlannerImpl(this.createFrameworkConfig(), isLenient -> this.createCatalogReader((boolean)isLenient, currentCatalog, currentDatabase), this.planner, this.typeFactory);
    }

    public CalciteParser createCalciteParser() {
        return new CalciteParser(this.getSqlParserConfig());
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public Context getContext() {
        return this.context;
    }

    public SqlParser.Config getSqlParserConfig() {
        return JavaScalaConversionUtil.toJava(this.calciteConfig(this.tableConfig).sqlParserConfig()).orElseGet(() -> SqlParser.configBuilder().setParserFactory(FlinkSqlParserImpl.FACTORY).setConformance(this.getSqlConformance()).setLex(Lex.JAVA).build());
    }

    private FlinkSqlConformance getSqlConformance() {
        SqlDialect sqlDialect = this.tableConfig.getSqlDialect();
        switch (sqlDialect) {
            case HIVE: {
                return FlinkSqlConformance.HIVE;
            }
            case DEFAULT: {
                return FlinkSqlConformance.DEFAULT;
            }
        }
        throw new TableException("Unsupported SQL dialect: " + (Object)((Object)sqlDialect));
    }

    private CatalogReader createCatalogReader(boolean lenientCaseSensitivity, String currentCatalog, String currentDatabase) {
        SqlParser.Config sqlParserConfig = this.getSqlParserConfig();
        boolean caseSensitive = lenientCaseSensitivity ? false : sqlParserConfig.caseSensitive();
        SqlParser.Config parserConfig = SqlParser.configBuilder(sqlParserConfig).setCaseSensitive(caseSensitive).build();
        return new CatalogReader(this.rootSchema, Arrays.asList(Arrays.asList(currentCatalog, currentDatabase), Collections.singletonList(currentCatalog)), (RelDataTypeFactory)this.typeFactory, CalciteConfig.connectionConfig(parserConfig));
    }

    private FrameworkConfig createFrameworkConfig() {
        return Frameworks.newConfigBuilder().parserConfig(this.getSqlParserConfig()).costFactory(this.costFactory).typeSystem(this.typeSystem).operatorTable(this.getSqlOperatorTable(this.calciteConfig(this.tableConfig), this.functionCatalog)).sqlToRelConverterConfig(this.getSqlToRelConverterConfig(this.calciteConfig(this.tableConfig), this.expressionBridge)).executor(new ExpressionReducer(this.tableConfig)).build();
    }

    private CalciteConfig calciteConfig(TableConfig tableConfig) {
        return tableConfig.getPlannerConfig().unwrap(CalciteConfig.class).orElseGet(CalciteConfig::DEFAULT);
    }

    private SqlToRelConverter.Config getSqlToRelConverterConfig(CalciteConfig calciteConfig, ExpressionBridge<PlannerExpression> expressionBridge) {
        return JavaScalaConversionUtil.toJava(calciteConfig.sqlToRelConverterConfig()).orElseGet(() -> SqlToRelConverter.config().withTrimUnusedFields(false).withInSubQueryThreshold(Integer.MAX_VALUE).withRelBuilderFactory(new FlinkRelBuilderFactory(expressionBridge)));
    }

    private SqlOperatorTable getSqlOperatorTable(CalciteConfig calciteConfig, FunctionCatalog functionCatalog) {
        SqlOperatorTable baseOperatorTable = SqlOperatorTables.chain(new BasicOperatorTable(), new FunctionCatalogOperatorTable(functionCatalog, this.typeFactory));
        return JavaScalaConversionUtil.toJava(calciteConfig.sqlOperatorTable()).map(operatorTable -> {
            if (calciteConfig.replacesSqlOperatorTable()) {
                return operatorTable;
            }
            return SqlOperatorTables.chain(baseOperatorTable, operatorTable);
        }).orElse(baseOperatorTable);
    }
}

