/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.CatalogReader;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.AggFunctionCall;
import org.apache.flink.table.expressions.Aggregation;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.RexPlannerExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.WindowReference;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.operations.AggregateQueryOperation;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.DataSetQueryOperation;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.FilterQueryOperation;
import org.apache.flink.table.operations.JavaDataStreamQueryOperation;
import org.apache.flink.table.operations.JavaExternalQueryOperation;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.ScalaDataStreamQueryOperation;
import org.apache.flink.table.operations.ScalaExternalQueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.SortQueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.ValuesQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.operations.utils.QueryOperationDefaultVisitor;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.plan.nodes.FlinkConventions;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalDataSetScan;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalDataStreamScan;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.schema.FlinkTableFunctionImpl;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.types.utils.TypeConversions;
import scala.Option;
import scala.Some;

@Internal
public class QueryOperationConverter
extends QueryOperationDefaultVisitor<RelNode> {
    private final FlinkRelBuilder relBuilder;
    private final SingleRelVisitor singleRelVisitor = new SingleRelVisitor();
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final AggregateVisitor aggregateVisitor = new AggregateVisitor();
    private final TableAggregateVisitor tableAggregateVisitor = new TableAggregateVisitor();
    private final JoinExpressionVisitor joinExpressionVisitor = new JoinExpressionVisitor();

    public QueryOperationConverter(FlinkRelBuilder relBuilder, ExpressionBridge<PlannerExpression> expressionBridge) {
        this.relBuilder = relBuilder;
        this.expressionBridge = expressionBridge;
    }

    @Override
    public RelNode defaultMethod(QueryOperation other) {
        other.getChildren().forEach(child -> this.relBuilder.push(child.accept(this)));
        return other.accept(this.singleRelVisitor);
    }

    private class TableAggregateVisitor
    extends AggregateVisitor {
        private TableAggregateVisitor() {
        }

        @Override
        public RelBuilder.AggCall visit(CallExpression unresolvedCall) {
            if (ApiExpressionUtils.isFunctionOfKind(unresolvedCall, FunctionKind.TABLE_AGGREGATE)) {
                AggFunctionCall aggFunctionCall = (AggFunctionCall)QueryOperationConverter.this.expressionBridge.bridge(unresolvedCall);
                return aggFunctionCall.toAggCall(aggFunctionCall.toString(), false, QueryOperationConverter.this.relBuilder);
            }
            throw new TableException("Expected table aggregate. Got: " + unresolvedCall);
        }
    }

    private class AggregateVisitor
    extends ExpressionDefaultVisitor<RelBuilder.AggCall> {
        private AggregateVisitor() {
        }

        @Override
        public RelBuilder.AggCall visit(CallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                String aggregateName = ExpressionUtils.extractValue(unresolvedCall.getChildren().get(1), String.class).orElseThrow(() -> new TableException("Unexpected name."));
                Expression aggregate = unresolvedCall.getChildren().get(0);
                if (ApiExpressionUtils.isFunctionOfKind(aggregate, FunctionKind.AGGREGATE)) {
                    return ((Aggregation)QueryOperationConverter.this.expressionBridge.bridge(aggregate)).toAggCall(aggregateName, false, QueryOperationConverter.this.relBuilder);
                }
            }
            throw new TableException("Expected named aggregate. Got: " + unresolvedCall);
        }

        @Override
        protected RelBuilder.AggCall defaultMethod(Expression expression2) {
            throw new TableException("Unexpected expression: " + expression2);
        }
    }

    private class JoinExpressionVisitor
    extends ExpressionDefaultVisitor<RexNode> {
        private static final int numberOfJoinInputs = 2;

        private JoinExpressionVisitor() {
        }

        @Override
        public RexNode visit(CallExpression unresolvedCall) {
            Expression[] newChildren = (Expression[])unresolvedCall.getChildren().stream().map(expr -> {
                RexNode convertedNode = expr.accept(this);
                return new RexPlannerExpression(convertedNode);
            }).toArray(Expression[]::new);
            UnresolvedCallExpression newCall = ApiExpressionUtils.unresolvedCall(unresolvedCall.getFunctionDefinition(), newChildren);
            return ((PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(newCall)).toRexNode(QueryOperationConverter.this.relBuilder);
        }

        @Override
        public RexNode visit(FieldReferenceExpression fieldReference2) {
            return QueryOperationConverter.this.relBuilder.field(2, fieldReference2.getInputIndex(), fieldReference2.getFieldIndex());
        }

        @Override
        protected RexNode defaultMethod(Expression expression2) {
            return ((PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(expression2)).toRexNode(QueryOperationConverter.this.relBuilder);
        }
    }

    private class SingleRelVisitor
    implements QueryOperationVisitor<RelNode> {
        private SingleRelVisitor() {
        }

        @Override
        public RelNode visit(ProjectQueryOperation projection) {
            List<RexNode> rexNodes = this.convertToRexNodes(projection.getProjectList());
            return QueryOperationConverter.this.relBuilder.project(rexNodes, projection.getResolvedSchema().getColumnNames(), true).build();
        }

        @Override
        public RelNode visit(AggregateQueryOperation aggregate) {
            List<RelBuilder.AggCall> aggregations = aggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(aggregate.getGroupingExpressions());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            return QueryOperationConverter.this.relBuilder.aggregate(groupKey, (Iterable<RelBuilder.AggCall>)aggregations).build();
        }

        @Override
        public RelNode visit(WindowAggregateQueryOperation windowAggregate) {
            List<RelBuilder.AggCall> aggregations = windowAggregate.getAggregateExpressions().stream().map(this::getAggCall).collect(Collectors.toList());
            List<RexNode> groupings = this.convertToRexNodes(windowAggregate.getGroupingExpressions());
            List<PlannerExpression> windowProperties = windowAggregate.getWindowPropertiesExpressions().stream().map(QueryOperationConverter.this.expressionBridge::bridge).collect(Collectors.toList());
            RelBuilder.GroupKey groupKey = QueryOperationConverter.this.relBuilder.groupKey(groupings);
            LogicalWindow logicalWindow = this.toLogicalWindow(windowAggregate.getGroupWindow());
            return QueryOperationConverter.this.relBuilder.windowAggregate(logicalWindow, groupKey, windowProperties, aggregations).build();
        }

        private RelBuilder.AggCall getAggCall(Expression aggregateExpression) {
            if (ApiExpressionUtils.isFunctionOfKind(aggregateExpression, FunctionKind.TABLE_AGGREGATE)) {
                return aggregateExpression.accept(QueryOperationConverter.this.tableAggregateVisitor);
            }
            return aggregateExpression.accept(QueryOperationConverter.this.aggregateVisitor);
        }

        @Override
        public RelNode visit(JoinQueryOperation join) {
            Set<CorrelationId> corSet = join.isCorrelated() ? Collections.singleton(QueryOperationConverter.this.relBuilder.peek().getCluster().createCorrel()) : Collections.emptySet();
            return QueryOperationConverter.this.relBuilder.join(this.convertJoinType(join.getJoinType()), join.getCondition().accept(QueryOperationConverter.this.joinExpressionVisitor), corSet).build();
        }

        @Override
        public RelNode visit(SetQueryOperation setOperation) {
            switch (setOperation.getType()) {
                case INTERSECT: {
                    QueryOperationConverter.this.relBuilder.intersect(setOperation.isAll());
                    break;
                }
                case MINUS: {
                    QueryOperationConverter.this.relBuilder.minus(setOperation.isAll());
                    break;
                }
                case UNION: {
                    QueryOperationConverter.this.relBuilder.union(setOperation.isAll());
                }
            }
            return QueryOperationConverter.this.relBuilder.build();
        }

        @Override
        public RelNode visit(FilterQueryOperation filter) {
            RexNode rexNode = this.convertToRexNode(filter.getCondition());
            return QueryOperationConverter.this.relBuilder.filter(rexNode).build();
        }

        @Override
        public RelNode visit(DistinctQueryOperation distinct) {
            return QueryOperationConverter.this.relBuilder.distinct().build();
        }

        @Override
        public RelNode visit(SortQueryOperation sort) {
            List<RexNode> rexNodes = this.convertToRexNodes(sort.getOrder());
            return QueryOperationConverter.this.relBuilder.sortLimit(sort.getOffset(), sort.getFetch(), rexNodes).build();
        }

        @Override
        public RelNode visit(CalculatedQueryOperation calculatedTable) {
            FlinkTypeFactory typeFactory = QueryOperationConverter.this.relBuilder.getTypeFactory();
            if (calculatedTable.getFunctionDefinition() instanceof TableFunctionDefinition) {
                TableFunctionDefinition functionDefinition = (TableFunctionDefinition)calculatedTable.getFunctionDefinition();
                String[] fieldNames = calculatedTable.getResolvedSchema().getColumnNames().toArray(new String[0]);
                int[] fieldIndices = IntStream.range(0, fieldNames.length).toArray();
                TableFunction<?> tableFunction = functionDefinition.getTableFunction();
                TypeInformation<?> rowType = functionDefinition.getResultType();
                FlinkTableFunctionImpl function = new FlinkTableFunctionImpl(rowType, fieldIndices, fieldNames);
                TableSqlFunction sqlFunction = new TableSqlFunction(tableFunction.functionIdentifier(), tableFunction.toString(), tableFunction, rowType, typeFactory, function);
                List<RexNode> parameters = this.convertToRexNodes(calculatedTable.getArguments());
                return LogicalTableFunctionScan.create(QueryOperationConverter.this.relBuilder.peek().getCluster(), Collections.emptyList(), QueryOperationConverter.this.relBuilder.call((SqlOperator)sqlFunction, parameters), function.getElementType(null), function.getRowType(typeFactory, null), null);
            }
            throw new ValidationException("The new type inference for functions is only supported in the Blink planner.");
        }

        @Override
        public RelNode visit(CatalogQueryOperation catalogTable) {
            ObjectIdentifier objectIdentifier = catalogTable.getTableIdentifier();
            return QueryOperationConverter.this.relBuilder.scan(objectIdentifier.getCatalogName(), objectIdentifier.getDatabaseName(), objectIdentifier.getObjectName()).build();
        }

        @Override
        public RelNode visit(ValuesQueryOperation values) {
            RelDataType rowType = QueryOperationConverter.this.relBuilder.getTypeFactory().buildLogicalRowType(TableSchema.fromResolvedSchema(values.getResolvedSchema()));
            if (values.getValues().isEmpty()) {
                QueryOperationConverter.this.relBuilder.values(rowType);
                return QueryOperationConverter.this.relBuilder.build();
            }
            ArrayList<List<RexLiteral>> rexLiterals = new ArrayList<List<RexLiteral>>();
            ArrayList<List<RexNode>> rexProjections = new ArrayList<List<RexNode>>();
            this.splitToProjectionsAndLiterals(values, rexLiterals, rexProjections);
            int inputs = 0;
            if (rexLiterals.size() != 0) {
                ++inputs;
                QueryOperationConverter.this.relBuilder.values(rexLiterals, rowType);
            }
            if (rexProjections.size() != 0) {
                inputs += rexProjections.size();
                this.applyProjections(values, rexProjections);
            }
            if (inputs > 1) {
                QueryOperationConverter.this.relBuilder.union(true, inputs);
            }
            return QueryOperationConverter.this.relBuilder.build();
        }

        private void applyProjections(ValuesQueryOperation values, List<List<RexNode>> rexProjections) {
            List relNodes = rexProjections.stream().map(exprs -> {
                QueryOperationConverter.this.relBuilder.push(LogicalValues.createOneRow(QueryOperationConverter.this.relBuilder.getCluster()));
                QueryOperationConverter.this.relBuilder.project((Iterable<? extends RexNode>)exprs, (Iterable<String>)values.getResolvedSchema().getColumnNames());
                return QueryOperationConverter.this.relBuilder.build();
            }).collect(Collectors.toList());
            QueryOperationConverter.this.relBuilder.pushAll(relNodes);
        }

        private void splitToProjectionsAndLiterals(ValuesQueryOperation values, List<List<RexLiteral>> rexValues, List<List<RexNode>> rexProjections) {
            values.getValues().stream().map(this::convertToRexNodes).forEach(row -> {
                boolean allLiterals = row.stream().allMatch(expr -> expr instanceof RexLiteral);
                if (allLiterals) {
                    rexValues.add(row.stream().map(expr -> (RexLiteral)expr).collect(Collectors.toList()));
                } else {
                    rexProjections.add((List<RexNode>)row);
                }
            });
        }

        @Override
        public RelNode visit(QueryOperation other) {
            if (other instanceof PlannerQueryOperation) {
                return ((PlannerQueryOperation)other).getCalciteTree();
            }
            if (other instanceof JavaDataStreamQueryOperation) {
                JavaDataStreamQueryOperation dataStreamQueryOperation = (JavaDataStreamQueryOperation)other;
                return this.convertToDataStreamScan(dataStreamQueryOperation.getDataStream(), dataStreamQueryOperation.getFieldIndices(), TableSchema.fromResolvedSchema(dataStreamQueryOperation.getResolvedSchema()));
            }
            if (other instanceof DataSetQueryOperation) {
                return this.convertToDataSetScan((DataSetQueryOperation)other);
            }
            if (other instanceof ScalaDataStreamQueryOperation) {
                ScalaDataStreamQueryOperation dataStreamQueryOperation = (ScalaDataStreamQueryOperation)other;
                return this.convertToDataStreamScan(dataStreamQueryOperation.getDataStream(), dataStreamQueryOperation.getFieldIndices(), TableSchema.fromResolvedSchema(dataStreamQueryOperation.getResolvedSchema()));
            }
            if (other instanceof JavaExternalQueryOperation) {
                JavaExternalQueryOperation externalQueryOperation = (JavaExternalQueryOperation)other;
                return this.convertToDataStreamScan(externalQueryOperation.getDataStream(), IntStream.range(0, externalQueryOperation.getDataStream().getType().getArity()).toArray(), TableSchema.fromResolvedSchema(externalQueryOperation.getResolvedSchema()));
            }
            if (other instanceof ScalaExternalQueryOperation) {
                ScalaExternalQueryOperation externalQueryOperation = (ScalaExternalQueryOperation)other;
                return this.convertToDataStreamScan(externalQueryOperation.getDataStream(), IntStream.range(0, externalQueryOperation.getDataStream().getType().getArity()).toArray(), TableSchema.fromResolvedSchema(externalQueryOperation.getResolvedSchema()));
            }
            throw new TableException("Unknown table operation: " + other);
        }

        @Override
        public <U> RelNode visit(TableSourceQueryOperation<U> tableSourceTable) {
            TableSourceTable<U> relTable = new TableSourceTable<U>(TableSchema.fromResolvedSchema(tableSourceTable.getResolvedSchema()), tableSourceTable.getTableSource(), !tableSourceTable.isBatch(), FlinkStatistic.UNKNOWN());
            CatalogReader catalogReader = (CatalogReader)QueryOperationConverter.this.relBuilder.getRelOptSchema();
            String refId = "unregistered_" + System.identityHashCode(tableSourceTable.getTableSource());
            return new FlinkLogicalTableSourceScan(QueryOperationConverter.this.relBuilder.getCluster(), QueryOperationConverter.this.relBuilder.getCluster().traitSet().replace(FlinkConventions.LOGICAL()), RelOptTableImpl.create((RelOptSchema)catalogReader, relTable.getRowType(QueryOperationConverter.this.relBuilder.getTypeFactory()), relTable, Schemas.path(catalogReader.getRootSchema(), Collections.singletonList(refId))), TableSchema.fromResolvedSchema(tableSourceTable.getResolvedSchema()), tableSourceTable.getTableSource(), (Option<int[]>)Option.empty());
        }

        private RelNode convertToDataStreamScan(DataStream<?> dataStream, int[] fieldIndices, TableSchema tableSchema) {
            RelDataType logicalRowType = QueryOperationConverter.this.relBuilder.getTypeFactory().buildLogicalRowType(tableSchema);
            RowSchema rowSchema = new RowSchema(logicalRowType);
            return new FlinkLogicalDataStreamScan(QueryOperationConverter.this.relBuilder.getCluster(), QueryOperationConverter.this.relBuilder.getCluster().traitSet().replace(FlinkConventions.LOGICAL()), QueryOperationConverter.this.relBuilder.getRelOptSchema(), dataStream, fieldIndices, rowSchema);
        }

        private RelNode convertToDataSetScan(DataSetQueryOperation<?> tableOperation) {
            RelDataType logicalRowType = QueryOperationConverter.this.relBuilder.getTypeFactory().buildLogicalRowType(TableSchema.fromResolvedSchema(tableOperation.getResolvedSchema()));
            return new FlinkLogicalDataSetScan(QueryOperationConverter.this.relBuilder.getCluster(), QueryOperationConverter.this.relBuilder.getCluster().traitSet().replace(FlinkConventions.LOGICAL()), QueryOperationConverter.this.relBuilder.getRelOptSchema(), tableOperation.getDataSet(), tableOperation.getFieldIndices(), logicalRowType);
        }

        private RexNode convertToRexNode(Expression expression2) {
            return ((PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(expression2)).toRexNode(QueryOperationConverter.this.relBuilder);
        }

        private List<RexNode> convertToRexNodes(List<ResolvedExpression> expressions) {
            return expressions.stream().map(QueryOperationConverter.this.expressionBridge::bridge).map(expr -> expr.toRexNode(QueryOperationConverter.this.relBuilder)).collect(Collectors.toList());
        }

        private LogicalWindow toLogicalWindow(WindowAggregateQueryOperation.ResolvedGroupWindow window) {
            TypeInformation<?> windowType = TypeConversions.fromDataTypeToLegacyInfo(window.getTimeAttribute().getOutputDataType());
            WindowReference windowReference = new WindowReference(window.getAlias(), (Option<TypeInformation<?>>)new Some(windowType));
            switch (window.getType()) {
                case SLIDE: {
                    return new SlidingGroupWindow(windowReference, (PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(window.getTimeAttribute()), window.getSize().map(QueryOperationConverter.this.expressionBridge::bridge).get(), window.getSlide().map(QueryOperationConverter.this.expressionBridge::bridge).get());
                }
                case SESSION: {
                    return new SessionGroupWindow(windowReference, (PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(window.getTimeAttribute()), window.getGap().map(QueryOperationConverter.this.expressionBridge::bridge).get());
                }
                case TUMBLE: {
                    return new TumblingGroupWindow(windowReference, (PlannerExpression)QueryOperationConverter.this.expressionBridge.bridge(window.getTimeAttribute()), window.getSize().map(QueryOperationConverter.this.expressionBridge::bridge).get());
                }
            }
            throw new TableException("Unknown window type");
        }

        private JoinRelType convertJoinType(JoinQueryOperation.JoinType joinType) {
            switch (joinType) {
                case INNER: {
                    return JoinRelType.INNER;
                }
                case LEFT_OUTER: {
                    return JoinRelType.LEFT;
                }
                case RIGHT_OUTER: {
                    return JoinRelType.RIGHT;
                }
                case FULL_OUTER: {
                    return JoinRelType.FULL;
                }
            }
            throw new TableException("Unknown join type: " + (Object)((Object)joinType));
        }
    }
}

