/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.resolver.SqlExpressionResolver;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
final class ResolveSqlCallRule
implements ResolverRule {
    ResolveSqlCallRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression2, ResolverRule.ResolutionContext context) {
        LogicalType outputType = context.getOutputDataType().map(DataType::getLogicalType).orElse(null);
        TranslateSqlCallsVisitor visitor = new TranslateSqlCallsVisitor(context, outputType);
        return expression2.stream().map(expr -> expr.accept(visitor)).collect(Collectors.toList());
    }

    private static class TranslateSqlCallsVisitor
    extends RuleExpressionVisitor<Expression> {
        @Nullable
        private final LogicalType outputType;

        TranslateSqlCallsVisitor(ResolverRule.ResolutionContext resolutionContext, @Nullable LogicalType outputType) {
            super(resolutionContext);
            this.outputType = outputType;
        }

        @Override
        public Expression visit(SqlCallExpression sqlCall) {
            SqlExpressionResolver resolver = this.resolutionContext.sqlExpressionResolver();
            ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
            this.resolutionContext.referenceLookup().getAllInputFields().forEach(f -> fields.add(new RowType.RowField(f.getName(), f.getOutputDataType().getLogicalType())));
            this.resolutionContext.getLocalReferences().forEach(refs -> fields.add(new RowType.RowField(refs.getName(), refs.getOutputDataType().getLogicalType())));
            return resolver.resolveExpression(sqlCall.getSqlExpression(), new RowType(false, fields), this.outputType);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            return unresolvedCall.replaceArgs(this.resolveChildren(unresolvedCall.getChildren()));
        }

        @Override
        protected Expression defaultMethod(Expression expression2) {
            return expression2;
        }

        private List<Expression> resolveChildren(List<Expression> lookupChildren) {
            TranslateSqlCallsVisitor visitor = new TranslateSqlCallsVisitor(this.resolutionContext, null);
            return lookupChildren.stream().map(child -> child.accept(visitor)).collect(Collectors.toList());
        }
    }
}

