/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TypeStringUtils;

@Deprecated
@PublicEvolving
public class OldCsv
extends FormatDescriptor {
    private Optional<String> fieldDelim = Optional.empty();
    private Optional<String> lineDelim = Optional.empty();
    private Map<String, String> schema = new LinkedHashMap<String, String>();
    private Optional<Character> quoteCharacter = Optional.empty();
    private Optional<String> commentPrefix = Optional.empty();
    private Optional<Boolean> isIgnoreFirstLine = Optional.empty();
    private Optional<Boolean> lenient = Optional.empty();
    private Optional<Boolean> deriveSchema = Optional.empty();
    private Optional<String> writeMode = Optional.empty();
    private Optional<Integer> numFiles = Optional.empty();

    public OldCsv() {
        super("csv", 1);
    }

    public OldCsv fieldDelimiter(String delim) {
        this.fieldDelim = Optional.of(delim);
        return this;
    }

    public OldCsv lineDelimiter(String delim) {
        this.lineDelim = Optional.of(delim);
        return this;
    }

    @Deprecated
    public OldCsv schema(TableSchema schema) {
        this.schema.clear();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.field(schema.getFieldNames()[i], schema.getFieldTypes()[i]);
        }
        return this;
    }

    @Deprecated
    public OldCsv field(String fieldName, TypeInformation<?> fieldType) {
        this.field(fieldName, TypeConversions.fromLegacyInfoToDataType(fieldType));
        return this;
    }

    @Deprecated
    public OldCsv field(String fieldName, DataType fieldType) {
        this.addField(fieldName, fieldType.getLogicalType().asSerializableString());
        return this;
    }

    @Deprecated
    public OldCsv field(String fieldName, String fieldType) {
        if (OldCsv.isLegacyTypeString(fieldType)) {
            TypeInformation<?> typeInfo = TypeStringUtils.readTypeInfo(fieldType);
            return this.field(fieldName, TypeConversions.fromLegacyInfoToDataType(typeInfo));
        }
        return this.addField(fieldName, fieldType);
    }

    private OldCsv addField(String fieldName, String fieldType) {
        if (this.schema.containsKey(fieldName)) {
            throw new ValidationException("Duplicate field name " + fieldName + ".");
        }
        this.schema.put(fieldName, fieldType);
        return this;
    }

    private static boolean isLegacyTypeString(String fieldType) {
        try {
            LogicalType type = LogicalTypeParser.parse(fieldType);
            return type instanceof UnresolvedUserDefinedType;
        }
        catch (Exception e) {
            return true;
        }
    }

    public OldCsv quoteCharacter(Character quote) {
        this.quoteCharacter = Optional.of(quote);
        return this;
    }

    public OldCsv commentPrefix(String prefix) {
        this.commentPrefix = Optional.of(prefix);
        return this;
    }

    public OldCsv ignoreFirstLine() {
        this.isIgnoreFirstLine = Optional.of(true);
        return this;
    }

    public OldCsv ignoreParseErrors() {
        this.lenient = Optional.of(true);
        return this;
    }

    public OldCsv writeMode(String writeMode) {
        this.writeMode = Optional.of(writeMode);
        return this;
    }

    public OldCsv numFiles(int numFiles) {
        this.numFiles = Optional.of(numFiles);
        return this;
    }

    @Deprecated
    public OldCsv deriveSchema() {
        this.deriveSchema = Optional.of(true);
        return this;
    }

    @Override
    protected Map<String, String> toFormatProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        this.fieldDelim.ifPresent(s -> properties.putString("format.field-delimiter", (String)s));
        this.lineDelim.ifPresent(s -> properties.putString("format.line-delimiter", (String)s));
        if (this.deriveSchema.isPresent() && this.deriveSchema.get().booleanValue()) {
            properties.putBoolean("format.derive-schema", true);
        } else {
            List<String> subKeys = Arrays.asList("name", "data-type");
            List<List<String>> subValues = this.schema.entrySet().stream().map(e -> Arrays.asList((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
            properties.putIndexedFixedProperties("format.fields", subKeys, subValues);
        }
        this.quoteCharacter.ifPresent(character -> properties.putCharacter("format.quote-character", character.charValue()));
        this.commentPrefix.ifPresent(s -> properties.putString("format.comment-prefix", (String)s));
        this.isIgnoreFirstLine.ifPresent(aBoolean -> properties.putBoolean("format.ignore-first-line", (boolean)aBoolean));
        this.lenient.ifPresent(aBoolean -> properties.putBoolean("format.ignore-parse-errors", (boolean)aBoolean));
        this.writeMode.ifPresent(s -> properties.putString("format.write-mode", (String)s));
        this.numFiles.ifPresent(i -> properties.putInt("format.num-files", (int)i));
        return properties.asMap();
    }
}

