/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.table.utils.TypeStringUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@Deprecated
@Internal
public class DescriptorProperties {
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String DATA_TYPE = "data-type";
    public static final String EXPR = "expr";
    public static final String METADATA = "metadata";
    public static final String VIRTUAL = "virtual";
    public static final String PARTITION_KEYS = "partition.keys";
    public static final String WATERMARK = "watermark";
    public static final String WATERMARK_ROWTIME = "rowtime";
    public static final String WATERMARK_STRATEGY = "strategy";
    public static final String WATERMARK_STRATEGY_EXPR = "strategy.expr";
    public static final String WATERMARK_STRATEGY_DATA_TYPE = "strategy.data-type";
    public static final String PRIMARY_KEY_NAME = "primary-key.name";
    public static final String PRIMARY_KEY_COLUMNS = "primary-key.columns";
    public static final String COMMENT = "comment";
    private static final Pattern SCHEMA_COLUMN_NAME_SUFFIX = Pattern.compile("\\d+\\.name");
    private static final Consumer<String> EMPTY_CONSUMER = value -> {};
    private final boolean normalizeKeys;
    private final Map<String, String> properties = new HashMap<String, String>();

    public DescriptorProperties(boolean normalizeKeys) {
        this.normalizeKeys = normalizeKeys;
    }

    public DescriptorProperties() {
        this(true);
    }

    public void putProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.put(property.getKey(), property.getValue());
        }
    }

    public void putProperties(DescriptorProperties otherProperties) {
        for (Map.Entry<String, String> otherProperty : otherProperties.properties.entrySet()) {
            this.put(otherProperty.getKey(), otherProperty.getValue());
        }
    }

    public void putPropertiesWithPrefix(String prefix, Map<String, String> prop) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull(prop);
        for (Map.Entry<String, String> e : prop.entrySet()) {
            this.put(String.format("%s.%s", prefix, e.getKey()), e.getValue());
        }
    }

    public void putClass(String key, Class<?> clazz) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(clazz);
        String error = InstantiationUtil.checkForInstantiationError(clazz);
        if (error != null) {
            throw new ValidationException("Class '" + clazz.getName() + "' is not supported: " + error);
        }
        this.put(key, clazz.getName());
    }

    public void putString(String key, String str) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)str);
        this.put(key, str);
    }

    public void putBoolean(String key, boolean b) {
        Preconditions.checkNotNull((Object)key);
        this.put(key, Boolean.toString(b));
    }

    public void putLong(String key, long l) {
        Preconditions.checkNotNull((Object)key);
        this.put(key, Long.toString(l));
    }

    public void putInt(String key, int i) {
        Preconditions.checkNotNull((Object)key);
        this.put(key, Integer.toString(i));
    }

    public void putCharacter(String key, char c) {
        Preconditions.checkNotNull((Object)key);
        this.put(key, Character.toString(c));
    }

    public void putTableSchema(String key, TableSchema schema) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)schema);
        String[] fieldNames = schema.getFieldNames();
        DataType[] fieldTypes = schema.getFieldDataTypes();
        String[] fieldExpressions = (String[])schema.getTableColumns().stream().map(column -> {
            if (column instanceof TableColumn.ComputedColumn) {
                return ((TableColumn.ComputedColumn)column).getExpression();
            }
            return null;
        }).toArray(String[]::new);
        String[] fieldMetadata = (String[])schema.getTableColumns().stream().map(column -> {
            if (column instanceof TableColumn.MetadataColumn) {
                return ((TableColumn.MetadataColumn)column).getMetadataAlias().orElse(column.getName());
            }
            return null;
        }).toArray(String[]::new);
        String[] fieldVirtual = (String[])schema.getTableColumns().stream().map(column -> {
            if (column instanceof TableColumn.MetadataColumn) {
                return Boolean.toString(((TableColumn.MetadataColumn)column).isVirtual());
            }
            return null;
        }).toArray(String[]::new);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            values.add(Arrays.asList(fieldNames[i], fieldTypes[i].getLogicalType().asSerializableString(), fieldExpressions[i], fieldMetadata[i], fieldVirtual[i]));
        }
        this.putIndexedOptionalProperties(key, Arrays.asList(NAME, DATA_TYPE, EXPR, METADATA, VIRTUAL), values);
        if (!schema.getWatermarkSpecs().isEmpty()) {
            ArrayList<List<String>> watermarkValues = new ArrayList<List<String>>();
            for (WatermarkSpec spec : schema.getWatermarkSpecs()) {
                watermarkValues.add(Arrays.asList(spec.getRowtimeAttribute(), spec.getWatermarkExpr(), spec.getWatermarkExprOutputType().getLogicalType().asSerializableString()));
            }
            this.putIndexedFixedProperties(key + '.' + WATERMARK, Arrays.asList(WATERMARK_ROWTIME, WATERMARK_STRATEGY_EXPR, WATERMARK_STRATEGY_DATA_TYPE), watermarkValues);
        }
        schema.getPrimaryKey().ifPresent(pk -> {
            this.putString(key + '.' + PRIMARY_KEY_NAME, pk.getName());
            this.putString(key + '.' + PRIMARY_KEY_COLUMNS, String.join((CharSequence)",", pk.getColumns()));
        });
    }

    public void putPartitionKeys(List<String> keys) {
        Preconditions.checkNotNull(keys);
        this.putIndexedFixedProperties(PARTITION_KEYS, Collections.singletonList(NAME), keys.stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    public void putMemorySize(String key, MemorySize size) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)size);
        this.put(key, size.toString());
    }

    public void putIndexedFixedProperties(String key, List<String> subKeys, List<List<String>> subKeyValues) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(subKeys);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            List<String> values = subKeyValues.get(idx);
            if (values == null || values.size() != subKeys.size()) {
                throw new ValidationException("Values must have same arity as keys.");
            }
            for (int keyIdx = 0; keyIdx < values.size(); ++keyIdx) {
                this.put(key + '.' + idx + '.' + subKeys.get(keyIdx), values.get(keyIdx));
            }
        }
    }

    public void putIndexedOptionalProperties(String key, List<String> subKeys, List<List<String>> subKeyValues) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(subKeys);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            List<String> values = subKeyValues.get(idx);
            if (values == null || values.size() != subKeys.size()) {
                throw new ValidationException("Values must have same arity as keys.");
            }
            if (values.stream().allMatch(Objects::isNull)) {
                throw new ValidationException("Values must have at least one non-null value.");
            }
            for (int keyIdx = 0; keyIdx < values.size(); ++keyIdx) {
                String value = values.get(keyIdx);
                if (value == null) continue;
                this.put(key + '.' + idx + '.' + subKeys.get(keyIdx), values.get(keyIdx));
            }
        }
    }

    public void putIndexedVariableProperties(String key, List<Map<String, String>> subKeyValues) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            Map<String, String> values = subKeyValues.get(idx);
            for (Map.Entry<String, String> value : values.entrySet()) {
                this.put(key + '.' + idx + '.' + value.getKey(), value.getValue());
            }
        }
    }

    public Optional<String> getOptionalString(String key) {
        return this.optionalGet(key);
    }

    public String getString(String key) {
        return this.getOptionalString(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Character> getOptionalCharacter(String key) {
        return this.optionalGet(key).map(c -> {
            if (c.length() != 1) {
                throw new ValidationException("The value of '" + key + "' must only contain one character.");
            }
            return Character.valueOf(c.charAt(0));
        });
    }

    public Character getCharacter(String key) {
        return this.getOptionalCharacter(key).orElseThrow(this.exceptionSupplier(key));
    }

    public <T> Optional<Class<T>> getOptionalClass(String key, Class<T> superClass) {
        return this.optionalGet(key).map(name -> {
            try {
                Class<?> clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
                if (!superClass.isAssignableFrom(clazz)) {
                    throw new ValidationException("Class '" + name + "' does not extend from the required class '" + superClass.getName() + "' for key '" + key + "'.");
                }
                return clazz;
            }
            catch (Exception e) {
                throw new ValidationException("Could not get class '" + name + "' for key '" + key + "'.", e);
            }
        });
    }

    public <T> Class<T> getClass(String key, Class<T> superClass) {
        return this.getOptionalClass(key, superClass).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<BigDecimal> getOptionalBigDecimal(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return new BigDecimal((String)value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid decimal value for key '" + key + "'.", e);
            }
        });
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getOptionalBigDecimal(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Boolean> getOptionalBoolean(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid boolean value for key '" + key + "'.", e);
            }
        });
    }

    public boolean getBoolean(String key) {
        return this.getOptionalBoolean(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Byte> getOptionalByte(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Byte.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid byte value for key '" + key + "'.", e);
            }
        });
    }

    public byte getByte(String key) {
        return this.getOptionalByte(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Double> getOptionalDouble(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Double.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid double value for key '" + key + "'.", e);
            }
        });
    }

    public double getDouble(String key) {
        return this.getOptionalDouble(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Float> getOptionalFloat(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Float.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid float value for key '" + key + "'.", e);
            }
        });
    }

    public float getFloat(String key) {
        return this.getOptionalFloat(key).orElseThrow(this.exceptionSupplier(key)).floatValue();
    }

    public Optional<Integer> getOptionalInt(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid integer value for key '" + key + "'.", e);
            }
        });
    }

    public int getInt(String key) {
        return this.getOptionalInt(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Long> getOptionalLong(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid long value for key '" + key + "'.", e);
            }
        });
    }

    public long getLong(String key) {
        return this.getOptionalLong(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Short> getOptionalShort(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return Short.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid short value for key '" + key + "'.", e);
            }
        });
    }

    public short getShort(String key) {
        return this.getOptionalShort(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<TypeInformation<?>> getOptionalType(String key) {
        return this.optionalGet(key).map(TypeStringUtils::readTypeInfo);
    }

    public TypeInformation<?> getType(String key) {
        return this.getOptionalType(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<DataType> getOptionalDataType(String key) {
        return this.optionalGet(key).map(t -> TypeConversions.fromLogicalToDataType(LogicalTypeParser.parse(t)));
    }

    public DataType getDataType(String key) {
        return this.getOptionalDataType(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<TableSchema> getOptionalTableSchema(String key) {
        String pkConstraintNameKey;
        Optional<String> pkConstraintNameOpt;
        String exprKey;
        int fieldCount = this.properties.keySet().stream().filter(k -> k.startsWith(key) && SCHEMA_COLUMN_NAME_SUFFIX.matcher(k.substring(key.length() + 1)).matches()).mapToInt(k -> 1).sum();
        if (fieldCount == 0) {
            return Optional.empty();
        }
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        for (int i = 0; i < fieldCount; ++i) {
            DataType type;
            String nameKey = key + '.' + i + '.' + NAME;
            String legacyTypeKey = key + '.' + i + '.' + TYPE;
            String typeKey = key + '.' + i + '.' + DATA_TYPE;
            exprKey = key + '.' + i + '.' + EXPR;
            String metadataKey = key + '.' + i + '.' + METADATA;
            String virtualKey = key + '.' + i + '.' + VIRTUAL;
            String name = this.optionalGet(nameKey).orElseThrow(this.exceptionSupplier(nameKey));
            if (this.containsKey(typeKey)) {
                type = this.getDataType(typeKey);
            } else if (this.containsKey(legacyTypeKey)) {
                type = TypeConversions.fromLegacyInfoToDataType(this.getType(legacyTypeKey));
            } else {
                throw this.exceptionSupplier(typeKey).get();
            }
            Optional<String> expr = this.optionalGet(exprKey);
            Optional<String> metadata = this.optionalGet(metadataKey);
            boolean virtual = this.getOptionalBoolean(virtualKey).orElse(false);
            if (expr.isPresent()) {
                schemaBuilder.add(TableColumn.computed(name, type, expr.get()));
                continue;
            }
            if (metadata.isPresent()) {
                String metadataAlias = metadata.get();
                if (metadataAlias.equals(name)) {
                    schemaBuilder.add(TableColumn.metadata(name, type, virtual));
                    continue;
                }
                schemaBuilder.add(TableColumn.metadata(name, type, metadataAlias, virtual));
                continue;
            }
            schemaBuilder.add(TableColumn.physical(name, type));
        }
        String watermarkPrefixKey = key + '.' + WATERMARK;
        int watermarkCount = this.properties.keySet().stream().filter(k -> k.startsWith(watermarkPrefixKey) && k.endsWith(".rowtime")).mapToInt(k -> 1).sum();
        if (watermarkCount > 0) {
            for (int i = 0; i < watermarkCount; ++i) {
                String rowtimeKey = watermarkPrefixKey + '.' + i + '.' + WATERMARK_ROWTIME;
                exprKey = watermarkPrefixKey + '.' + i + '.' + WATERMARK_STRATEGY_EXPR;
                String typeKey = watermarkPrefixKey + '.' + i + '.' + WATERMARK_STRATEGY_DATA_TYPE;
                String rowtime2 = this.optionalGet(rowtimeKey).orElseThrow(this.exceptionSupplier(rowtimeKey));
                String exprString = this.optionalGet(exprKey).orElseThrow(this.exceptionSupplier(exprKey));
                String typeString = this.optionalGet(typeKey).orElseThrow(this.exceptionSupplier(typeKey));
                DataType exprType = TypeConversions.fromLogicalToDataType(LogicalTypeParser.parse(typeString));
                schemaBuilder.watermark(rowtime2, exprString, exprType);
            }
        }
        if ((pkConstraintNameOpt = this.optionalGet(pkConstraintNameKey = key + '.' + PRIMARY_KEY_NAME)).isPresent()) {
            String pkColumnsKey = key + '.' + PRIMARY_KEY_COLUMNS;
            String columns = this.optionalGet(pkColumnsKey).orElseThrow(this.exceptionSupplier(pkColumnsKey));
            schemaBuilder.primaryKey(pkConstraintNameOpt.get(), columns.split(","));
        }
        return Optional.of(schemaBuilder.build());
    }

    public TableSchema getTableSchema(String key) {
        return this.getOptionalTableSchema(key).orElseThrow(this.exceptionSupplier(key));
    }

    public List<String> getPartitionKeys() {
        return this.getFixedIndexedProperties(PARTITION_KEYS, Collections.singletonList(NAME)).stream().map(map -> (String)map.values().iterator().next()).map(this::getString).collect(Collectors.toList());
    }

    public Optional<MemorySize> getOptionalMemorySize(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return MemorySize.parse((String)value, (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid memory size value for key '" + key + "'.", e);
            }
        });
    }

    public MemorySize getMemorySize(String key) {
        return this.getOptionalMemorySize(key).orElseThrow(this.exceptionSupplier(key));
    }

    public Optional<Duration> getOptionalDuration(String key) {
        return this.optionalGet(key).map(value -> {
            try {
                return TimeUtils.parseDuration((String)value);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid duration value for key '" + key + "'.", e);
            }
        });
    }

    public Duration getDuration(String key) {
        return this.getOptionalDuration(key).orElseThrow(this.exceptionSupplier(key));
    }

    public List<Map<String, String>> getFixedIndexedProperties(String key, List<String> subKeys) {
        int maxIndex = this.extractMaxIndex(key, "\\.(.*)");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= maxIndex; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String subKey : subKeys) {
                String fullKey = key + '.' + i + '.' + subKey;
                if (!this.containsKey(fullKey)) {
                    throw this.exceptionSupplier(fullKey).get();
                }
                map.put(subKey, fullKey);
            }
            list.add(map);
        }
        return list;
    }

    public List<Map<String, String>> getVariableIndexedProperties(String key, List<String> requiredSubKeys) {
        int maxIndex = this.extractMaxIndex(key, "(\\.)?(.*)");
        String escapedKey = Pattern.quote(key);
        Pattern pattern = Pattern.compile(escapedKey + "\\.(\\d+)(\\.)?(.*)");
        Set optionalSubKeys = this.properties.keySet().stream().flatMap(k -> {
            Matcher matcher = pattern.matcher((CharSequence)k);
            if (matcher.find()) {
                return Stream.of(matcher.group(3));
            }
            return Stream.empty();
        }).filter(k -> k.length() > 0).collect(Collectors.toSet());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= maxIndex; ++i) {
            String fullKey;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String subKey : requiredSubKeys) {
                fullKey = key + '.' + i + '.' + subKey;
                if (!this.containsKey(fullKey)) {
                    throw this.exceptionSupplier(fullKey).get();
                }
                map.put(subKey, fullKey);
            }
            for (String subKey : optionalSubKeys) {
                fullKey = key + '.' + i + '.' + subKey;
                this.optionalGet(fullKey).ifPresent(value -> map.put(subKey, fullKey));
            }
            list.add(map);
        }
        return list;
    }

    public Map<String, String> getIndexedProperty(String key, String subKey) {
        String escapedKey = Pattern.quote(key);
        String escapedSubKey = Pattern.quote(subKey);
        return this.properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).matches(escapedKey + "\\.\\d+\\." + escapedSubKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <E> Optional<List<E>> getOptionalArray(String key, Function<String, E> keyMapper) {
        int maxIndex = this.extractMaxIndex(key, "");
        if (maxIndex < 0) {
            if (this.containsKey(key)) {
                return Optional.of(Collections.singletonList(keyMapper.apply(key)));
            }
            return Optional.empty();
        }
        ArrayList<E> list = new ArrayList<E>();
        for (int i = 0; i < maxIndex + 1; ++i) {
            String fullKey = key + '.' + i;
            E value = keyMapper.apply(fullKey);
            list.add(value);
        }
        return Optional.of(list);
    }

    public <E> List<E> getArray(String key, Function<String, E> keyMapper) {
        return this.getOptionalArray(key, keyMapper).orElseThrow(this.exceptionSupplier(key));
    }

    public boolean isValue(String key, String value) {
        return this.optionalGet(key).orElseThrow(this.exceptionSupplier(key)).equals(value);
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix) {
        String prefixWithDot = prefix + '.';
        return this.properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefixWithDot)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length() + 1), Map.Entry::getValue));
    }

    public void validateString(String key, boolean isOptional) {
        this.validateString(key, isOptional, 0, Integer.MAX_VALUE);
    }

    public void validateString(String key, boolean isOptional, int minLen) {
        this.validateString(key, isOptional, minLen, Integer.MAX_VALUE);
    }

    public void validateString(String key, boolean isOptional, int minLen, int maxLen) {
        this.validateOptional(key, isOptional, value -> {
            int length = value.length();
            if (length < minLen || length > maxLen) {
                throw new ValidationException("Property '" + key + "' must have a length between " + minLen + " and " + maxLen + " but was: " + value);
            }
        });
    }

    public void validateInt(String key, boolean isOptional) {
        this.validateInt(key, isOptional, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void validateInt(String key, boolean isOptional, int min) {
        this.validateInt(key, isOptional, min, Integer.MAX_VALUE);
    }

    public void validateInt(String key, boolean isOptional, int min, int max) {
        this.validateComparable(key, isOptional, min, max, "integer", Integer::valueOf);
    }

    public void validateLong(String key, boolean isOptional) {
        this.validateLong(key, isOptional, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public void validateLong(String key, boolean isOptional, long min) {
        this.validateLong(key, isOptional, min, Long.MAX_VALUE);
    }

    public void validateLong(String key, boolean isOptional, long min, long max) {
        this.validateComparable(key, isOptional, min, max, "long", Long::valueOf);
    }

    public void validateValue(String key, String value, boolean isOptional) {
        this.validateOptional(key, isOptional, v -> {
            if (!v.equals(value)) {
                throw new ValidationException("Could not find required value '" + value + "' for property '" + key + "'.");
            }
        });
    }

    public void validateBoolean(String key, boolean isOptional) {
        this.validateOptional(key, isOptional, value -> {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                throw new ValidationException("Property '" + key + "' must be a boolean value (true/false) but was: " + value);
            }
        });
    }

    public void validateDouble(String key, boolean isOptional) {
        this.validateDouble(key, isOptional, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public void validateDouble(String key, boolean isOptional, double min) {
        this.validateDouble(key, isOptional, min, Double.MAX_VALUE);
    }

    public void validateDouble(String key, boolean isOptional, double min, double max) {
        this.validateComparable(key, isOptional, min, max, "double", Double::valueOf);
    }

    public void validateBigDecimal(String key, boolean isOptional) {
        this.validateOptional(key, isOptional, value -> {
            try {
                new BigDecimal((String)value);
            }
            catch (Exception e) {
                throw new ValidationException("Property '" + key + "' must be a big decimal value but was: " + value);
            }
        });
    }

    public void validateBigDecimal(String key, boolean isOptional, BigDecimal min, BigDecimal max) {
        this.validateComparable(key, isOptional, min, max, "decimal", BigDecimal::new);
    }

    public void validateByte(String key, boolean isOptional) {
        this.validateByte(key, isOptional, (byte)-128, (byte)127);
    }

    public void validateByte(String key, boolean isOptional, byte min) {
        this.validateByte(key, isOptional, min, (byte)127);
    }

    public void validateByte(String key, boolean isOptional, byte min, byte max) {
        this.validateComparable(key, isOptional, min, max, "byte", Byte::valueOf);
    }

    public void validateFloat(String key, boolean isOptional) {
        this.validateFloat(key, isOptional, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public void validateFloat(String key, boolean isOptional, float min) {
        this.validateFloat(key, isOptional, min, Float.MAX_VALUE);
    }

    public void validateFloat(String key, boolean isOptional, float min, float max) {
        this.validateComparable(key, isOptional, Float.valueOf(min), Float.valueOf(max), "float", Float::valueOf);
    }

    public void validateShort(String key, boolean isOptional) {
        this.validateShort(key, isOptional, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    public void validateShort(String key, boolean isOptional, short min) {
        this.validateShort(key, isOptional, min, (short)Short.MAX_VALUE);
    }

    public void validateShort(String key, boolean isOptional, short min, short max) {
        this.validateComparable(key, isOptional, min, max, "short", Short::valueOf);
    }

    public void validateFixedIndexedProperties(String key, boolean allowEmpty, Map<String, Consumer<String>> subKeyValidation) {
        int maxIndex = this.extractMaxIndex(key, "\\.(.*)");
        if (maxIndex < 0 && !allowEmpty) {
            throw new ValidationException("Property key '" + key + "' must not be empty.");
        }
        for (int i = 0; i <= maxIndex; ++i) {
            for (Map.Entry<String, Consumer<String>> subKey : subKeyValidation.entrySet()) {
                String fullKey = key + '.' + i + '.' + subKey.getKey();
                subKey.getValue().accept(fullKey);
            }
        }
    }

    public void validateTableSchema(String key, boolean isOptional) {
        Consumer<String> nameValidation = fullKey -> this.validateString((String)fullKey, false, 1);
        Consumer<String> typeValidation = fullKey -> {
            String fallbackKey = fullKey.replace(".data-type", ".type");
            this.validateDataType((String)fullKey, fallbackKey, false);
        };
        HashMap<String, Consumer<String>> subKeys = new HashMap<String, Consumer<String>>();
        subKeys.put(NAME, nameValidation);
        subKeys.put(DATA_TYPE, typeValidation);
        this.validateFixedIndexedProperties(key, isOptional, subKeys);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision) {
        this.validateMemorySize(key, isOptional, precision, 0L, Long.MAX_VALUE);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision, long min) {
        this.validateMemorySize(key, isOptional, precision, min, Long.MAX_VALUE);
    }

    public void validateMemorySize(String key, boolean isOptional, int precision, long min, long max) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0);
        this.validateComparable(key, isOptional, min, max, "memory size (in bytes)", value -> {
            long bytes = MemorySize.parse((String)value, (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES).getBytes();
            if (bytes % (long)precision != 0L) {
                throw new ValidationException("Memory size for key '" + key + "' must be a multiple of " + precision + " bytes but was: " + value);
            }
            return bytes;
        });
    }

    public void validateDuration(String key, boolean isOptional, int precision) {
        this.validateDuration(key, isOptional, precision, 0L, Long.MAX_VALUE);
    }

    public void validateDuration(String key, boolean isOptional, int precision, long min) {
        this.validateDuration(key, isOptional, precision, min, Long.MAX_VALUE);
    }

    public void validateDuration(String key, boolean isOptional, int precision, long min, long max) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0);
        this.validateComparable(key, isOptional, min, max, "time interval (in milliseconds)", value -> {
            long ms = TimeUtils.parseDuration((String)value).toMillis();
            if (ms % (long)precision != 0L) {
                throw new ValidationException("Duration for key '" + key + "' must be a multiple of " + precision + " milliseconds but was: " + value);
            }
            return ms;
        });
    }

    public void validateEnum(String key, boolean isOptional, Map<String, Consumer<String>> enumValidation) {
        this.validateOptional(key, isOptional, value -> {
            if (!enumValidation.containsKey(value)) {
                throw new ValidationException("Unknown value for property '" + key + "'.\nSupported values are " + enumValidation.keySet() + " but was: " + value);
            }
            ((Consumer)enumValidation.get(value)).accept(key);
        });
    }

    public void validateEnumValues(String key, boolean isOptional, List<String> values) {
        this.validateEnum(key, isOptional, values.stream().collect(Collectors.toMap(v -> v, v -> DescriptorProperties.noValidation())));
    }

    public void validateType(String key, boolean isOptional, boolean requireRow) {
        this.validateOptional(key, isOptional, value -> {
            TypeInformation<?> typeInfo = TypeStringUtils.readTypeInfo(value);
            if (requireRow && !(typeInfo instanceof RowTypeInfo)) {
                throw new ValidationException("Row type information expected for key '" + key + "' but was: " + value);
            }
        });
    }

    public void validateDataType(String key, String fallbackKey, boolean isOptional) {
        if (this.properties.containsKey(key)) {
            this.validateOptional(key, isOptional, v -> {
                LogicalType t = LogicalTypeParser.parse(v);
                if (t.getTypeRoot() == LogicalTypeRoot.UNRESOLVED) {
                    throw new ValidationException("Could not parse type string '" + v + "'.");
                }
            });
        } else if (fallbackKey != null && this.properties.containsKey(fallbackKey)) {
            this.validateOptional(fallbackKey, isOptional, TypeStringUtils::readTypeInfo);
        } else if (!isOptional) {
            throw new ValidationException("Could not find required property '" + key + "'.");
        }
    }

    public void validateArray(String key, Consumer<String> elementValidation, int minLength) {
        this.validateArray(key, elementValidation, minLength, Integer.MAX_VALUE);
    }

    public void validateArray(String key, Consumer<String> elementValidation, int minLength, int maxLength) {
        int maxIndex = this.extractMaxIndex(key, "");
        if (maxIndex < 0) {
            if (this.properties.containsKey(key)) {
                elementValidation.accept(key);
            } else if (minLength > 0) {
                throw new ValidationException("Could not find required property array for key '" + key + "'.");
            }
        } else {
            if (this.properties.containsKey(key)) {
                throw new ValidationException("Invalid property array for key '" + key + "'.");
            }
            int size = maxIndex + 1;
            if (size < minLength) {
                throw new ValidationException("Array for key '" + key + "' must not have less than " + minLength + " elements but was: " + size);
            }
            if (size > maxLength) {
                throw new ValidationException("Array for key '" + key + "' must not have more than " + maxLength + " elements but was: " + size);
            }
        }
        for (int i = 0; i <= maxIndex; ++i) {
            String fullKey = key + '.' + i;
            if (!this.properties.containsKey(fullKey)) {
                throw new ValidationException("Required array element at index '" + i + "' for key '" + key + "' is missing.");
            }
            elementValidation.accept(fullKey);
        }
    }

    public void validatePrefixExclusion(String prefix) {
        this.properties.keySet().stream().filter(k -> k.startsWith(prefix)).findFirst().ifPresent(k -> {
            throw new ValidationException("Properties with prefix '" + prefix + "' are not allowed in this context. But property '" + k + "' was found.");
        });
    }

    public void validateExclusion(String key) {
        if (this.properties.containsKey(key)) {
            throw new ValidationException("Property '" + key + "' is not allowed in this context.");
        }
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean hasPrefix(String prefix) {
        return this.properties.keySet().stream().anyMatch(k -> k.startsWith(prefix));
    }

    public Map<String, String> asMap() {
        HashMap<String, String> copy = new HashMap<String, String>(this.properties);
        return Collections.unmodifiableMap(copy);
    }

    public Map<String, String> asPrefixedMap(String prefix) {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e -> prefix + (String)e.getKey(), Map.Entry::getValue));
    }

    public DescriptorProperties withoutKeys(List<String> keys) {
        HashSet<String> keySet = new HashSet<String>(keys);
        DescriptorProperties copy = new DescriptorProperties(this.normalizeKeys);
        this.properties.entrySet().stream().filter(e -> !keySet.contains(e.getKey())).forEach(e -> copy.properties.put((String)e.getKey(), (String)e.getValue()));
        return copy;
    }

    public String toString() {
        return DescriptorProperties.toString(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorProperties that = (DescriptorProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    private void put(String key, String value) {
        if (this.properties.containsKey(key)) {
            throw new ValidationException("Property already present: " + key);
        }
        if (this.normalizeKeys) {
            this.properties.put(key.toLowerCase(), value);
        } else {
            this.properties.put(key, value);
        }
    }

    private Optional<String> optionalGet(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    private void validateOptional(String key, boolean isOptional, Consumer<String> valueValidation) {
        if (!this.properties.containsKey(key)) {
            if (!isOptional) {
                throw new ValidationException("Could not find required property '" + key + "'.");
            }
        } else {
            String value = this.properties.get(key);
            valueValidation.accept(value);
        }
    }

    private Supplier<TableException> exceptionSupplier(String key) {
        return () -> {
            throw new TableException("Property with key '" + key + "' could not be found. This is a bug because the validation logic should have checked that before.");
        };
    }

    private int extractMaxIndex(String key, String suffixPattern) {
        String escapedKey = Pattern.quote(key);
        Pattern pattern = Pattern.compile(escapedKey + "\\.(\\d+)" + suffixPattern);
        IntStream indexes = this.properties.keySet().stream().flatMapToInt(k -> {
            Matcher matcher = pattern.matcher((CharSequence)k);
            if (matcher.find()) {
                return IntStream.of((int)Integer.valueOf(matcher.group(1)));
            }
            return IntStream.empty();
        });
        return indexes.max().orElse(-1);
    }

    private <T extends Comparable<T>> void validateComparable(String key, boolean isOptional, T min, T max, String typeName, Function<String, T> parseFunction) {
        if (!this.properties.containsKey(key)) {
            if (!isOptional) {
                throw new ValidationException("Could not find required property '" + key + "'.");
            }
        } else {
            String value = this.properties.get(key);
            try {
                Comparable parsed = (Comparable)parseFunction.apply(value);
                if (parsed.compareTo(min) < 0 || parsed.compareTo(max) > 0) {
                    throw new ValidationException("Property '" + key + "' must be a " + typeName + " value between " + min + " and " + max + " but was: " + parsed);
                }
            }
            catch (Exception e) {
                throw new ValidationException("Property '" + key + "' must be a " + typeName + " value but was: " + value);
            }
        }
    }

    public static Consumer<String> noValidation() {
        return EMPTY_CONSUMER;
    }

    public static String toString(String str) {
        return EncodingUtils.escapeJava(str);
    }

    public static String toString(String key, String value) {
        return DescriptorProperties.toString(key) + '=' + DescriptorProperties.toString(value);
    }

    public static String toString(Map<String, String> propertyMap) {
        return propertyMap.entrySet().stream().map(e -> DescriptorProperties.toString((String)e.getKey(), (String)e.getValue())).sorted().collect(Collectors.joining("\n"));
    }
}

