/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ExternalSchemaTranslator;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ScalaDataStreamQueryOperation;
import org.apache.flink.table.operations.ScalaExternalQueryOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Internal
@ScalaSignature(bytes="\u0006\u0001\u0011Ud\u0001B\u0001\u0003\u0001M\u0011!d\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%na2T!a\u0001\u0003\u0002\u0011%tG/\u001a:oC2T!!\u0002\u0004\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dA\u0011A\u00022sS\u0012<WM\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001F\r\u0011\u0005U9R\"\u0001\f\u000b\u0005\rA\u0011B\u0001\r\u0017\u0005Q!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/S7qYB\u0011!dG\u0007\u0002\t%\u0011A\u0004\u0002\u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011aB2bi\u0006dwnZ\u0005\u0003I\u0005\u0012abQ1uC2|w-T1oC\u001e,'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u00035iw\u000eZ;mK6\u000bg.Y4feB\u0011\u0001fK\u0007\u0002S)\u0011!FC\u0001\u0007[>$W\u000f\\3\n\u00051J#!D'pIVdW-T1oC\u001e,'\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00111\u0013\t\t\u0014EA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014AB2p]\u001aLw\r\u0005\u00026m5\t\u0001\"\u0003\u00028\u0011\tYA+\u00192mK\u000e{gNZ5h\u0011!I\u0004A!A!\u0002\u0013Q\u0014!G:dC2\fW\t_3dkRLwN\\#om&\u0014xN\\7f]R\u0004\"a\u000f!\u000e\u0003qR!!B\u001f\u000b\u0005%q$BA \r\u0003%\u0019HO]3b[&tw-\u0003\u0002By\tQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"A1\t\u0001B\u0001B\u0003%A)A\u0004qY\u0006tg.\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011\u0011J\u0012\u0002\b!2\fgN\\3s\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001C3yK\u000e,Ho\u001c:\u0011\u0005\u0015k\u0015B\u0001(G\u0005!)\u00050Z2vi>\u0014\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003%Rk\u0011a\u0015\u0006\u0002\u000b%\u0011Qk\u0015\u0002\b\u0005>|G.Z1o\u0011!9\u0006A!A!\u0002\u0013A\u0016aD;tKJ\u001cE.Y:t\u0019>\fG-\u001a:\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\u0019a\u0014N\\5u}QQ1-\u001a4hQ&T7\u000e\\7\u0011\u0005\u0011\u0004Q\"\u0001\u0002\t\u000by\u0001\u0007\u0019A\u0010\t\u000b\u0019\u0002\u0007\u0019A\u0014\t\u000b9\u0002\u0007\u0019A\u0018\t\u000bM\u0002\u0007\u0019\u0001\u001b\t\u000be\u0002\u0007\u0019\u0001\u001e\t\u000b\r\u0003\u0007\u0019\u0001#\t\u000b-\u0003\u0007\u0019\u0001'\t\u000bA\u0003\u0007\u0019A)\t\u000b]\u0003\u0007\u0019\u0001-\t\u000b=\u0004A\u0011\t9\u0002\u001d\u0019\u0014x.\u001c#bi\u0006\u001cFO]3b[V\u0011\u0011\u000f \u000b\u0003eV\u0004\"!N:\n\u0005QD!!\u0002+bE2,\u0007\"\u0002<o\u0001\u00049\u0018A\u00033bi\u0006\u001cFO]3b[B\u00191\b\u001f>\n\u0005ed$A\u0003#bi\u0006\u001cFO]3b[B\u00111\u0010 \u0007\u0001\t\u0015ihN1\u0001\u007f\u0005\u0005!\u0016cA@\u0002\u0006A\u0019!+!\u0001\n\u0007\u0005\r1KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b9!C\u0002\u0002\nM\u00131!\u00118z\u0011\u0019y\u0007\u0001\"\u0011\u0002\u000eU!\u0011qBA\f)\u0015\u0011\u0018\u0011CA\r\u0011\u001d1\u00181\u0002a\u0001\u0003'\u0001Ba\u000f=\u0002\u0016A\u001910a\u0006\u0005\ru\fYA1\u0001\u007f\u0011!\tY\"a\u0003A\u0002\u0005u\u0011AB:dQ\u0016l\u0017\rE\u00026\u0003?I1!!\t\t\u0005\u0019\u00196\r[3nC\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012a\u00054s_6\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGc\u0001:\u0002*!9a/a\tA\u0002\u0005-\u0002\u0003B\u001ey\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003ga\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u001c\u0003c\u00111AU8x\u0011\u001d\t)\u0003\u0001C!\u0003w!RA]A\u001f\u0003\u007fAqA^A\u001d\u0001\u0004\tY\u0003\u0003\u0005\u0002\u001c\u0005e\u0002\u0019AA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003\u0007\"rA]A#\u0003\u000f\nI\u0005C\u0004w\u0003\u0003\u0002\r!a\u000b\t\u0011\u0005m\u0011\u0011\ta\u0001\u0003;A\u0001\"a\u0013\u0002B\u0001\u0007\u0011QJ\u0001\u000eG\"\fgnZ3m_\u001elu\u000eZ3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u000b\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002X\u0005E#!D\"iC:<W\r\\8h\u001b>$W\rC\u0004\u0002\\\u0001!\t%!\u0018\u0002'\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bef4\u0016.Z<\u0016\t\u0005}\u0013q\u0010\u000b\u0007\u0003C\n9'!\u001f\u0011\u0007I\u000b\u0019'C\u0002\u0002fM\u0013A!\u00168ji\"A\u0011\u0011NA-\u0001\u0004\tY'\u0001\u0003qCRD\u0007\u0003BA7\u0003gr1AUA8\u0013\r\t\thU\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E4\u000bC\u0004w\u00033\u0002\r!a\u001f\u0011\tmB\u0018Q\u0010\t\u0004w\u0006}DAB?\u0002Z\t\u0007a\u0010C\u0004\u0002\\\u0001!\t%a!\u0016\t\u0005\u0015\u0015q\u0012\u000b\t\u0003C\n9)!#\u0002\u0012\"A\u0011\u0011NAA\u0001\u0004\tY\u0007C\u0004w\u0003\u0003\u0003\r!a#\u0011\tmB\u0018Q\u0012\t\u0004w\u0006=EAB?\u0002\u0002\n\u0007a\u0010\u0003\u0005\u0002\u001c\u0005\u0005\u0005\u0019AA\u000f\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000b!C\u001a:p[N#(/Z1n\u0013:$XM\u001d8bYV!\u0011\u0011TAU)%\u0011\u00181TAV\u0003\u007f\u000b)\rC\u0004w\u0003'\u0003\r!!(\u0011\r\u0005}\u0015QUAT\u001b\t\t\tKC\u0002\u0002$v\n!\u0002Z1uCN$(/Z1n\u0013\rI\u0018\u0011\u0015\t\u0004w\u0006%FAB?\u0002\u0014\n\u0007a\u0010\u0003\u0005\u0002\u001c\u0005M\u0005\u0019AA\u000fQ\u0011\tY+a,\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005e\u0016!\u00026bm\u0006D\u0018\u0002BA_\u0003g\u0013\u0001BT;mY\u0006\u0014G.\u001a\u0005\t\u0003\u0003\f\u0019\n1\u0001\u0002l\u0005Aa/[3x!\u0006$\b\u000e\u000b\u0003\u0002@\u0006=\u0006\u0002CA&\u0003'\u0003\r!!\u0014\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\u0006aAo\u001c#bi\u0006\u001cFO]3b[R!\u00111FAg\u0011\u0019Y\u0011q\u0019a\u0001e\"9\u0011\u0011\u001a\u0001\u0005B\u0005EW\u0003BAj\u00033$b!!6\u0002\\\u0006u\u0007\u0003B\u001ey\u0003/\u00042a_Am\t\u0019i\u0018q\u001ab\u0001}\"11\"a4A\u0002ID\u0001\"a8\u0002P\u0002\u0007\u0011\u0011]\u0001\fi\u0006\u0014x-\u001a;DY\u0006\u001c8\u000f\u0005\u0004\u0002n\u0005\r\u0018q[\u0005\u0005\u0003K\f9HA\u0003DY\u0006\u001c8\u000fC\u0004\u0002J\u0002!\t%!;\u0016\t\u0005-\u0018\u0011\u001f\u000b\u0007\u0003[\f\u00190!>\u0011\tmB\u0018q\u001e\t\u0004w\u0006EHAB?\u0002h\n\u0007a\u0010\u0003\u0004\f\u0003O\u0004\rA\u001d\u0005\t\u0003o\f9\u000f1\u0001\u0002z\u0006qA/\u0019:hKR$\u0015\r^1UsB,\u0007\u0007BA~\u0005\u000f\u0001b!!@\u0003\u0002\t\u0015QBAA\u0000\u0015\r\t\u0019DC\u0005\u0005\u0005\u0007\tyP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKB\u00191Pa\u0002\u0005\u0017\t%\u0011Q_A\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012\n\u0004b\u0002B\u0007\u0001\u0011\u0005#qB\u0001\u0012i>\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lG\u0003BA\u0016\u0005#Aaa\u0003B\u0006\u0001\u0004\u0011\bb\u0002B\u0007\u0001\u0011\u0005#Q\u0003\u000b\u0007\u0003W\u00119B!\u0007\t\r-\u0011\u0019\u00021\u0001s\u0011!\u0011YBa\u0005A\u0002\u0005u\u0011\u0001\u0004;be\u001e,GoU2iK6\f\u0007b\u0002B\u0007\u0001\u0011\u0005#q\u0004\u000b\t\u0003W\u0011\tCa\t\u0003&!11B!\bA\u0002ID\u0001Ba\u0007\u0003\u001e\u0001\u0007\u0011Q\u0004\u0005\t\u0003\u0017\u0012i\u00021\u0001\u0002N!9!\u0011\u0006\u0001\u0005\n\t-\u0012\u0001\u0005;p'R\u0014X-Y7J]R,'O\\1m+\u0011\u0011iCa\r\u0015\u0011\t=\"Q\u0007B\u001c\u0005\u0013\u0002Ba\u000f=\u00032A\u00191Pa\r\u0005\ru\u00149C1\u0001\u007f\u0011\u0019Y!q\u0005a\u0001e\"A!\u0011\bB\u0014\u0001\u0004\u0011Y$A\ftG\",W.\u0019+sC:\u001cH.\u0019;j_:\u0014Vm];miB!!Q\bB\"\u001d\r\u0001#qH\u0005\u0004\u0005\u0003\n\u0013\u0001G#yi\u0016\u0014h.\u00197TG\",W.\u0019+sC:\u001cH.\u0019;pe&!!Q\tB$\u00051yU\u000f\u001e9viJ+7/\u001e7u\u0015\r\u0011\t%\t\u0005\t\u0003\u0017\u00129\u00031\u0001\u0002N!\"!\u0011JAX\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005\u001f*BA!\u0015\u0003XQ1!1\u000bB-\u00057\u0002Ba\u000f=\u0003VA\u00191Pa\u0016\u0005\ru\u0014iE1\u0001\u007f\u0011\u0019Y!Q\na\u0001e\"A!Q\fB'\u0001\u0004\u0011y&A\bn_\u0012Lg-_(qKJ\fG/[8o!\u0011\u0011\tGa\u001a\u000e\u0005\t\r$b\u0001B3\u0015\u0005Qq\u000e]3sCRLwN\\:\n\t\t%$1\r\u0002\u0010\u001b>$\u0017NZ=Pa\u0016\u0014\u0018\r^5p]\"1q\u000e\u0001C!\u0005[*BAa\u001c\u0003xQ)!O!\u001d\u0003z!9aOa\u001bA\u0002\tM\u0004\u0003B\u001ey\u0005k\u00022a\u001fB<\t\u0019i(1\u000eb\u0001}\"A!1\u0010B6\u0001\u0004\u0011i(\u0001\u0004gS\u0016dGm\u001d\t\u0006%\n}$1Q\u0005\u0004\u0005\u0003\u001b&A\u0003\u001fsKB,\u0017\r^3e}A!!Q\u0011BF\u001b\t\u00119IC\u0002\u0003\n*\t1\"\u001a=qe\u0016\u001c8/[8og&!!Q\u0012BD\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0005#\u0003A\u0011\tBJ\u0003I\u0011XmZ5ti\u0016\u0014H)\u0019;b'R\u0014X-Y7\u0016\t\tU%\u0011\u0015\u000b\u0007\u0003C\u00129Ja'\t\u0011\te%q\u0012a\u0001\u0003W\nAA\\1nK\"9aOa$A\u0002\tu\u0005\u0003B\u001ey\u0005?\u00032a\u001fBQ\t\u0019i(q\u0012b\u0001}\"9!\u0011\u0013\u0001\u0005B\t\u0015V\u0003\u0002BT\u0005c#\u0002\"!\u0019\u0003*\n-&1\u0017\u0005\t\u00053\u0013\u0019\u000b1\u0001\u0002l!9aOa)A\u0002\t5\u0006\u0003B\u001ey\u0005_\u00032a\u001fBY\t\u0019i(1\u0015b\u0001}\"A!1\u0010BR\u0001\u0004\u0011i\bC\u0004\u00038\u0002!\tE!/\u0002\u001dQ|\u0017\t\u001d9f]\u0012\u001cFO]3b[V!!1\u0018Bb)\u0011\u0011iLa7\u0015\t\t}&Q\u0019\t\u0005wa\u0014\t\rE\u0002|\u0005\u0007$a! B[\u0005\u0004q\bB\u0003Bd\u0005k\u000b\t\u0011q\u0001\u0003J\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\t-'q\u001bBa\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017\u0001\u0003;za\u0016LgNZ8\u000b\t\tM'Q[\u0001\u0007G>lWn\u001c8\u000b\u0005%a\u0011\u0002\u0002Bm\u0005\u001b\u0014q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\u0007\u0017\tU\u0006\u0019\u0001:\t\u000f\t}\u0007\u0001\"\u0011\u0003b\u0006yAo\u001c*fiJ\f7\r^*ue\u0016\fW.\u0006\u0003\u0003d\nEH\u0003\u0002Bs\u0005s$BAa:\u0003tB!1\b\u001fBu!\u0019\u0011&1^)\u0003p&\u0019!Q^*\u0003\rQ+\b\u000f\\33!\rY(\u0011\u001f\u0003\u0007{\nu'\u0019\u0001@\t\u0015\tU(Q\\A\u0001\u0002\b\u001190\u0001\u0006fm&$WM\\2fII\u0002bAa3\u0003X\n=\bBB\u0006\u0003^\u0002\u0007!\u000fC\u0004\u0003~\u0002!\tEa@\u0002!I,w-[:uKJ4UO\\2uS>tW\u0003BB\u0001\u0007\u001b!baa\u0001\u0004\u0010\rEA\u0003BA1\u0007\u000bA!ba\u0002\u0003|\u0006\u0005\t9AB\u0005\u0003))g/\u001b3f]\u000e,Ge\r\t\u0007\u0005\u0017\u00149na\u0003\u0011\u0007m\u001ci\u0001\u0002\u0004~\u0005w\u0014\rA \u0005\t\u00053\u0013Y\u00101\u0001\u0002l!A11\u0003B~\u0001\u0004\u0019)\"\u0001\u0002uMB11qCB\u000f\u0007\u0017i!a!\u0007\u000b\u0007\rm!\"A\u0005gk:\u001cG/[8og&!1qDB\r\u00055!\u0016M\u00197f\rVt7\r^5p]\"9!Q \u0001\u0005B\r\rRCBB\u0013\u0007c\u0019Y\u0004\u0006\u0004\u0004(\r}2\u0011\t\u000b\u0007\u0003C\u001aIca\r\t\u0015\r-2\u0011EA\u0001\u0002\b\u0019i#\u0001\u0006fm&$WM\\2fIQ\u0002bAa3\u0003X\u000e=\u0002cA>\u00042\u00111Qp!\tC\u0002yD!b!\u000e\u0004\"\u0005\u0005\t9AB\u001c\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0005\u0017\u00149n!\u000f\u0011\u0007m\u001cY\u0004B\u0004\u0004>\r\u0005\"\u0019\u0001@\u0003\u0007\u0005\u001b5\t\u0003\u0005\u0003\u001a\u000e\u0005\u0002\u0019AA6\u0011!\u0019\u0019e!\tA\u0002\r\u0015\u0013!\u00014\u0011\u0011\r]1qIB\u0018\u0007sIAa!\u0013\u0004\u001a\t\t\u0012iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\t\u000f\tu\b\u0001\"\u0011\u0004NU11qJB.\u0007K\"ba!\u0015\u0004h\r%DCBA1\u0007'\u001ai\u0006\u0003\u0006\u0004V\r-\u0013\u0011!a\u0002\u0007/\n!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\u0011YMa6\u0004ZA\u00191pa\u0017\u0005\ru\u001cYE1\u0001\u007f\u0011)\u0019yfa\u0013\u0002\u0002\u0003\u000f1\u0011M\u0001\u000bKZLG-\u001a8dK\u0012:\u0004C\u0002Bf\u0005/\u001c\u0019\u0007E\u0002|\u0007K\"qa!\u0010\u0004L\t\u0007a\u0010\u0003\u0005\u0003\u001a\u000e-\u0003\u0019AA6\u0011!\u0019\u0019ea\u0013A\u0002\r-\u0004\u0003CB\f\u0007[\u001aIfa\u0019\n\t\r=4\u0011\u0004\u0002\u0017)\u0006\u0014G.Z!hOJ,w-\u0019;f\rVt7\r^5p]\"911\u000f\u0001\u0005B\rU\u0014aB2p]:,7\r\u001e\u000b\u0005\u0007o\u001a\u0019\t\u0005\u0003\u0004z\r}TBAB>\u0015\r\u0019iHC\u0001\fI\u0016\u001c8M]5qi>\u00148/\u0003\u0003\u0004\u0002\u000em$!F*ue\u0016\fW\u000eV1cY\u0016$Um]2sSB$xN\u001d\u0005\t\u0007\u000b\u001b\t\b1\u0001\u0004\b\u0006\u00192m\u001c8oK\u000e$xN\u001d#fg\u000e\u0014\u0018\u000e\u001d;peB!1\u0011PBE\u0013\u0011\u0019Yia\u001f\u0003'\r{gN\\3di>\u0014H)Z:de&\u0004Ho\u001c:\t\u000f\r=\u0005\u0001\"\u0015\u0004\u0012\u0006\u0019b/\u00197jI\u0006$X\rV1cY\u0016\u001cv.\u001e:dKR!\u0011\u0011MBJ\u0011!\u0019)j!$A\u0002\r]\u0015a\u0003;bE2,7k\\;sG\u0016\u0004Da!'\u0004(B111TBQ\u0007Kk!a!(\u000b\u0007\r}%\"A\u0004t_V\u00148-Z:\n\t\r\r6Q\u0014\u0002\f)\u0006\u0014G.Z*pkJ\u001cW\rE\u0002|\u0007O#1b!+\u0004\u0014\u0006\u0005\t\u0011!B\u0001}\n\u0019q\f\n\u001a\t\u000f\r5\u0006\u0001\"\u0003\u00040\u0006\tr-\u001a;Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0016\t\rE6\u0011\u0019\u000b\u0007\u0007g\u001b\u0019m!2\u0011\r\rU61XB`\u001b\t\u00199L\u0003\u0003\u0004:\nU\u0017a\u00013bO&!1QXB\\\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042a_Ba\t\u0019i81\u0016b\u0001}\"11ba+A\u0002ID\u0001ba2\u0004,\u0002\u00071\u0011Z\u0001\u0010iJ\fgn\u001d4pe6\fG/[8ogB111ZBi\u0007+l!a!4\u000b\u0007\r=G,\u0001\u0003vi&d\u0017\u0002BBj\u0007\u001b\u0014A\u0001T5tiB\"1q[Bn!\u0019\u0019)la/\u0004ZB\u00191pa7\u0005\u0017\ru7QYA\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012\u001a\u0004bBBq\u0001\u0011%11]\u0001\u0011CN\fV/\u001a:z\u001fB,'/\u0019;j_:,Ba!:\u0004pR11q]By\u0007k\u0004bA!\u0019\u0004j\u000e5\u0018\u0002BBv\u0005G\u0012QdU2bY\u0006$\u0015\r^1TiJ,\u0017-\\)vKJLx\n]3sCRLwN\u001c\t\u0004w\u000e=HAB?\u0004`\n\u0007a\u0010C\u0004w\u0007?\u0004\raa=\u0011\tmB8Q\u001e\u0005\t\u0005w\u001ay\u000e1\u0001\u0004xB)!k!?\u0004~&\u001911`*\u0003\r=\u0003H/[8o!\u0019\u0019Ym!5\u0003\u0004\"9A\u0011\u0001\u0001\u0005R\u0011\r\u0011!F9vC2Lg-_)vKJLx\n]3sCRLwN\u001c\u000b\u0007\t\u000b!Y\u0001\"\u0006\u0011\t\t\u0005DqA\u0005\u0005\t\u0013\u0011\u0019G\u0001\bRk\u0016\u0014\u0018p\u00149fe\u0006$\u0018n\u001c8\t\u0011\u001151q a\u0001\t\u001f\t!\"\u001b3f]RLg-[3s!\r\u0001C\u0011C\u0005\u0004\t'\t#\u0001E(cU\u0016\u001cG/\u00133f]RLg-[3s\u0011!!9ba@A\u0002\u0011\u0015\u0011AD9vKJLx\n]3sCRLwN\u001c\u0005\b\u00037\u0002A\u0011\tC\u000e+\u0011!i\u0002b\n\u0015\u0011\u0005\u0005Dq\u0004C\u0011\tSA\u0001\"!\u001b\u0005\u001a\u0001\u0007\u00111\u000e\u0005\bm\u0012e\u0001\u0019\u0001C\u0012!\u0011Y\u0004\u0010\"\n\u0011\u0007m$9\u0003\u0002\u0004~\t3\u0011\rA \u0005\t\u0005w\"I\u00021\u0001\u0003~!\u001a\u0001\u0001\"\f\u0011\t\u0011=B1G\u0007\u0003\tcQ1!!.\r\u0013\u0011!)\u0004\"\r\u0003\u0011%sG/\u001a:oC2<q\u0001\"\u000f\u0003\u0011\u0003!Y$\u0001\u000eTiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u00136\u0004H\u000eE\u0002e\t{1a!\u0001\u0002\t\u0002\u0011}2\u0003\u0002C\u001f\t\u0003\u00022A\u0015C\"\u0013\r!)e\u0015\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005$i\u0004\"\u0001\u0005JQ\u0011A1\b\u0005\t\t\u001b\"i\u0004\"\u0001\u0005P\u000511M]3bi\u0016$ra\u0019C)\t+\"y\u0006C\u0004\u0005T\u0011-\u0003\u0019\u0001\u001e\u0002)\u0015DXmY;uS>tWI\u001c<je>tW.\u001a8u\u0011!!9\u0006b\u0013A\u0002\u0011e\u0013\u0001C:fiRLgnZ:\u0011\u0007U\"Y&C\u0002\u0005^!\u00111#\u00128wSJ|g.\\3oiN+G\u000f^5oONDq\u0001\"\u0019\u0005L\u0001\u0007A'A\u0006uC\ndWmQ8oM&<\u0007\u0002\u0003C3\t{!I\u0001b\u001a\u0002\u001d1|wn[;q\u000bb,7-\u001e;peR)A\n\"\u001b\u0005t!AA1\u000eC2\u0001\u0004!i'\u0001\nfq\u0016\u001cW\u000f^8s!J|\u0007/\u001a:uS\u0016\u001c\b\u0003CBf\t_\nY'a\u001b\n\t\u0011E4Q\u001a\u0002\u0004\u001b\u0006\u0004\bb\u0002C*\tG\u0002\rA\u000f")
public class StreamTableEnvironmentImpl
extends TableEnvironmentImpl
implements StreamTableEnvironment {
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    public final StreamExecutionEnvironment org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment;
    private final Planner planner;

    public static StreamTableEnvironmentImpl create(StreamExecutionEnvironment streamExecutionEnvironment, EnvironmentSettings environmentSettings, TableConfig tableConfig) {
        return StreamTableEnvironmentImpl$.MODULE$.create(streamExecutionEnvironment, environmentSettings, tableConfig);
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.insertOnly());
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.insertOnly());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, changelogMode);
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), null, path, ChangelogMode.insertOnly()));
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), schema, path, ChangelogMode.insertOnly()));
    }

    private <T> Table fromStreamInternal(DataStream<T> dataStream, @Nullable Schema schema, @Nullable String viewPath, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        UnresolvedIdentifier unresolvedIdentifier = viewPath == null ? UnresolvedIdentifier.of(new StringBuilder().append((Object)"Unregistered_DataStream_Source_").append((Object)BoxesRunTime.boxToInteger((int)dataStream.getId())).toString()) : this.getParser().parseIdentifier(viewPath);
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ExternalSchemaTranslator.InputResult schemaTranslationResult = ExternalSchemaTranslator.fromExternal(catalogManager.getDataTypeFactory(), dataStream.getType(), schema);
        ResolvedSchema resolvedSchema = schemaTranslationResult.getSchema().resolve(schemaResolver);
        ScalaExternalQueryOperation<T> scanOperation = new ScalaExternalQueryOperation<T>(objectIdentifier, dataStream, schemaTranslationResult.getPhysicalDataType(), schemaTranslationResult.isTopLevelRecord(), changelogMode, resolvedSchema);
        List<String> projections = schemaTranslationResult.getProjections();
        if (projections == null) {
            return this.createTable(scanOperation);
        }
        QueryOperation projectOperation = operationTreeBuilder.project(Arrays.asList((Object[])new Expression[]{package$.MODULE$.array2ArrayConstructor(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UnresolvedReferenceExpression apply(String x$1) {
                return ApiExpressionUtils.unresolvedRef(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnresolvedReferenceExpression.class)))}), scanOperation);
        return this.createTable(projectOperation);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toDataStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        DataType sourceType = table.getResolvedSchema().toSourceRowDataType();
        return this.toDataStream(table, sourceType);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, Class<T> targetClass) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetClass, (String)"Target class must not be null.");
        Class<T> clazz = targetClass;
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return this.toDataStream(table);
        }
        return this.toDataStream(table, DataTypes.of(targetClass));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, AbstractDataType<?> targetDataType) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetDataType, (String)"Target data type must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal(this.catalogManager.getDataTypeFactory(), table.getResolvedSchema(), targetDataType);
        return this.toStreamInternal(table, schemaTranslationResult, ChangelogMode.insertOnly());
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal(table.getResolvedSchema(), null);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal(table.getResolvedSchema(), targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal(table.getResolvedSchema(), targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, changelogMode);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, ExternalSchemaTranslator.OutputResult schemaTranslationResult, @Nullable ChangelogMode changelogMode) {
        QueryOperation queryOperation;
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        Optional<List<String>> optionalProjections = schemaTranslationResult.getProjections();
        if (optionalProjections.isPresent()) {
            List<String> projections = optionalProjections.get();
            queryOperation = operationTreeBuilder.project((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final UnresolvedReferenceExpression apply(String x$1) {
                    return ApiExpressionUtils.unresolvedRef(x$1);
                }
            }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Expression apply(UnresolvedReferenceExpression x$1) {
                    return x$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).asJava(), table.getQueryOperation());
        } else {
            queryOperation = table.getQueryOperation();
        }
        QueryOperation projectOperation = queryOperation;
        ResolvedSchema resolvedSchema = schemaResolver.resolve(schemaTranslationResult.getSchema());
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(new StringBuilder().append((Object)"Unregistered_DataStream_Sink_").append((Object)BoxesRunTime.boxToInteger((int)ExternalModifyOperation.getUniqueId())).toString());
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ExternalModifyOperation modifyOperation = new ExternalModifyOperation(objectIdentifier, projectOperation, resolvedSchema, changelogMode, schemaTranslationResult.getPhysicalDataType().orElse(resolvedSchema.toPhysicalRowDataType()));
        return this.toStreamInternal(table, modifyOperation);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, ModifyOperation modifyOperation) {
        List<Transformation<?>> transformations = this.planner.translate(Collections.singletonList(modifyOperation));
        Transformation<T> streamTransformation = this.getTransformation(table, transformations);
        this.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getWrappedStreamExecutionEnvironment().addOperator(streamTransformation);
        return new org.apache.flink.streaming.api.scala.DataStream(new DataStream(this.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getWrappedStreamExecutionEnvironment(), streamTransformation));
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        ScalaDataStreamQueryOperation<T> queryOperation = this.asQueryOperation(dataStream, (Option<List<Expression>>)new Some(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields.toList()).asJava()));
        return this.createTable(queryOperation);
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        this.registerTable(name, this.fromDataStream(dataStream));
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.registerTable(name, this.fromDataStream(dataStream, fields));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toAppendStream(Table table, TypeInformation<T> evidence$1) {
        TypeInformation<T> returnType = evidence$1;
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(returnType), OutputConversionModifyOperation.UpdateMode.APPEND);
        return this.toStreamInternal(table, modifyOperation);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<Tuple2<Object, T>> toRetractStream(Table table, TypeInformation<T> evidence$2) {
        CaseClassTypeInfo returnType = new CaseClassTypeInfo<Tuple2<Object, T>>(this, evidence$2){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, T>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, T>> unused = new ScalaCaseClassSerializer<Tuple2<Object, T>>(this, fieldSerializers){

                    public Tuple2<Object, T> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[0])), fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        };
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(returnType), OutputConversionModifyOperation.UpdateMode.RETRACT);
        return this.toStreamInternal(table, modifyOperation);
    }

    @Override
    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tf, (TypeInformation)Predef$.MODULE$.implicitly(evidence$3));
        this.functionCatalog.registerTempSystemTableFunction(name, tf, typeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$4, TypeInformation<ACC> evidence$5) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$4));
        TypeInformation<ACC> accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$5));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, TableAggregateFunction<T, ACC> f, TypeInformation<T> evidence$6, TypeInformation<ACC> evidence$7) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$6));
        TypeInformation<ACC> accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$7));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public StreamTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return (StreamTableDescriptor)super.connect(connectorDescriptor);
    }

    @Override
    public void validateTableSource(TableSource<?> tableSource) {
        super.validateTableSource(tableSource);
        if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
            TimeCharacteristic timeCharacteristic = this.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getStreamTimeCharacteristic();
            TimeCharacteristic timeCharacteristic2 = TimeCharacteristic.EventTime;
            if (timeCharacteristic == null ? timeCharacteristic2 != null : !timeCharacteristic.equals(timeCharacteristic2)) {
                throw new TableException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s}", this.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getStreamTimeCharacteristic()));
            }
        }
    }

    private <T> Transformation<T> getTransformation(Table table, List<Transformation<?>> transformations) {
        if (transformations.size() != 1) {
            throw new TableException(String.format("Expected a single transformation for query: %s\n Got: %s", table.getQueryOperation().asSummaryString(), transformations));
        }
        return transformations.get(0);
    }

    private <T> ScalaDataStreamQueryOperation<T> asQueryOperation(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Option<List<Expression>> fields) {
        TypeInformation streamType = dataStream.javaStream().getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1)new Serializable(this, streamType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamTableEnvironmentImpl $outer;
            private final TypeInformation streamType$1;

            /*
             * WARNING - void declaration
             */
            public final FieldInfoUtils.TypeInfoSchema apply(List<Expression> f) {
                void var2_2;
                FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo(this.streamType$1, (Expression[])f.toArray((Object[])new Expression[0]));
                if (fieldsInfo.isRowtimeDefined() && this.$outer.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                    throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", this.$outer.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment.getStreamTimeCharacteristic()));
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.streamType$1 = streamType$1;
            }
        }).getOrElse((Function0)new Serializable(this, streamType){
            public static final long serialVersionUID = 0L;
            private final TypeInformation streamType$1;

            public final FieldInfoUtils.TypeInfoSchema apply() {
                return FieldInfoUtils.getFieldsInfo(this.streamType$1);
            }
            {
                this.streamType$1 = streamType$1;
            }
        });
        return new ScalaDataStreamQueryOperation(dataStream.javaStream(), typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema());
    }

    @Override
    public QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation;
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation2 = queryOperation;
        if (scalaDataStreamQueryOperation2 instanceof ScalaDataStreamQueryOperation) {
            ScalaDataStreamQueryOperation scalaDataStreamQueryOperation3 = scalaDataStreamQueryOperation2;
            scalaDataStreamQueryOperation = new ScalaDataStreamQueryOperation(identifier, scalaDataStreamQueryOperation3.getDataStream(), scalaDataStreamQueryOperation3.getFieldIndices(), scalaDataStreamQueryOperation3.getResolvedSchema());
        } else {
            scalaDataStreamQueryOperation = queryOperation;
        }
        return scalaDataStreamQueryOperation;
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.createTemporaryView(path, this.fromDataStream(dataStream, fields));
    }

    public StreamTableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog, TableConfig config, StreamExecutionEnvironment scalaExecutionEnvironment, Planner planner, Executor executor, boolean isStreaming, ClassLoader userClassLoader) {
        this.catalogManager = catalogManager;
        this.functionCatalog = functionCatalog;
        this.org$apache$flink$table$api$bridge$scala$internal$StreamTableEnvironmentImpl$$scalaExecutionEnvironment = scalaExecutionEnvironment;
        this.planner = planner;
        super(catalogManager, moduleManager, config, executor, functionCatalog, planner, isStreaming, userClassLoader);
    }
}

