/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class DataTypes {
    public static UnresolvedDataType of(Class<?> unresolvedClass) {
        Preconditions.checkNotNull(unresolvedClass, (String)"Unresolved class name must not be null.");
        return new UnresolvedDataType(() -> String.format("'%s'", unresolvedClass.getName()), factory -> factory.createDataType(unresolvedClass));
    }

    public static UnresolvedDataType of(String unresolvedName) {
        Preconditions.checkNotNull((Object)unresolvedName, (String)"Unresolved name must not be null.");
        return new UnresolvedDataType(() -> unresolvedName, factory -> factory.createDataType(unresolvedName));
    }

    public static UnresolvedDataType of(TypeInformation<?> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
        return new UnresolvedDataType(() -> String.format("'%s'", typeInfo.toString()), factory -> factory.createDataType(typeInfo));
    }

    public static DataType CHAR(int n) {
        return new AtomicDataType(new CharType(n));
    }

    public static DataType VARCHAR(int n) {
        return new AtomicDataType(new VarCharType(n));
    }

    public static DataType STRING() {
        return DataTypes.VARCHAR(Integer.MAX_VALUE);
    }

    public static DataType BOOLEAN() {
        return new AtomicDataType(new BooleanType());
    }

    public static DataType BINARY(int n) {
        return new AtomicDataType(new BinaryType(n));
    }

    public static DataType VARBINARY(int n) {
        return new AtomicDataType(new VarBinaryType(n));
    }

    public static DataType BYTES() {
        return DataTypes.VARBINARY(Integer.MAX_VALUE);
    }

    public static DataType DECIMAL(int precision, int scale) {
        return new AtomicDataType(new DecimalType(precision, scale));
    }

    public static DataType TINYINT() {
        return new AtomicDataType(new TinyIntType());
    }

    public static DataType SMALLINT() {
        return new AtomicDataType(new SmallIntType());
    }

    public static DataType INT() {
        return new AtomicDataType(new IntType());
    }

    public static DataType BIGINT() {
        return new AtomicDataType(new BigIntType());
    }

    public static DataType FLOAT() {
        return new AtomicDataType(new FloatType());
    }

    public static DataType DOUBLE() {
        return new AtomicDataType(new DoubleType());
    }

    public static DataType DATE() {
        return new AtomicDataType(new DateType());
    }

    public static DataType TIME(int precision) {
        return new AtomicDataType(new TimeType(precision));
    }

    public static DataType TIME() {
        return new AtomicDataType(new TimeType());
    }

    public static DataType TIMESTAMP(int precision) {
        return new AtomicDataType(new TimestampType(precision));
    }

    public static DataType TIMESTAMP() {
        return new AtomicDataType(new TimestampType());
    }

    public static DataType TIMESTAMP_WITH_TIME_ZONE(int precision) {
        return new AtomicDataType(new ZonedTimestampType(precision));
    }

    public static DataType TIMESTAMP_WITH_TIME_ZONE() {
        return new AtomicDataType(new ZonedTimestampType());
    }

    public static DataType TIMESTAMP_WITH_LOCAL_TIME_ZONE(int precision) {
        return new AtomicDataType(new LocalZonedTimestampType(precision));
    }

    public static DataType TIMESTAMP_LTZ(int precision) {
        return new AtomicDataType(new LocalZonedTimestampType(precision));
    }

    public static DataType TIMESTAMP_WITH_LOCAL_TIME_ZONE() {
        return new AtomicDataType(new LocalZonedTimestampType());
    }

    public static DataType TIMESTAMP_LTZ() {
        return new AtomicDataType(new LocalZonedTimestampType());
    }

    public static DataType INTERVAL(Resolution resolution) {
        Preconditions.checkNotNull((Object)resolution, (String)"Interval resolution must not be null.");
        return new AtomicDataType(Resolution.resolveInterval(resolution, null));
    }

    public static DataType INTERVAL(Resolution upperResolution, Resolution lowerResolution) {
        Preconditions.checkNotNull((Object)upperResolution, (String)"Upper interval resolution must not be null.");
        Preconditions.checkNotNull((Object)lowerResolution, (String)"Lower interval resolution must not be null.");
        return new AtomicDataType(Resolution.resolveInterval(upperResolution, lowerResolution));
    }

    public static DataType ARRAY(DataType elementDataType) {
        Preconditions.checkNotNull((Object)elementDataType, (String)"Element data type must not be null.");
        return new CollectionDataType((LogicalType)new ArrayType(elementDataType.getLogicalType()), elementDataType);
    }

    public static UnresolvedDataType ARRAY(AbstractDataType<?> elementDataType) {
        Preconditions.checkNotNull(elementDataType, (String)"Element data type must not be null.");
        return new UnresolvedDataType(() -> String.format("ARRAY<%s>", elementDataType), factory -> DataTypes.ARRAY(factory.createDataType(elementDataType)));
    }

    public static DataType MULTISET(DataType elementDataType) {
        Preconditions.checkNotNull((Object)elementDataType, (String)"Element data type must not be null.");
        return new CollectionDataType((LogicalType)new MultisetType(elementDataType.getLogicalType()), elementDataType);
    }

    public static UnresolvedDataType MULTISET(AbstractDataType<?> elementDataType) {
        Preconditions.checkNotNull(elementDataType, (String)"Element data type must not be null.");
        return new UnresolvedDataType(() -> String.format("MULTISET<%s>", elementDataType), factory -> DataTypes.MULTISET(factory.createDataType(elementDataType)));
    }

    public static DataType MAP(DataType keyDataType, DataType valueDataType) {
        Preconditions.checkNotNull((Object)keyDataType, (String)"Key data type must not be null.");
        Preconditions.checkNotNull((Object)valueDataType, (String)"Value data type must not be null.");
        return new KeyValueDataType(new MapType(keyDataType.getLogicalType(), valueDataType.getLogicalType()), keyDataType, valueDataType);
    }

    public static UnresolvedDataType MAP(AbstractDataType<?> keyDataType, AbstractDataType<?> valueDataType) {
        Preconditions.checkNotNull(keyDataType, (String)"Key data type must not be null.");
        Preconditions.checkNotNull(valueDataType, (String)"Value data type must not be null.");
        return new UnresolvedDataType(() -> String.format("MAP<%s, %s>", keyDataType, valueDataType), factory -> DataTypes.MAP(factory.createDataType(keyDataType), factory.createDataType(valueDataType)));
    }

    public static DataType ROW(Field ... fields) {
        List<RowType.RowField> logicalFields = Stream.of(fields).map(f -> (Field)Preconditions.checkNotNull((Object)f, (String)"Field definition must not be null.")).map(f -> new RowType.RowField(f.name, ((Field)f).dataType.getLogicalType(), f.description)).collect(Collectors.toList());
        List<DataType> fieldDataTypes = Stream.of(fields).map(f -> ((Field)f).dataType).collect(Collectors.toList());
        return new FieldsDataType((LogicalType)new RowType(logicalFields), fieldDataTypes);
    }

    public static DataType ROW(DataType ... fieldDataTypes) {
        return DataTypes.ROW((Field[])IntStream.range(0, fieldDataTypes.length).mapToObj(idx -> DataTypes.FIELD("f" + idx, fieldDataTypes[idx])).toArray(Field[]::new));
    }

    public static DataType ROW() {
        return DataTypes.ROW(new Field[0]);
    }

    public static UnresolvedDataType ROW(AbstractField ... fields) {
        Stream.of(fields).forEach(f -> {
            AbstractField cfr_ignored_0 = (AbstractField)Preconditions.checkNotNull((Object)f, (String)"Field definition must not be null.");
        });
        return new UnresolvedDataType(() -> String.format("ROW<%s>", Stream.of(fields).map(Object::toString).collect(Collectors.joining(", "))), factory -> {
            Field[] fieldsArray = (Field[])Stream.of(fields).map(f -> new Field(f.name, factory.createDataType(f.getAbstractDataType()), f.description)).toArray(Field[]::new);
            return DataTypes.ROW(fieldsArray);
        });
    }

    public static UnresolvedDataType ROW(AbstractDataType<?> ... fieldDataTypes) {
        return DataTypes.ROW((AbstractField[])IntStream.range(0, fieldDataTypes.length).mapToObj(idx -> DataTypes.FIELD("f" + idx, fieldDataTypes[idx])).toArray(AbstractField[]::new));
    }

    public static DataType NULL() {
        return new AtomicDataType(new NullType());
    }

    public static <T> DataType RAW(Class<T> clazz, TypeSerializer<T> serializer) {
        return new AtomicDataType(new RawType<T>(clazz, serializer));
    }

    public static <T> UnresolvedDataType RAW(Class<T> clazz) {
        return new UnresolvedDataType(() -> String.format("RAW('%s', '%s')", clazz.getName(), "?"), factory -> factory.createRawDataType(clazz));
    }

    public static <T> UnresolvedDataType RAW(TypeInformation<T> typeInformation) {
        return new UnresolvedDataType(() -> String.format("RAW('%s', '%s')", typeInformation.getTypeClass().getName(), "?"), factory -> factory.createRawDataType(typeInformation));
    }

    public static <T> DataType STRUCTURED(Class<T> implementationClass, Field ... fields) {
        ExtractionUtils.validateStructuredClass(implementationClass);
        StructuredType.Builder builder = StructuredType.newBuilder(implementationClass);
        List<StructuredType.StructuredAttribute> attributes = Stream.of(fields).map(f -> new StructuredType.StructuredAttribute(f.getName(), f.getDataType().getLogicalType(), f.getDescription().orElse(null))).collect(Collectors.toList());
        builder.attributes(attributes);
        builder.setFinal(true);
        builder.setInstantiable(true);
        List<DataType> fieldDataTypes = Stream.of(fields).map(Field::getDataType).collect(Collectors.toList());
        return new FieldsDataType(builder.build(), implementationClass, fieldDataTypes);
    }

    public static Resolution SECOND() {
        return new Resolution(Resolution.IntervalUnit.SECOND, 6);
    }

    public static Resolution SECOND(int precision) {
        return new Resolution(Resolution.IntervalUnit.SECOND, precision);
    }

    public static Resolution MINUTE() {
        return new Resolution(Resolution.IntervalUnit.MINUTE);
    }

    public static Resolution HOUR() {
        return new Resolution(Resolution.IntervalUnit.HOUR);
    }

    public static Resolution DAY(int precision) {
        return new Resolution(Resolution.IntervalUnit.DAY, precision);
    }

    public static Resolution DAY() {
        return new Resolution(Resolution.IntervalUnit.DAY, 2);
    }

    public static Resolution MONTH() {
        return new Resolution(Resolution.IntervalUnit.MONTH);
    }

    public static Resolution YEAR(int precision) {
        return new Resolution(Resolution.IntervalUnit.YEAR, precision);
    }

    public static Resolution YEAR() {
        return new Resolution(Resolution.IntervalUnit.YEAR, 2);
    }

    public static Field FIELD(String name, DataType dataType2) {
        return new Field((String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null."), (DataType)Preconditions.checkNotNull((Object)dataType2, (String)"Field data type must not be null."), null);
    }

    public static Field FIELD(String name, DataType dataType2, String description) {
        return new Field((String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null."), (DataType)Preconditions.checkNotNull((Object)dataType2, (String)"Field data type must not be null."), (String)Preconditions.checkNotNull((Object)description, (String)"Field description must not be null."));
    }

    public static UnresolvedField FIELD(String name, AbstractDataType<?> fieldDataType) {
        return new UnresolvedField((String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null."), (AbstractDataType)Preconditions.checkNotNull(fieldDataType, (String)"Field data type must not be null."), null);
    }

    public static UnresolvedField FIELD(String name, AbstractDataType<?> fieldDataType, String description) {
        return new UnresolvedField((String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null."), (AbstractDataType)Preconditions.checkNotNull(fieldDataType, (String)"Field data type must not be null."), (String)Preconditions.checkNotNull((Object)description, (String)"Field description must not be null."));
    }

    private DataTypes() {
    }

    public static final class UnresolvedField
    extends AbstractField {
        private final AbstractDataType<?> dataType;

        private UnresolvedField(String name, AbstractDataType<?> dataType2, @Nullable String description) {
            super(name, description);
            this.dataType = dataType2;
        }

        @Override
        protected AbstractDataType<?> getAbstractDataType() {
            return this.dataType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnresolvedField that = (UnresolvedField)o;
            return this.dataType.equals(that.dataType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataType);
        }
    }

    public static final class Field
    extends AbstractField {
        private final DataType dataType;

        private Field(String name, DataType dataType2, @Nullable String description) {
            super(name, description);
            this.dataType = dataType2;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        @Override
        protected AbstractDataType<?> getAbstractDataType() {
            return this.dataType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Field field = (Field)o;
            return this.dataType.equals(field.dataType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataType);
        }
    }

    public static abstract class AbstractField {
        protected final String name;
        @Nullable
        protected final String description;

        private AbstractField(String name, @Nullable String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        protected abstract AbstractDataType<?> getAbstractDataType();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractField that = (AbstractField)o;
            return this.name.equals(that.name) && Objects.equals(this.description, that.description);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description);
        }

        public String toString() {
            if (this.description != null) {
                return String.format("%s %s '%s'", this.name, this.getAbstractDataType(), this.description);
            }
            return String.format("%s %s", this.name, this.getAbstractDataType());
        }
    }

    public static final class Resolution {
        private static final int EMPTY_PRECISION = -1;
        private static final Map<List<IntervalUnit>, BiFunction<Integer, Integer, LogicalType>> resolutionMapping = new HashMap<List<IntervalUnit>, BiFunction<Integer, Integer, LogicalType>>();
        private final int precision;
        private final IntervalUnit unit;

        private static void addResolutionMapping(IntervalUnit leftUnit, IntervalUnit rightUnit, BiFunction<Integer, Integer, LogicalType> typeProvider) {
            resolutionMapping.put(Arrays.asList(leftUnit, rightUnit), typeProvider);
        }

        private static LogicalType resolveInterval(Resolution fromResolution, @Nullable Resolution toResolution) {
            IntervalUnit toBoundary = toResolution == null ? null : toResolution.unit;
            int toPrecision = toResolution == null ? -1 : toResolution.precision;
            BiFunction<Integer, Integer, LogicalType> typeProvider = resolutionMapping.get(Arrays.asList(fromResolution.unit, toBoundary));
            if (typeProvider == null) {
                throw new ValidationException(String.format("Unsupported interval definition '%s TO %s'. Please check the documentation for supported combinations for year-month and day-time intervals.", new Object[]{fromResolution.unit, toBoundary}));
            }
            return typeProvider.apply(fromResolution.precision, toPrecision);
        }

        private Resolution(IntervalUnit unit, int precision) {
            this.unit = unit;
            this.precision = precision;
        }

        private Resolution(IntervalUnit unit) {
            this(unit, -1);
        }

        public String toString() {
            if (this.precision != -1) {
                return String.format("%s(%d)", new Object[]{this.unit, this.precision});
            }
            return this.unit.toString();
        }

        static {
            Resolution.addResolutionMapping(IntervalUnit.YEAR, null, (p1, p2) -> new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR, (int)p1));
            Resolution.addResolutionMapping(IntervalUnit.MONTH, null, (p1, p2) -> new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH));
            Resolution.addResolutionMapping(IntervalUnit.YEAR, IntervalUnit.MONTH, (p1, p2) -> new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, (int)p1));
            Resolution.addResolutionMapping(IntervalUnit.DAY, null, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY, (int)p1, 6));
            Resolution.addResolutionMapping(IntervalUnit.DAY, IntervalUnit.HOUR, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, (int)p1, 6));
            Resolution.addResolutionMapping(IntervalUnit.DAY, IntervalUnit.MINUTE, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE, (int)p1, 6));
            Resolution.addResolutionMapping(IntervalUnit.DAY, IntervalUnit.SECOND, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, (int)p1, (int)p2));
            Resolution.addResolutionMapping(IntervalUnit.HOUR, null, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR));
            Resolution.addResolutionMapping(IntervalUnit.HOUR, IntervalUnit.MINUTE, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_MINUTE));
            Resolution.addResolutionMapping(IntervalUnit.HOUR, IntervalUnit.SECOND, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, 2, (int)p2));
            Resolution.addResolutionMapping(IntervalUnit.MINUTE, null, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE));
            Resolution.addResolutionMapping(IntervalUnit.MINUTE, IntervalUnit.SECOND, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND, 2, (int)p2));
            Resolution.addResolutionMapping(IntervalUnit.SECOND, null, (p1, p2) -> new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND, 2, (int)p1));
        }

        private static enum IntervalUnit {
            SECOND,
            MINUTE,
            HOUR,
            DAY,
            MONTH,
            YEAR;

        }
    }
}

