/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class PendingSplitsCheckpointSerializer<T extends FileSourceSplit>
implements SimpleVersionedSerializer<PendingSplitsCheckpoint<T>> {
    private static final int VERSION = 1;
    private static final int VERSION_1_MAGIC_NUMBER = -559038737;
    private final SimpleVersionedSerializer<T> splitSerializer;

    public PendingSplitsCheckpointSerializer(SimpleVersionedSerializer<T> splitSerializer) {
        this.splitSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(splitSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PendingSplitsCheckpoint<T> checkpoint) throws IOException {
        Preconditions.checkArgument((checkpoint.getClass() == PendingSplitsCheckpoint.class ? 1 : 0) != 0, (Object)"Cannot serialize subclasses of PendingSplitsCheckpoint");
        if (checkpoint.serializedFormCache != null) {
            return checkpoint.serializedFormCache;
        }
        SimpleVersionedSerializer<T> splitSerializer = this.splitSerializer;
        Collection<T> splits = checkpoint.getSplits();
        Collection<Path> processedPaths = checkpoint.getAlreadyProcessedPaths();
        ArrayList<byte[]> serializedSplits = new ArrayList<byte[]>(splits.size());
        ArrayList<byte[]> serializedPaths = new ArrayList<byte[]>(processedPaths.size());
        int totalLen = 16;
        for (FileSourceSplit split2 : splits) {
            byte[] serSplit = splitSerializer.serialize((Object)split2);
            serializedSplits.add(serSplit);
            totalLen += serSplit.length + 4;
        }
        for (Path path : processedPaths) {
            byte[] serPath = path.toString().getBytes(StandardCharsets.UTF_8);
            serializedPaths.add(serPath);
            totalLen += serPath.length + 4;
        }
        byte[] result = new byte[totalLen];
        ByteBuffer byteBuffer = ByteBuffer.wrap(result).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(-559038737);
        byteBuffer.putInt(splitSerializer.getVersion());
        byteBuffer.putInt(serializedSplits.size());
        byteBuffer.putInt(serializedPaths.size());
        for (byte[] splitBytes : serializedSplits) {
            byteBuffer.putInt(splitBytes.length);
            byteBuffer.put(splitBytes);
        }
        for (byte[] pathBytes : serializedPaths) {
            byteBuffer.putInt(pathBytes.length);
            byteBuffer.put(pathBytes);
        }
        assert (byteBuffer.remaining() == 0);
        checkpoint.serializedFormCache = result;
        return result;
    }

    public PendingSplitsCheckpoint<T> deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            return this.deserializeV1(serialized);
        }
        throw new IOException("Unknown version: " + version);
    }

    private PendingSplitsCheckpoint<T> deserializeV1(byte[] serialized) throws IOException {
        byte[] bytes;
        int remaining;
        ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        int magic = bb.getInt();
        if (magic != -559038737) {
            throw new IOException(String.format("Invalid magic number for PendingSplitsCheckpoint. Expected: %X , found %X", -559038737, magic));
        }
        int splitSerializerVersion = bb.getInt();
        int numSplits = bb.getInt();
        int numPaths = bb.getInt();
        SimpleVersionedSerializer<T> splitSerializer = this.splitSerializer;
        ArrayList<FileSourceSplit> splits = new ArrayList<FileSourceSplit>(numSplits);
        ArrayList<Path> paths = new ArrayList<Path>(numPaths);
        for (remaining = numSplits; remaining > 0; --remaining) {
            bytes = new byte[bb.getInt()];
            bb.get(bytes);
            FileSourceSplit split2 = (FileSourceSplit)splitSerializer.deserialize(splitSerializerVersion, bytes);
            splits.add(split2);
        }
        for (remaining = numPaths; remaining > 0; --remaining) {
            bytes = new byte[bb.getInt()];
            bb.get(bytes);
            Path path = new Path(new String(bytes, StandardCharsets.UTF_8));
            paths.add(path);
        }
        return PendingSplitsCheckpoint.reusingCollection(splits, paths);
    }
}

