/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.SharedBuffer;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.util.Preconditions;

class MigrationUtils {
    static void skipSerializedStates(DataInputView in) throws IOException {
        int i;
        StringSerializer nameSerializer = StringSerializer.INSTANCE;
        EnumSerializer stateTypeSerializer = new EnumSerializer(State.StateType.class);
        EnumSerializer actionSerializer = new EnumSerializer(StateTransitionAction.class);
        int noOfStates = in.readInt();
        for (i = 0; i < noOfStates; ++i) {
            nameSerializer.deserialize(in);
            stateTypeSerializer.deserialize(in);
        }
        for (i = 0; i < noOfStates; ++i) {
            String srcName = (String)nameSerializer.deserialize(in);
            int noOfTransitions = in.readInt();
            for (int j2 = 0; j2 < noOfTransitions; ++j2) {
                String src = (String)nameSerializer.deserialize(in);
                Preconditions.checkState((boolean)src.equals(srcName), (Object)("Source Edge names do not match (" + srcName + " - " + src + ")."));
                nameSerializer.deserialize(in);
                actionSerializer.deserialize(in);
                try {
                    MigrationUtils.skipCondition(in);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void skipCondition(DataInputView in) throws IOException, ClassNotFoundException {
        boolean hasCondition = in.readBoolean();
        if (hasCondition) {
            int length = in.readInt();
            byte[] serCondition = new byte[length];
            in.read(serCondition);
            ByteArrayInputStream bais = new ByteArrayInputStream(serCondition);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ois.readObject();
            ois.close();
            bais.close();
        }
    }

    static <T> Queue<ComputationState> deserializeComputationStates(SharedBuffer<T> sharedBuffer, TypeSerializer<T> eventSerializer, DataInputView source) throws IOException {
        LinkedList<ComputationState> computationStates = new LinkedList<ComputationState>();
        StringSerializer stateNameSerializer = StringSerializer.INSTANCE;
        LongSerializer timestampSerializer = LongSerializer.INSTANCE;
        DeweyNumber.DeweyNumberSerializer versionSerializer = DeweyNumber.DeweyNumberSerializer.INSTANCE;
        int computationStateNo = source.readInt();
        for (int i = 0; i < computationStateNo; ++i) {
            EventId startEventId;
            NodeId nodeId;
            String state = stateNameSerializer.deserialize(source);
            String prevState = stateNameSerializer.deserialize(source);
            long timestamp = timestampSerializer.deserialize(source);
            DeweyNumber version = versionSerializer.deserialize(source);
            long startTimestamp = timestampSerializer.deserialize(source);
            int counter = source.readInt();
            Object event = null;
            if (source.readBoolean()) {
                event = eventSerializer.deserialize(source);
            }
            if (prevState != null) {
                nodeId = sharedBuffer.getNodeId(prevState, timestamp, counter, event);
                startEventId = sharedBuffer.getStartEventId(version.getRun());
            } else {
                nodeId = null;
                startEventId = null;
            }
            computationStates.add(ComputationState.createState(state, nodeId, version, startTimestamp, startEventId));
        }
        return computationStates;
    }

    private MigrationUtils() {
    }
}

