/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.pretty;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.pretty.SqlFormatOptions;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteLogger;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.LoggerFactory;

public class SqlPrettyWriter
implements SqlWriter {
    protected static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger((String)"org.apache.calcite.sql.pretty.SqlPrettyWriter"));
    private static final Bean DEFAULT_BEAN = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(AnsiSqlDialect.DEFAULT)).getBean();
    protected static final String NL = System.getProperty("line.separator");
    private final SqlDialect dialect;
    private final StringBuilder buf;
    private final Deque<FrameImpl> listStack = new ArrayDeque<FrameImpl>();
    private ImmutableList.Builder<Integer> dynamicParameters;
    protected FrameImpl frame;
    private boolean needWhitespace;
    protected String nextWhitespace;
    private SqlWriterConfig config;
    private Bean bean;
    private int currentIndent;
    private int lineStart;

    private SqlPrettyWriter(SqlWriterConfig config, StringBuilder buf, boolean ignore) {
        this.buf = Objects.requireNonNull(buf);
        this.dialect = Objects.requireNonNull(config.dialect());
        this.config = Objects.requireNonNull(config);
        this.lineStart = 0;
        this.reset();
    }

    public SqlPrettyWriter(@Nonnull SqlWriterConfig config, @Nonnull StringBuilder buf) {
        this(config, Objects.requireNonNull(buf), false);
    }

    public SqlPrettyWriter(SqlDialect dialect, SqlWriterConfig config, StringBuilder buf) {
        this(config.withDialect(Objects.requireNonNull(dialect)), buf);
    }

    @Deprecated
    public SqlPrettyWriter(SqlDialect dialect, SqlWriterConfig config) {
        this(config.withDialect(Objects.requireNonNull(dialect)));
    }

    @Deprecated
    public SqlPrettyWriter(SqlDialect dialect, boolean alwaysUseParentheses, PrintWriter pw) {
        this(SqlPrettyWriter.config().withDialect(Objects.requireNonNull(dialect)).withAlwaysUseParentheses(alwaysUseParentheses));
    }

    @Deprecated
    public SqlPrettyWriter(SqlDialect dialect, boolean alwaysUseParentheses) {
        this(SqlPrettyWriter.config().withDialect(Objects.requireNonNull(dialect)).withAlwaysUseParentheses(alwaysUseParentheses));
    }

    @Deprecated
    public SqlPrettyWriter(SqlDialect dialect) {
        this(SqlPrettyWriter.config().withDialect(Objects.requireNonNull(dialect)));
    }

    public SqlPrettyWriter(@Nonnull SqlWriterConfig config) {
        this(config, new StringBuilder(), true);
    }

    public SqlPrettyWriter() {
        this(SqlPrettyWriter.config());
    }

    public static SqlWriterConfig config() {
        return ImmutableBeans.create(SqlWriterConfig.class).withDialect(CalciteSqlDialect.DEFAULT);
    }

    @Deprecated
    public void setCaseClausesOnNewLines(boolean caseClausesOnNewLines) {
        this.config = this.config.withCaseClausesOnNewLines(caseClausesOnNewLines);
    }

    @Deprecated
    public void setSubQueryStyle(SqlWriter.SubQueryStyle subQueryStyle) {
        this.config = this.config.withSubQueryStyle(subQueryStyle);
    }

    @Deprecated
    public void setWindowNewline(boolean windowNewline) {
        this.config = this.config.withWindowNewline(windowNewline);
    }

    @Deprecated
    public void setWindowDeclListNewline(boolean windowDeclListNewline) {
        this.config = this.config.withWindowDeclListNewline(windowDeclListNewline);
    }

    @Override
    @Deprecated
    public int getIndentation() {
        return this.config.indentation();
    }

    @Override
    @Deprecated
    public boolean isAlwaysUseParentheses() {
        return this.config.alwaysUseParentheses();
    }

    @Override
    public boolean inQuery() {
        return this.frame == null || this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY || this.frame.frameType == SqlWriter.FrameTypeEnum.WITH || this.frame.frameType == SqlWriter.FrameTypeEnum.SETOP;
    }

    @Override
    @Deprecated
    public boolean isQuoteAllIdentifiers() {
        return this.config.quoteAllIdentifiers();
    }

    @Override
    @Deprecated
    public boolean isClauseStartsLine() {
        return this.config.clauseStartsLine();
    }

    @Override
    @Deprecated
    public boolean isSelectListItemsOnSeparateLines() {
        return this.config.selectListItemsOnSeparateLines();
    }

    @Deprecated
    public boolean isWhereListItemsOnSeparateLines() {
        return this.config.whereListItemsOnSeparateLines();
    }

    @Deprecated
    public boolean isSelectListExtraIndentFlag() {
        return this.config.selectListExtraIndentFlag();
    }

    @Override
    @Deprecated
    public boolean isKeywordsLowerCase() {
        return this.config.keywordsLowerCase();
    }

    @Deprecated
    public int getLineLength() {
        return this.config.lineLength();
    }

    @Override
    public void resetSettings() {
        this.reset();
        this.config = SqlPrettyWriter.config();
    }

    @Override
    public void reset() {
        this.buf.setLength(0);
        this.lineStart = 0;
        this.dynamicParameters = null;
        this.setNeedWhitespace(false);
        this.nextWhitespace = " ";
    }

    private Bean getBean() {
        if (this.bean == null) {
            this.bean = new Bean(this);
        }
        return this.bean;
    }

    @Deprecated
    public void setIndentation(int indentation) {
        this.config = this.config.withIndentation(indentation);
    }

    public void describe(PrintWriter pw, boolean omitDefaults) {
        Bean properties = this.getBean();
        String[] propertyNames = properties.getPropertyNames();
        int count = 0;
        for (String key : propertyNames) {
            Object defaultValue;
            Object value = this.bean.get(key);
            if (Objects.equals(value, defaultValue = DEFAULT_BEAN.get(key))) continue;
            if (count++ > 0) {
                pw.print(",");
            }
            pw.print(key + "=" + value);
        }
    }

    public void setSettings(Properties properties) {
        String[] propertyNames;
        this.resetSettings();
        Bean bean = this.getBean();
        for (String propertyName : propertyNames = bean.getPropertyNames()) {
            String value = properties.getProperty(propertyName);
            if (value == null) continue;
            bean.set(propertyName, value);
        }
    }

    @Deprecated
    public void setClauseStartsLine(boolean clauseStartsLine) {
        this.config = this.config.withClauseStartsLine(clauseStartsLine);
    }

    @Deprecated
    public void setSelectListItemsOnSeparateLines(boolean b) {
        this.config = this.config.withSelectListItemsOnSeparateLines(b);
    }

    @Deprecated
    public void setSelectListExtraIndentFlag(boolean selectListExtraIndentFlag) {
        this.config = this.config.withSelectListExtraIndentFlag(selectListExtraIndentFlag);
    }

    @Deprecated
    public void setKeywordsLowerCase(boolean keywordsLowerCase) {
        this.config = this.config.withKeywordsLowerCase(keywordsLowerCase);
    }

    @Deprecated
    public void setWhereListItemsOnSeparateLines(boolean whereListItemsOnSeparateLines) {
        this.config = this.config.withWhereListItemsOnSeparateLines(whereListItemsOnSeparateLines);
    }

    @Deprecated
    public void setAlwaysUseParentheses(boolean alwaysUseParentheses) {
        this.config = this.config.withAlwaysUseParentheses(alwaysUseParentheses);
    }

    @Override
    public void newlineAndIndent() {
        this.newlineAndIndent(this.currentIndent);
    }

    public void newlineAndIndent(int indent) {
        this.buf.append(NL);
        this.lineStart = this.buf.length();
        this.indent(indent);
        this.setNeedWhitespace(false);
    }

    void indent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("negative indent " + indent);
        }
        Spaces.append(this.buf, indent);
    }

    @Deprecated
    public void setQuoteAllIdentifiers(boolean quoteAllIdentifiers) {
        this.config = this.config.withQuoteAllIdentifiers(quoteAllIdentifiers);
    }

    protected FrameImpl createListFrame(SqlWriter.FrameType frameType, String keyword, String open2, String close) {
        int chopColumn;
        SqlWriterConfig.LineFolding lineFolding;
        SqlWriter.FrameTypeEnum frameTypeEnum = frameType instanceof SqlWriter.FrameTypeEnum ? (SqlWriter.FrameTypeEnum)frameType : SqlWriter.FrameTypeEnum.OTHER;
        int indentation = this.config.indentation();
        boolean newlineAfterOpen = false;
        boolean newlineBeforeSep = false;
        boolean newlineAfterSep = false;
        boolean newlineBeforeClose = false;
        int left = this.column();
        int sepIndent = indentation;
        int extraIndent = 0;
        SqlWriterConfig.LineFolding fold = this.fold(frameTypeEnum);
        boolean newline = fold == SqlWriterConfig.LineFolding.TALL;
        switch (frameTypeEnum) {
            case SELECT: {
                extraIndent = indentation;
                newlineAfterOpen = false;
                newlineBeforeSep = this.config.clauseStartsLine();
                newlineAfterSep = false;
                sepIndent = 0;
                break;
            }
            case SETOP: {
                extraIndent = 0;
                newlineAfterOpen = false;
                newlineBeforeSep = this.config.clauseStartsLine();
                newlineAfterSep = this.config.clauseStartsLine();
                sepIndent = 0;
                break;
            }
            case SELECT_LIST: 
            case FROM_LIST: 
            case JOIN: 
            case GROUP_BY_LIST: 
            case ORDER_BY_LIST: 
            case WINDOW_DECL_LIST: 
            case VALUES: {
                if (this.config.selectListExtraIndentFlag()) {
                    extraIndent = indentation;
                }
                left = this.frame == null ? 0 : this.frame.left;
                newlineAfterOpen = this.config.clauseEndsLine() && (fold == SqlWriterConfig.LineFolding.TALL || fold == SqlWriterConfig.LineFolding.STEP);
                newlineBeforeSep = false;
                newlineAfterSep = newline;
                if (!this.config.leadingComma() || !newline) break;
                newlineBeforeSep = true;
                newlineAfterSep = false;
                sepIndent = -", ".length();
                break;
            }
            case WHERE_LIST: 
            case WINDOW: {
                extraIndent = indentation;
                newlineAfterOpen = newline && this.config.clauseEndsLine();
                newlineBeforeSep = newline;
                sepIndent = 0;
                newlineAfterSep = false;
                break;
            }
            case ORDER_BY: 
            case OFFSET: 
            case FETCH: {
                newlineAfterOpen = false;
                newlineBeforeSep = true;
                sepIndent = 0;
                newlineAfterSep = false;
                break;
            }
            case UPDATE_SET_LIST: {
                extraIndent = indentation;
                newlineAfterOpen = newline;
                newlineBeforeSep = false;
                sepIndent = 0;
                newlineAfterSep = newline;
                break;
            }
            case CASE: {
                newlineAfterOpen = newline;
                newlineBeforeSep = newline;
                newlineBeforeClose = newline;
                sepIndent = 0;
            }
        }
        if (this.config.lineFolding() == null) {
            lineFolding = SqlWriterConfig.LineFolding.WIDE;
            chopColumn = -1;
        } else {
            lineFolding = this.config.lineFolding();
            chopColumn = this.config.foldLength() > 0 && (lineFolding == SqlWriterConfig.LineFolding.CHOP || lineFolding == SqlWriterConfig.LineFolding.FOLD || lineFolding == SqlWriterConfig.LineFolding.STEP) ? left + this.config.foldLength() : -1;
        }
        switch (frameTypeEnum) {
            case SELECT: 
            case SETOP: 
            case SELECT_LIST: 
            case GROUP_BY_LIST: 
            case ORDER_BY_LIST: 
            case WINDOW_DECL_LIST: 
            case VALUES: 
            case WHERE_LIST: 
            case WINDOW: 
            case ORDER_BY: 
            case OFFSET: 
            case FETCH: 
            case UPDATE_SET_LIST: {
                return new FrameImpl(frameType, keyword, open2, close, left, extraIndent, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, false, false);
            }
            case SUB_QUERY: {
                switch (this.config.subQueryStyle()) {
                    case BLACK: {
                        open2 = Spaces.padRight("(", indentation - 1);
                        return new FrameImpl(frameType, keyword, open2, close, left, 0, chopColumn, lineFolding, false, true, indentation, false, false, false){

                            protected void _before() {
                                SqlPrettyWriter.this.newlineAndIndent();
                            }
                        };
                    }
                    case HYDE: {
                        return new FrameImpl(frameType, keyword, open2, close, left, 0, chopColumn, lineFolding, false, true, 0, false, false, false){

                            protected void _before() {
                                SqlPrettyWriter.this.nextWhitespace = NL;
                            }
                        };
                    }
                }
                throw Util.unexpected(this.config.subQueryStyle());
            }
            case FUN_CALL: {
                this.setNeedWhitespace(false);
                return new FrameImpl(frameType, keyword, open2, close, left, indentation, chopColumn, lineFolding, false, false, indentation, false, false, false);
            }
            case PARENTHESES: {
                open2 = "(";
                close = ")";
            }
            case IDENTIFIER: 
            case SIMPLE: {
                return new FrameImpl(frameType, keyword, open2, close, left, indentation, chopColumn, lineFolding, false, false, indentation, false, false, false);
            }
            case FROM_LIST: 
            case JOIN: {
                newlineBeforeSep = newline;
                sepIndent = 0;
                newlineAfterSep = false;
                final boolean newlineBeforeComma = this.config.leadingComma() && newline;
                final boolean newlineAfterComma = !this.config.leadingComma() && newline;
                return new FrameImpl(frameType, keyword, open2, close, left, indentation, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, false, false){

                    @Override
                    protected void sep(boolean printFirst, String sep) {
                        boolean newlineAfterSep;
                        boolean newlineBeforeSep;
                        if (sep.equals(",")) {
                            newlineBeforeSep = newlineBeforeComma;
                            newlineAfterSep = newlineAfterComma;
                        } else {
                            newlineBeforeSep = this.newlineBeforeSep;
                            newlineAfterSep = this.newlineAfterSep;
                        }
                        if (this.itemCount == 0) {
                            if (this.newlineAfterOpen) {
                                SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent);
                            }
                        } else if (newlineBeforeSep) {
                            SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent + this.sepIndent);
                        }
                        if (this.itemCount > 0 || printFirst) {
                            SqlPrettyWriter.this.keyword(sep);
                            SqlPrettyWriter.this.nextWhitespace = newlineAfterSep ? NL : " ";
                        }
                        ++this.itemCount;
                    }
                };
            }
        }
        return new FrameImpl(frameType, keyword, open2, close, left, indentation, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, newlineBeforeClose, false);
    }

    private SqlWriterConfig.LineFolding fold(SqlWriter.FrameTypeEnum frameType) {
        switch (frameType) {
            case SELECT_LIST: {
                return this.f3(this.config.selectFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case GROUP_BY_LIST: {
                return this.f3(this.config.groupByFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case ORDER_BY_LIST: {
                return this.f3(this.config.orderByFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case UPDATE_SET_LIST: {
                return this.f3(this.config.updateSetFolding(), this.config.lineFolding(), this.config.updateSetListNewline());
            }
            case WHERE_LIST: {
                return this.f3(this.config.whereFolding(), this.config.lineFolding(), this.config.whereListItemsOnSeparateLines());
            }
            case WINDOW_DECL_LIST: {
                return this.f3(this.config.windowFolding(), this.config.lineFolding(), this.config.clauseStartsLine() && this.config.windowDeclListNewline());
            }
            case WINDOW: {
                return this.f3(this.config.overFolding(), this.config.lineFolding(), this.config.windowNewline());
            }
            case VALUES: {
                return this.f3(this.config.valuesFolding(), this.config.lineFolding(), this.config.valuesListNewline());
            }
            case FROM_LIST: 
            case JOIN: {
                return this.f3(this.config.fromFolding(), this.config.lineFolding(), this.config.caseClausesOnNewLines());
            }
            case CASE: {
                return this.f3(null, null, this.config.caseClausesOnNewLines());
            }
        }
        return SqlWriterConfig.LineFolding.WIDE;
    }

    private SqlWriterConfig.LineFolding f3(SqlWriterConfig.LineFolding folding0, SqlWriterConfig.LineFolding folding1, boolean opt) {
        return folding0 != null ? folding0 : (folding1 != null ? folding1 : (opt ? SqlWriterConfig.LineFolding.TALL : SqlWriterConfig.LineFolding.WIDE));
    }

    protected SqlWriter.Frame startList(SqlWriter.FrameType frameType, String keyword, String open2, String close) {
        assert (frameType != null);
        if (this.frame != null) {
            if (this.frame.itemCount++ == 0 && this.frame.newlineAfterOpen) {
                this.newlineAndIndent();
            } else if (frameType == SqlWriter.FrameTypeEnum.SUB_QUERY && this.config.subQueryStyle() == SqlWriter.SubQueryStyle.BLACK) {
                this.newlineAndIndent(this.currentIndent - this.frame.extraIndent);
            }
            this.currentIndent += this.frame.extraIndent(frameType);
            assert (!this.listStack.contains(this.frame));
            this.listStack.push(this.frame);
        }
        this.frame = this.createListFrame(frameType, keyword, open2, close);
        this.frame.before();
        return this.frame;
    }

    @Override
    public void endList(SqlWriter.Frame frame) {
        FrameImpl endedFrame = (FrameImpl)frame;
        Preconditions.checkArgument(frame == this.frame, "Frame does not match current frame");
        if (this.frame == null) {
            throw new RuntimeException("No list started");
        }
        if (this.frame.open.equals("(") && !this.frame.close.equals(")")) {
            throw new RuntimeException("Expected ')'");
        }
        if (this.frame.newlineBeforeClose) {
            this.newlineAndIndent();
        }
        this.keyword(this.frame.close);
        if (this.frame.newlineAfterClose) {
            this.newlineAndIndent();
        }
        if (this.listStack.isEmpty()) {
            this.frame = null;
            assert (this.currentIndent == 0) : this.currentIndent;
        } else {
            this.frame = this.listStack.pop();
            this.currentIndent -= this.frame.extraIndent(endedFrame.frameType);
        }
    }

    public String format(SqlNode node) {
        assert (this.frame == null);
        node.unparse(this, 0, 0);
        assert (this.frame == null);
        return this.toString();
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public SqlString toSqlString() {
        ImmutableCollection dynamicParameters = this.dynamicParameters == null ? null : this.dynamicParameters.build();
        return new SqlString(this.dialect, this.toString(), (ImmutableList<Integer>)dynamicParameters);
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void literal(String s) {
        this.print(s);
        this.setNeedWhitespace(true);
    }

    @Override
    public void keyword(String s) {
        this.maybeWhitespace(s);
        this.buf.append(this.isKeywordsLowerCase() ? s.toLowerCase(Locale.ROOT) : s.toUpperCase(Locale.ROOT));
        if (!s.equals("")) {
            this.setNeedWhitespace(SqlPrettyWriter.needWhitespaceAfter(s));
        }
    }

    private void maybeWhitespace(String s) {
        if (this.tooLong(s) || this.needWhitespace && SqlPrettyWriter.needWhitespaceBefore(s)) {
            this.whiteSpace();
        }
    }

    private static boolean needWhitespaceBefore(String s) {
        return !s.equals(",") && !s.equals(".") && !s.equals(")") && !s.equals("[") && !s.equals("]") && !s.equals("");
    }

    private static boolean needWhitespaceAfter(String s) {
        return !s.equals("(") && !s.equals("[") && !s.equals(".");
    }

    protected void whiteSpace() {
        if (this.needWhitespace) {
            if (this.nextWhitespace.equals(NL)) {
                this.newlineAndIndent();
            } else {
                this.buf.append(this.nextWhitespace);
            }
            this.nextWhitespace = " ";
            this.setNeedWhitespace(false);
        }
    }

    private int column() {
        return this.buf.length() - this.lineStart;
    }

    protected boolean tooLong(String s) {
        boolean result;
        int lineLength = this.config.lineLength();
        boolean bl = result = lineLength > 0 && this.column() > this.currentIndent && this.column() + s.length() >= lineLength;
        if (result) {
            this.nextWhitespace = NL;
        }
        LOGGER.trace("Token is '{}'; result is {}", (Object)s, (Object)result);
        return result;
    }

    @Override
    public void print(String s) {
        this.maybeWhitespace(s);
        this.buf.append(s);
    }

    @Override
    public void print(int x) {
        this.maybeWhitespace("0");
        this.buf.append(x);
    }

    @Override
    public void identifier(String name, boolean quoted) {
        this.maybeWhitespace(name);
        if (this.isQuoteAllIdentifiers() || quoted) {
            this.dialect.quoteIdentifier(this.buf, name);
        } else {
            this.buf.append(name);
        }
        this.setNeedWhitespace(true);
    }

    @Override
    public void dynamicParam(int index) {
        if (this.dynamicParameters == null) {
            this.dynamicParameters = ImmutableList.builder();
        }
        this.dynamicParameters.add((Object)index);
        this.print("?");
        this.setNeedWhitespace(true);
    }

    @Override
    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        this.dialect.unparseOffsetFetch(this, offset, fetch);
    }

    @Override
    public void topN(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        this.dialect.unparseTopN(this, offset, fetch);
    }

    @Override
    public SqlWriter.Frame startFunCall(String funName) {
        this.keyword(funName);
        this.setNeedWhitespace(false);
        return this.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
    }

    @Override
    public void endFunCall(SqlWriter.Frame frame) {
        this.endList(this.frame);
    }

    @Override
    public SqlWriter.Frame startList(String open2, String close) {
        return this.startList(SqlWriter.FrameTypeEnum.SIMPLE, null, open2, close);
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameTypeEnum frameType) {
        assert (frameType != null);
        return this.startList(frameType, null, "", "");
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameType frameType, String open2, String close) {
        assert (frameType != null);
        return this.startList(frameType, null, open2, close);
    }

    @Override
    public SqlWriter list(SqlWriter.FrameTypeEnum frameType, Consumer<SqlWriter> action) {
        SqlWriter.Frame selectListFrame = this.startList(SqlWriter.FrameTypeEnum.SELECT_LIST);
        SqlPrettyWriter w = this;
        action.accept(w);
        this.endList(selectListFrame);
        return this;
    }

    @Override
    public SqlWriter list(SqlWriter.FrameTypeEnum frameType, SqlBinaryOperator sepOp, SqlNodeList list) {
        SqlWriter.Frame frame = this.startList(frameType);
        ((FrameImpl)frame).list(list, sepOp);
        this.endList(frame);
        return this;
    }

    @Override
    public void sep(String sep) {
        this.sep(sep, !sep.equals(",") && !sep.equals("."));
    }

    @Override
    public void sep(String sep, boolean printFirst) {
        if (this.frame == null) {
            throw new RuntimeException("No list started");
        }
        if (sep.startsWith(" ") || sep.endsWith(" ")) {
            throw new RuntimeException("Separator must not contain whitespace");
        }
        this.frame.sep(printFirst, sep);
    }

    @Override
    public void setNeedWhitespace(boolean needWhitespace) {
        this.needWhitespace = needWhitespace;
    }

    @Deprecated
    public void setLineLength(int lineLength) {
        this.config = this.config.withLineLength(lineLength);
    }

    public void setFormatOptions(SqlFormatOptions options) {
        if (options == null) {
            return;
        }
        this.setAlwaysUseParentheses(options.isAlwaysUseParentheses());
        this.setCaseClausesOnNewLines(options.isCaseClausesOnNewLines());
        this.setClauseStartsLine(options.isClauseStartsLine());
        this.setKeywordsLowerCase(options.isKeywordsLowercase());
        this.setQuoteAllIdentifiers(options.isQuoteAllIdentifiers());
        this.setSelectListItemsOnSeparateLines(options.isSelectListItemsOnSeparateLines());
        this.setWhereListItemsOnSeparateLines(options.isWhereListItemsOnSeparateLines());
        this.setWindowNewline(options.isWindowDeclarationStartsLine());
        this.setWindowDeclListNewline(options.isWindowListItemsOnSeparateLines());
        this.setIndentation(options.getIndentation());
        this.setLineLength(options.getLineLength());
    }

    private static class Bean {
        private final SqlPrettyWriter o;
        private final Map<String, Method> getterMethods = new HashMap<String, Method>();
        private final Map<String, Method> setterMethods = new HashMap<String, Method>();

        Bean(SqlPrettyWriter o) {
            this.o = o;
            for (Method method : o.getClass().getMethods()) {
                String attributeName;
                if (method.getName().startsWith("set") && method.getReturnType() == Void.class && method.getParameterTypes().length == 1) {
                    attributeName = this.stripPrefix(method.getName(), 3);
                    this.setterMethods.put(attributeName, method);
                }
                if (method.getName().startsWith("get") && method.getReturnType() != Void.class && method.getParameterTypes().length == 0) {
                    attributeName = this.stripPrefix(method.getName(), 3);
                    this.getterMethods.put(attributeName, method);
                }
                if (!method.getName().startsWith("is") || method.getReturnType() != Boolean.class || method.getParameterTypes().length != 0) continue;
                attributeName = this.stripPrefix(method.getName(), 2);
                this.getterMethods.put(attributeName, method);
            }
        }

        private String stripPrefix(String name, int offset) {
            return name.substring(offset, offset + 1).toLowerCase(Locale.ROOT) + name.substring(offset + 1);
        }

        public void set(String name, String value) {
            Method method = this.setterMethods.get(name);
            try {
                method.invoke((Object)this.o, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Util.throwAsRuntime(Util.causeOrSelf(e));
            }
        }

        public Object get(String name) {
            Method method = this.getterMethods.get(name);
            try {
                return method.invoke((Object)this.o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Util.throwAsRuntime(Util.causeOrSelf(e));
            }
        }

        public String[] getPropertyNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.getterMethods.keySet());
            names.addAll(this.setterMethods.keySet());
            return names.toArray(new String[0]);
        }
    }

    protected class FrameImpl
    implements SqlWriter.Frame {
        final SqlWriter.FrameType frameType;
        final String keyword;
        final String open;
        final String close;
        private final int left;
        final int extraIndent;
        final int sepIndent;
        int itemCount;
        public final boolean newlineBeforeSep;
        public final boolean newlineAfterSep;
        protected final boolean newlineBeforeClose;
        protected final boolean newlineAfterClose;
        protected final boolean newlineAfterOpen;
        private final int chopLimit;
        private final SqlWriterConfig.LineFolding lineFolding;

        FrameImpl(SqlWriter.FrameType frameType, String keyword, String open2, String close, int left, int extraIndent, int chopLimit, SqlWriterConfig.LineFolding lineFolding, boolean newlineAfterOpen, boolean newlineBeforeSep, int sepIndent, boolean newlineAfterSep, boolean newlineBeforeClose, boolean newlineAfterClose) {
            this.frameType = frameType;
            this.keyword = keyword;
            this.open = open2;
            this.close = close;
            this.left = left;
            this.extraIndent = extraIndent;
            this.chopLimit = chopLimit;
            this.lineFolding = lineFolding;
            this.newlineAfterOpen = newlineAfterOpen;
            this.newlineBeforeSep = newlineBeforeSep;
            this.newlineAfterSep = newlineAfterSep;
            this.newlineBeforeClose = newlineBeforeClose;
            this.newlineAfterClose = newlineAfterClose;
            this.sepIndent = sepIndent;
            assert (chopLimit >= 0 == (lineFolding == SqlWriterConfig.LineFolding.CHOP || lineFolding == SqlWriterConfig.LineFolding.FOLD || lineFolding == SqlWriterConfig.LineFolding.STEP));
        }

        protected void before() {
            if (this.open != null && !this.open.equals("")) {
                SqlPrettyWriter.this.keyword(this.open);
            }
        }

        protected void after() {
        }

        protected void sep(boolean printFirst, String sep) {
            if (this.itemCount == 0) {
                if (this.newlineAfterOpen) {
                    SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent);
                }
            } else if (this.newlineBeforeSep) {
                SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent + this.sepIndent);
            }
            if (this.itemCount > 0 || printFirst) {
                SqlPrettyWriter.this.keyword(sep);
                SqlPrettyWriter.this.nextWhitespace = this.newlineAfterSep ? NL : " ";
            }
            ++this.itemCount;
        }

        int extraIndent(SqlWriter.FrameType subFrameType) {
            if (this.frameType == SqlWriter.FrameTypeEnum.ORDER_BY && subFrameType == SqlWriter.FrameTypeEnum.ORDER_BY_LIST) {
                return SqlPrettyWriter.this.config.indentation();
            }
            if (subFrameType.needsIndent()) {
                return this.extraIndent;
            }
            return 0;
        }

        void list(SqlNodeList list, SqlBinaryOperator sepOp) {
            switch (this.lineFolding) {
                case CHOP: 
                case FOLD: {
                    int sepIndent;
                    boolean newlineAfterSep;
                    boolean newlineBeforeSep;
                    boolean newline;
                    int chopLimit;
                    SqlWriterConfig.LineFolding lineFolding;
                    Save save = new Save();
                    if (this.list2(list, sepOp)) break;
                    save.restore();
                    boolean newlineAfterOpen = SqlPrettyWriter.this.config.clauseEndsLine();
                    if (this.lineFolding == SqlWriterConfig.LineFolding.CHOP) {
                        lineFolding = SqlWriterConfig.LineFolding.TALL;
                        chopLimit = -1;
                    } else {
                        lineFolding = SqlWriterConfig.LineFolding.FOLD;
                        chopLimit = this.chopLimit;
                    }
                    boolean bl = newline = lineFolding == SqlWriterConfig.LineFolding.TALL;
                    if (SqlPrettyWriter.this.config.leadingComma() && newline) {
                        newlineBeforeSep = true;
                        newlineAfterSep = false;
                        sepIndent = -", ".length();
                    } else if (newline) {
                        newlineBeforeSep = false;
                        newlineAfterSep = true;
                        sepIndent = this.sepIndent;
                    } else {
                        newlineBeforeSep = false;
                        newlineAfterSep = false;
                        sepIndent = this.sepIndent;
                    }
                    FrameImpl frame2 = new FrameImpl(this.frameType, this.keyword, this.open, this.close, this.left, this.extraIndent, chopLimit, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, this.newlineBeforeClose, this.newlineAfterClose);
                    frame2.list2(list, sepOp);
                    break;
                }
                default: {
                    this.list2(list, sepOp);
                }
            }
        }

        private boolean list2(SqlNodeList list, SqlBinaryOperator sepOp) {
            int lprec = sepOp.getRightPrec();
            int rprec = sepOp.getLeftPrec();
            if (this.chopLimit < 0) {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    this.sep(false, sepOp.getName());
                    node.unparse(SqlPrettyWriter.this, lprec, rprec);
                }
            } else if (this.newlineBeforeSep) {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    this.sep(false, sepOp.getName());
                    Save prevSize = new Save();
                    node.unparse(SqlPrettyWriter.this, lprec, rprec);
                    if (SqlPrettyWriter.this.column() <= this.chopLimit) continue;
                    if (this.lineFolding == SqlWriterConfig.LineFolding.CHOP || this.lineFolding == SqlWriterConfig.LineFolding.TALL) {
                        return false;
                    }
                    prevSize.restore();
                    SqlPrettyWriter.this.newlineAndIndent();
                    node.unparse(SqlPrettyWriter.this, lprec, rprec);
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    if (i == 0) {
                        this.sep(false, sepOp.getName());
                    }
                    Save save = new Save();
                    node.unparse(SqlPrettyWriter.this, lprec, rprec);
                    if (i + 1 < list.size()) {
                        this.sep(false, sepOp.getName());
                    }
                    if (SqlPrettyWriter.this.column() <= this.chopLimit) continue;
                    switch (this.lineFolding) {
                        case CHOP: {
                            return false;
                        }
                        case FOLD: {
                            if (this.newlineAfterOpen == SqlPrettyWriter.this.config.clauseEndsLine()) break;
                            return false;
                        }
                    }
                    save.restore();
                    SqlPrettyWriter.this.newlineAndIndent();
                    node.unparse(SqlPrettyWriter.this, lprec, rprec);
                    if (i + 1 >= list.size()) continue;
                    this.sep(false, sepOp.getName());
                }
            }
            return true;
        }

        class Save {
            final int bufLength;

            Save() {
                this.bufLength = SqlPrettyWriter.this.buf.length();
            }

            void restore() {
                SqlPrettyWriter.this.buf.setLength(this.bufLength);
            }
        }
    }
}

