/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlAttributeDefinition
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ATTRIBUTE_DEF", SqlKind.ATTRIBUTE_DEF);
    public final SqlIdentifier name;
    public final SqlDataTypeSpec dataType;
    final SqlNode expression;
    final SqlCollation collation;

    SqlAttributeDefinition(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType2, SqlNode expression2, SqlCollation collation) {
        super(pos);
        this.name = name;
        this.dataType = dataType2;
        this.expression = expression2;
        this.collation = collation;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.dataType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, 0, 0);
        this.dataType.unparse(writer, 0, 0);
        if (this.collation != null) {
            writer.keyword("COLLATE");
            this.collation.unparse(writer);
        }
        if (this.dataType.getNullable() != null && !this.dataType.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (this.expression != null) {
            writer.keyword("DEFAULT");
            this.exp(writer);
        }
    }

    private void exp(SqlWriter writer) {
        if (writer.isAlwaysUseParentheses()) {
            this.expression.unparse(writer, 0, 0);
        } else {
            writer.sep("(");
            this.expression.unparse(writer, 0, 0);
            writer.sep(")");
        }
    }
}

