/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedTableAggregationsFunction;
import org.apache.flink.table.runtime.TableAggregateCollector;
import org.apache.flink.table.runtime.aggregate.GeneratedTableAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001=\u0011Ad\u0012:pkB$\u0016M\u00197f\u0003\u001e<\u0007K]8dKN\u001ch)\u001e8di&|gN\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\tQr)\u001a8fe\u0006$X\r\u001a+bE2,\u0017iZ4sK\u001e\fG/[8ogB\u00111GN\u0007\u0002i)\u0011QGB\u0001\u0005kRLG.\u0003\u00028i\t9Aj\\4hS:<\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\u001d,g\u000eV1cY\u0016\fum\u001a:fO\u0006$\u0018n\u001c8t!\tQ3(\u0003\u0002=W\t\u0011s)\u001a8fe\u0006$X\r\u001a+bE2,\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\nhK:,'/\u0019;f%\u0016$(/Y2uS>t\u0007CA\u000eM\u0013\tiEDA\u0004C_>dW-\u00198\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bAb\u001a:pkB\\U-_*ju\u0016\u0004\"aG)\n\u0005Ic\"aA%oi\"AA\u000b\u0001B\u0001B\u0003%Q+\u0001\tnS:\u0014V\r^3oi&|g\u000eV5nKB\u00111DV\u0005\u0003/r\u0011A\u0001T8oO\"A\u0011\f\u0001B\u0001B\u0003%Q+\u0001\tnCb\u0014V\r^3oi&|g\u000eV5nK\")1\f\u0001C\u00019\u00061A(\u001b8jiz\"r!\u00180`A\u0006\u00147\rE\u0002\u0013\u0001UAQ!\u000f.A\u0002iBQA\u0010.A\u0002}BQA\u0013.A\u0002-CQa\u0014.A\u0002ACQ\u0001\u0016.A\u0002UCQ!\u0017.A\u0002UC\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00024\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%\fABZ;oGRLwN\\0%KF$\"A[7\u0011\u0005mY\u0017B\u00017\u001d\u0005\u0011)f.\u001b;\t\u000f9<\u0017\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\u0013A\u0004\u0001\u0019!A!B\u0013y\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011%\u0011\b\u00011AA\u0002\u0013%1/\u0001\u0005gSJ\u001cHOU8x+\u0005Y\u0005\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0003w\u000311\u0017N]:u%><x\fJ3r)\tQw\u000fC\u0004oi\u0006\u0005\t\u0019A&\t\u0013e\u0004\u0001\u0019!A!B\u0013Y\u0015!\u00034jeN$(k\\<!\u0011%Y\b\u00011AA\u0002\u0013%A0A\u0003ti\u0006$X-F\u0001~!\u0015q\u0018QAA\u0005\u001b\u0005y(bA>\u0002\u0002)\u0019\u00111A#\u0002\r\r|W.\\8o\u0013\r\t9a \u0002\u000b-\u0006dW/Z*uCR,\u0007\u0003BA\u0006\u0003\u001fi!!!\u0004\u000b\u0005\u0019B\u0011\u0002BA\t\u0003\u001b\u00111AU8x\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\u0002\u0013M$\u0018\r^3`I\u0015\fHc\u00016\u0002\u001a!Aa.a\u0005\u0002\u0002\u0003\u0007Q\u0010\u0003\u0006\u0002\u001e\u0001\u0001\r\u0011!Q!\nu\faa\u001d;bi\u0016\u0004\u0003bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003G\t\u0001b\u00198u'R\fG/Z\u000b\u0003\u0003K\u0001RA`A\u0003\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0003mC:<'\"\u0001#\n\u0007]\u000bY\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0012\u0001D2oiN#\u0018\r^3`I\u0015\fHc\u00016\u0002:!Ia.a\r\u0002\u0002\u0003\u0007\u0011Q\u0005\u0005\f\u0003{\u0001\u0001\u0019!A!B\u0013\t)#A\u0005d]R\u001cF/\u0019;fA!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0003=\u0019wN\\2bi\u000e{G\u000e\\3di>\u0014XCAA#!\u0011\t9%!\u0013\u000e\u0003\u0011I1!a\u0013\u0005\u0005]!\u0016M\u00197f\u0003\u001e<'/Z4bi\u0016\u001cu\u000e\u001c7fGR|'\u000fC\u0006\u0002P\u0001\u0001\r\u00111A\u0005\n\u0005E\u0013aE2p]\u000e\fGoQ8mY\u0016\u001cGo\u001c:`I\u0015\fHc\u00016\u0002T!Ia.!\u0014\u0002\u0002\u0003\u0007\u0011Q\t\u0005\f\u0003/\u0002\u0001\u0019!A!B\u0013\t)%\u0001\td_:\u001c\u0017\r^\"pY2,7\r^8sA!9\u00111\f\u0001\u0005B\u0005u\u0013\u0001B8qK:$2A[A0\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014AB2p]\u001aLw\r\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t\u0005q\u0001O]8dKN\u001cX\t\\3nK:$Hc\u00026\u0002v\u0005e\u0014Q\u0013\u0005\b\u0003o\ny\u00071\u0001$\u0003\u0019Ig\u000e];u\u0007\"A\u00111PA8\u0001\u0004\ti(A\u0002dib\u0004B!a \u0002\u0012B9\u0011\u0011QAG+\r\u001aSBAAB\u0015\u0011\t))a\"\u0002\u0013\u0019,hn\u0019;j_:\u001c(b\u0001$\u0002\n*\u0019\u00111\u0012\u0005\u0002\u0013M$(/Z1nS:<\u0017\u0002BAH\u0003\u0007\u0013AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0017\u0002BAJ\u0003\u001b\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0018\u0006=\u0004\u0019AAM\u0003\ryW\u000f\u001e\t\u0006\u00037\u000byjI\u0007\u0003\u0003;S!!\u000e\u0005\n\t\u0005\u0005\u0016Q\u0014\u0002\n\u0007>dG.Z2u_JDq!!*\u0001\t\u0003\n9+A\u0004p]RKW.\u001a:\u0015\u000f)\fI+!,\u00026\"9\u00111VAR\u0001\u0004)\u0016!\u0003;j[\u0016\u001cH/Y7q\u0011!\tY(a)A\u0002\u0005=\u0006\u0003BA@\u0003cKA!a-\u0002\u000e\nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAL\u0003G\u0003\r!!'\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\u0006)1\r\\8tKR\t!\u000e")
public class GroupTableAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedTableAggregations>,
Logging {
    private final GeneratedTableAggregationsFunction genTableAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final int groupKeySize;
    private GeneratedTableAggregations function;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private TableAggregateCollector concatCollector;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedTableAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        GroupTableAggProcessFunction groupTableAggProcessFunction = this;
        synchronized (groupTableAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedTableAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedTableAggregations x$1) {
        this.function = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    private TableAggregateCollector concatCollector() {
        return this.concatCollector;
    }

    private void concatCollector_$eq(TableAggregateCollector x$1) {
        this.concatCollector = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling TableAggregateHelper: ").append(this.genTableAggregations.name()).append(" \n\n ").append(new StringBuilder(6).append("Code:\n").append(this.genTableAggregations.code()).toString()).toString());
        Class<GeneratedTableAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genTableAggregations.name(), this.genTableAggregations.code());
        this.LOG().debug("Instantiating TableAggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupTableAggregateState", (TypeInformation)this.aggregationStateType);
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupTableAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.concatCollector_$eq(new TableAggregateCollector(this.groupKeySize));
        this.concatCollector().setResultRow(this.function().createOutputRow());
        this.initCleanupTimeState("GroupTableAggregateCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) {
                return;
            }
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        this.function().setForwardedFields(input, this.concatCollector().getResultRow());
        this.concatCollector().out_$eq(out);
        if (!this.firstRow() && this.generateRetraction && !this.genTableAggregations.emitValuesIncrementally()) {
            this.concatCollector().setChange(false);
            this.function().emit(accumulators, this.concatCollector());
            this.concatCollector().setChange(true);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
        }
        if (!BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.function().emit(accumulators, this.concatCollector());
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
        } else {
            this.state().clear();
            this.cntState().clear();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.stateCleaningEnabled()) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public GroupTableAggProcessFunction(GeneratedTableAggregationsFunction genTableAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, int groupKeySize, long minRetentionTime, long maxRetentionTime) {
        this.genTableAggregations = genTableAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.groupKeySize = groupKeySize;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

