/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\u0013O\u0016tWM]1uKJ+GO]1di&|g\u000e\u0005\u0002\u001c\u0019&\u0011Q\n\b\u0002\b\u0005>|G.Z1o\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016\u0001E7j]J+G/\u001a8uS>tG+[7f!\tY\u0012+\u0003\u0002S9\t!Aj\u001c8h\u0011!!\u0006A!A!\u0002\u0013\u0001\u0016\u0001E7bqJ+G/\u001a8uS>tG+[7f\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019a\u0014N\\5u}Q1\u0001,\u0017.\\9v\u00032A\u0005\u0001\u0016\u0011\u0015IT\u000b1\u0001;\u0011\u0015qT\u000b1\u0001@\u0011\u0015QU\u000b1\u0001L\u0011\u0015yU\u000b1\u0001Q\u0011\u0015!V\u000b1\u0001Q\u0011%y\u0006\u00011AA\u0002\u0013%\u0001-\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u000311WO\\2uS>tw\fJ3r)\t!w\r\u0005\u0002\u001cK&\u0011a\r\b\u0002\u0005+:LG\u000fC\u0004iC\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0013\u0007C\u0005k\u0001\u0001\u0007\t\u0011)Q\u0005_\u0005Ia-\u001e8di&|g\u000e\t\u0005\nY\u0002\u0001\r\u00111A\u0005\n5\faA\\3x%><X#A\u0012\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\u0018A\u00038foJ{wo\u0018\u0013fcR\u0011A-\u001d\u0005\bQ:\f\t\u00111\u0001$\u0011%\u0019\b\u00011A\u0001B\u0003&1%A\u0004oK^\u0014vn\u001e\u0011\t\u0013U\u0004\u0001\u0019!a\u0001\n\u0013i\u0017a\u00029sKZ\u0014vn\u001e\u0005\no\u0002\u0001\r\u00111A\u0005\na\f1\u0002\u001d:fmJ{wo\u0018\u0013fcR\u0011A-\u001f\u0005\bQZ\f\t\u00111\u0001$\u0011%Y\b\u00011A\u0001B\u0003&1%\u0001\u0005qe\u00164(k\\<!\u0011%i\b\u00011AA\u0002\u0013%a0\u0001\u0005gSJ\u001cHOU8x+\u0005Y\u0005bCA\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007\tABZ5sgR\u0014vn^0%KF$2\u0001ZA\u0003\u0011\u001dAw0!AA\u0002-C!\"!\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003L\u0003%1\u0017N]:u%><\b\u0005C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\n\u0005=\u0011!B:uCR,WCAA\t!\u0019\t\u0019\"a\u0007\u0002 5\u0011\u0011Q\u0003\u0006\u0005\u0003\u001b\t9BC\u0002\u0002\u001a\u0015\u000baaY8n[>t\u0017\u0002BA\u000f\u0003+\u0011!BV1mk\u0016\u001cF/\u0019;f!\u0011\t\t#!\n\u000e\u0005\u0005\r\"B\u0001\u0014\t\u0013\u0011\t9#a\t\u0003\u0007I{w\u000fC\u0006\u0002,\u0001\u0001\r\u00111A\u0005\n\u00055\u0012!C:uCR,w\fJ3r)\r!\u0017q\u0006\u0005\nQ\u0006%\u0012\u0011!a\u0001\u0003#A1\"a\r\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0012\u000511\u000f^1uK\u0002B1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:\u0005A1M\u001c;Ti\u0006$X-\u0006\u0002\u0002<A1\u00111CA\u000e\u0003{\u0001B!a\u0010\u0002H5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0003mC:<'\"\u0001#\n\u0007I\u000b\t\u0005C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\n\u00055\u0013\u0001D2oiN#\u0018\r^3`I\u0015\fHc\u00013\u0002P!I\u0001.!\u0013\u0002\u0002\u0003\u0007\u00111\b\u0005\f\u0003'\u0002\u0001\u0019!A!B\u0013\tY$A\u0005d]R\u001cF/\u0019;fA!9\u0011q\u000b\u0001\u0005B\u0005e\u0013\u0001B8qK:$2\u0001ZA.\u0011!\ti&!\u0016A\u0002\u0005}\u0013AB2p]\u001aLw\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005%\u00141\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u00055\u0004\u0001\"\u0011\u0002p\u0005q\u0001O]8dKN\u001cX\t\\3nK:$Hc\u00023\u0002r\u0005U\u0014\u0011\u0013\u0005\b\u0003g\nY\u00071\u0001$\u0003\u0019Ig\u000e];u\u0007\"A\u0011qOA6\u0001\u0004\tI(A\u0002dib\u0004B!a\u001f\u0002\u000eB9\u0011QPAE+\r\u001aSBAA@\u0015\u0011\t\t)a!\u0002\u0013\u0019,hn\u0019;j_:\u001c(b\u0001$\u0002\u0006*\u0019\u0011q\u0011\u0005\u0002\u0013M$(/Z1nS:<\u0017\u0002BAF\u0003\u007f\u0012AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0017\u0002BAH\u0003\u0013\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0014\u0006-\u0004\u0019AAK\u0003\ryW\u000f\u001e\t\u0006\u0003/\u000bYjI\u0007\u0003\u00033S!!\u000e\u0005\n\t\u0005u\u0015\u0011\u0014\u0002\n\u0007>dG.Z2u_JDq!!)\u0001\t\u0003\n\u0019+A\u0004p]RKW.\u001a:\u0015\u000f\u0011\f)+!+\u00022\"9\u0011qUAP\u0001\u0004\u0001\u0016!\u0003;j[\u0016\u001cH/Y7q\u0011!\t9(a(A\u0002\u0005-\u0006\u0003BA>\u0003[KA!a,\u0002\n\nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAJ\u0003?\u0003\r!!&\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\u0006)1\r\\8tKR\tA\r")
public class GroupAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType);
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) {
                return;
            }
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (!BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        } else {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.stateCleaningEnabled()) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

